/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.registry.bootstrap;

import java.util.List;
import liedge.limacore.data.generation.LimaBootstrapUtil;
import liedge.limacore.util.LimaRegistryUtil;
import liedge.limacore.world.generation.RandomAxisScanPlacement;
import liedge.limacore.world.generation.StructurePlacementFilter;
import liedge.ltxindustries.LTXIndustries;
import liedge.ltxindustries.registry.bootstrap.LTXIConfiguredFeatures;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RandomOffsetPlacement;
import net.minecraft.world.level.levelgen.structure.BuiltinStructures;

public final class LTXIPlacedFeatures {
    public static final ResourceKey<PlacedFeature> TITANIUM_ORE_PLACEMENT = LTXIPlacedFeatures.key("titanium_ore");
    public static final ResourceKey<PlacedFeature> NIOBIUM_ORE_PLACEMENT = LTXIPlacedFeatures.key("niobium_ore");
    public static final ResourceKey<PlacedFeature> TITANIUM_CLUSTERS_PLACEMENT = LTXIPlacedFeatures.key("titanium_clusters");
    public static final ResourceKey<PlacedFeature> NIOBIUM_CLUSTERS_PLACEMENT = LTXIPlacedFeatures.key("niobium_clusters");
    public static final ResourceKey<PlacedFeature> SPARK_FRUIT_PLACEMENT = LTXIPlacedFeatures.key("jungle_spark_fruits");
    public static final ResourceKey<PlacedFeature> FORTRESS_BILEVINE = LTXIPlacedFeatures.key("fortress_bilevine");
    public static final ResourceKey<PlacedFeature> BASTION_BILEVINE = LTXIPlacedFeatures.key("bastion_bilevine");
    public static final ResourceKey<PlacedFeature> GLOOM_SHROOM_PLACEMENT = LTXIPlacedFeatures.key("underground_gloom_shrooms");

    private LTXIPlacedFeatures() {
    }

    private static ResourceKey<PlacedFeature> key(String name) {
        return LTXIndustries.RESOURCES.resourceKey(Registries.PLACED_FEATURE, name);
    }

    public static void bootstrap(BootstrapContext<PlacedFeature> context) {
        HolderGetter configs = context.lookup(Registries.CONFIGURED_FEATURE);
        HolderGetter structures = context.lookup(Registries.STRUCTURE);
        PlacedFeature titaniumOre = LimaBootstrapUtil.orePlacement((Holder)configs.getOrThrow(LTXIConfiguredFeatures.TITANIUM_ORE_CONFIG), (int)10, (PlacementModifier)HeightRangePlacement.triangle((VerticalAnchor)VerticalAnchor.BOTTOM, (VerticalAnchor)VerticalAnchor.absolute((int)60)));
        PlacedFeature niobiumOre = LimaBootstrapUtil.orePlacement((Holder)configs.getOrThrow(LTXIConfiguredFeatures.NIOBIUM_ORE_CONFIG), (int)2, (PlacementModifier)HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.BOTTOM, (VerticalAnchor)VerticalAnchor.TOP));
        PlacedFeature titaniumClusters = new PlacedFeature((Holder)configs.getOrThrow(LTXIConfiguredFeatures.TITANIUM_CLUSTERS_CONFIG), List.of(CountPlacement.of((int)8), InSquarePlacement.spread(), HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.BOTTOM, (VerticalAnchor)VerticalAnchor.TOP), RandomAxisScanPlacement.vertical((int)16, (BlockPredicate)LimaBootstrapUtil.replaceableSturdyFaces((boolean)false, (Direction[])new Direction[]{Direction.UP})), BiomeFilter.biome()));
        PlacedFeature niobiumClusters = new PlacedFeature((Holder)configs.getOrThrow(LTXIConfiguredFeatures.NIOBIUM_CLUSTERS_CONFIG), List.of(CountPlacement.of((int)12), InSquarePlacement.spread(), HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.absolute((int)50), (VerticalAnchor)VerticalAnchor.absolute((int)150)), RandomAxisScanPlacement.vertical((int)16, (BlockPredicate)LimaBootstrapUtil.replaceableSturdyFaces()), StructurePlacementFilter.placeInsideStructure((HolderSet)LimaRegistryUtil.keyHolderSet((HolderGetter)structures, (ResourceKey)BuiltinStructures.END_CITY)), BiomeFilter.biome()));
        PlacedFeature sparkFruits = new PlacedFeature((Holder)configs.getOrThrow(LTXIConfiguredFeatures.SPARK_FRUIT_CONFIG), List.of(CountPlacement.of((int)10), InSquarePlacement.spread(), HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.absolute((int)60), (VerticalAnchor)VerticalAnchor.absolute((int)128)), RandomAxisScanPlacement.vertical((int)16, (BlockPredicate)BlockPredicate.allOf((BlockPredicate)BlockPredicate.matchesBlocks((Block[])new Block[]{Blocks.JUNGLE_LEAVES}), (BlockPredicate)LimaBootstrapUtil.isAir((Direction)Direction.DOWN))), RandomOffsetPlacement.vertical((IntProvider)ConstantInt.of((int)-1)), BiomeFilter.biome()));
        PlacedFeature fortressBilevine = new PlacedFeature((Holder)configs.getOrThrow(LTXIConfiguredFeatures.BILEVINE_CONFIG), List.of(CountPlacement.of((int)96), InSquarePlacement.spread(), PlacementUtils.RANGE_BOTTOM_TO_MAX_TERRAIN_HEIGHT, RandomAxisScanPlacement.vertical((int)16, (BlockPredicate)BlockPredicate.allOf((BlockPredicate)BlockPredicate.matchesBlocks((Block[])new Block[]{Blocks.NETHER_BRICKS}), (BlockPredicate)LimaBootstrapUtil.isAir((Direction)Direction.DOWN))), RandomOffsetPlacement.vertical((IntProvider)ConstantInt.of((int)-1)), StructurePlacementFilter.placeInSameChunkAsStructure((HolderSet)LimaRegistryUtil.keyHolderSet((HolderGetter)structures, (ResourceKey)BuiltinStructures.FORTRESS))));
        PlacedFeature bastionBilevine = new PlacedFeature((Holder)configs.getOrThrow(LTXIConfiguredFeatures.BILEVINE_CONFIG), List.of(CountPlacement.of((int)24), InSquarePlacement.spread(), PlacementUtils.RANGE_BOTTOM_TO_MAX_TERRAIN_HEIGHT, RandomAxisScanPlacement.vertical((int)16, (BlockPredicate)LimaBootstrapUtil.replaceableSturdyFaces((Direction[])new Direction[]{Direction.DOWN})), RandomOffsetPlacement.vertical((IntProvider)ConstantInt.of((int)-1)), StructurePlacementFilter.placeInsideStructure((HolderSet)LimaRegistryUtil.keyHolderSet((HolderGetter)structures, (ResourceKey)BuiltinStructures.BASTION_REMNANT))));
        PlacedFeature gloomShrooms = new PlacedFeature((Holder)configs.getOrThrow(LTXIConfiguredFeatures.GLOOM_SHROOM_CONFIG), List.of(CountPlacement.of((int)2), InSquarePlacement.spread(), HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.bottom(), (VerticalAnchor)VerticalAnchor.absolute((int)0)), RandomAxisScanPlacement.vertical((int)16, (BlockPredicate)BlockPredicate.allOf((BlockPredicate)BlockPredicate.matchesBlocks((Block[])new Block[]{Blocks.SCULK}), (BlockPredicate)LimaBootstrapUtil.isAir((Direction)Direction.UP))), RandomOffsetPlacement.vertical((IntProvider)ConstantInt.of((int)1)), BiomeFilter.biome()));
        context.register(TITANIUM_ORE_PLACEMENT, (Object)titaniumOre);
        context.register(NIOBIUM_ORE_PLACEMENT, (Object)niobiumOre);
        context.register(TITANIUM_CLUSTERS_PLACEMENT, (Object)titaniumClusters);
        context.register(NIOBIUM_CLUSTERS_PLACEMENT, (Object)niobiumClusters);
        context.register(SPARK_FRUIT_PLACEMENT, (Object)sparkFruits);
        context.register(FORTRESS_BILEVINE, (Object)fortressBilevine);
        context.register(BASTION_BILEVINE, (Object)bastionBilevine);
        context.register(GLOOM_SHROOM_PLACEMENT, (Object)gloomShrooms);
    }
}

