/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.registry.bootstrap;

import liedge.ltxindustries.LTXIConstants;
import liedge.ltxindustries.LTXIndustries;
import liedge.ltxindustries.recipe.RecipeMode;
import liedge.ltxindustries.registry.LTXIRegistries;
import liedge.ltxindustries.registry.game.LTXIItems;
import liedge.ltxindustries.registry.game.LTXIRecipeTypes;
import net.minecraft.core.Holder;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;

public final class LTXIRecipeModes {
    public static final ResourceKey<RecipeMode> DYE_EXTRACTION = LTXIRecipeModes.key("dye_extraction");
    public static final ResourceKey<RecipeMode> CHEM_DISSOLUTION = LTXIRecipeModes.key("chemical_dissolve");
    public static final ResourceKey<RecipeMode> ECF_ELECTROLYZE = LTXIRecipeModes.key("electrolyze");
    public static final ResourceKey<RecipeMode> GS_FARMING = LTXIRecipeModes.key("farming");
    public static final ResourceKey<RecipeMode> GS_WOODS = LTXIRecipeModes.key("lumber");
    public static final ResourceKey<RecipeMode> GS_ORCHARD = LTXIRecipeModes.key("orchard");
    public static final ResourceKey<RecipeMode> GS_FOLIAGE = LTXIRecipeModes.key("foliage");

    private LTXIRecipeModes() {
    }

    private static ResourceKey<RecipeMode> key(String name) {
        return LTXIndustries.RESOURCES.resourceKey(LTXIRegistries.Keys.RECIPE_MODES, name);
    }

    public static void bootstrap(BootstrapContext<RecipeMode> context) {
        RecipeMode.builder(DYE_EXTRACTION).forTypes(new Holder[]{LTXIRecipeTypes.GRINDING, LTXIRecipeTypes.ELECTRO_CENTRIFUGING, LTXIRecipeTypes.ENERGIZING}).icon((ItemLike)Items.LIME_DYE).register(context);
        RecipeMode.builder(CHEM_DISSOLUTION).forTypes(new Holder[]{LTXIRecipeTypes.ELECTRO_CENTRIFUGING, LTXIRecipeTypes.MIXING, LTXIRecipeTypes.CHEMICAL_REACTING}).icon((ItemLike)LTXIItems.VIRIDIC_ACID_BUCKET).register(context);
        RecipeMode.builder(ECF_ELECTROLYZE).forType((Holder<RecipeType<?>>)LTXIRecipeTypes.ELECTRO_CENTRIFUGING).icon((ItemLike)LTXIItems.ELECTRIC_CHEMICAL).styledName(LTXIConstants.ELECTRIC_GREEN).register(context);
        RecipeMode.builder(GS_FARMING).forType((Holder<RecipeType<?>>)LTXIRecipeTypes.GARDEN_SIMULATING).icon((ItemLike)Items.WHEAT).register(context);
        RecipeMode.builder(GS_WOODS).forType((Holder<RecipeType<?>>)LTXIRecipeTypes.GARDEN_SIMULATING).icon((ItemLike)Items.OAK_LOG).register(context);
        RecipeMode.builder(GS_ORCHARD).forType((Holder<RecipeType<?>>)LTXIRecipeTypes.GARDEN_SIMULATING).icon((ItemLike)Items.APPLE).register(context);
        RecipeMode.builder(GS_FOLIAGE).forType((Holder<RecipeType<?>>)LTXIRecipeTypes.GARDEN_SIMULATING).icon((ItemLike)Items.OAK_LEAVES).register(context);
    }
}

