/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.registry.game;

import com.google.common.collect.ImmutableSet;
import java.util.EnumSet;
import java.util.Set;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import liedge.limacore.blockentity.IOAccess;
import liedge.limacore.blockentity.IOAccessSets;
import liedge.limacore.blockentity.LimaBlockEntity;
import liedge.limacore.blockentity.LimaBlockEntityType;
import liedge.limacore.blockentity.RelativeHorizontalSide;
import liedge.limacore.capability.energy.EnergyHolderBlockEntity;
import liedge.limacore.capability.fluid.FluidHolderBlockEntity;
import liedge.limacore.capability.itemhandler.ItemHolderBlockEntity;
import liedge.ltxindustries.LTXIndustries;
import liedge.ltxindustries.blockentity.AssemblerBlockEntity;
import liedge.ltxindustries.blockentity.AutoFabricatorBlockEntity;
import liedge.ltxindustries.blockentity.BaseTurretBlockEntity;
import liedge.ltxindustries.blockentity.ChemLabBlockEntity;
import liedge.ltxindustries.blockentity.DigitalBlastFurnaceBlockEntity;
import liedge.ltxindustries.blockentity.DigitalFurnaceBlockEntity;
import liedge.ltxindustries.blockentity.DigitalGardenBlockEntity;
import liedge.ltxindustries.blockentity.DigitalSmokerBlockEntity;
import liedge.ltxindustries.blockentity.ElectroCentrifugeBlockEntity;
import liedge.ltxindustries.blockentity.EnergyCellArrayBlockEntity;
import liedge.ltxindustries.blockentity.EquipmentUpgradeStationBlockEntity;
import liedge.ltxindustries.blockentity.FabricatorBlockEntity;
import liedge.ltxindustries.blockentity.GrinderBlockEntity;
import liedge.ltxindustries.blockentity.InfiniteECABlockEntity;
import liedge.ltxindustries.blockentity.MaterialFusingChamberBlockEntity;
import liedge.ltxindustries.blockentity.MeshBlockEntity;
import liedge.ltxindustries.blockentity.MixerBlockEntity;
import liedge.ltxindustries.blockentity.MolecularReconstructorBlockEntity;
import liedge.ltxindustries.blockentity.RailgunTurretBlockEntity;
import liedge.ltxindustries.blockentity.RocketTurretBlockEntity;
import liedge.ltxindustries.blockentity.VoltaicInjectorBlockEntity;
import liedge.ltxindustries.blockentity.base.BlockEntityInputType;
import liedge.ltxindustries.blockentity.base.ConfigurableIOBlockEntityType;
import liedge.ltxindustries.blockentity.base.IOConfigurationRules;
import liedge.ltxindustries.registry.game.LTXIBlocks;
import liedge.ltxindustries.registry.game.LTXIMenus;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public final class LTXIBlockEntities {
    private static final DeferredRegister<BlockEntityType<?>> TYPES = LTXIndustries.RESOURCES.deferredRegister(Registries.BLOCK_ENTITY_TYPE);
    private static final IOConfigurationRules MACHINE_STANDARD_IO = IOConfigurationRules.builder().forAllSides().permits(IOAccessSets.ALL_ALLOWED).withDefaultIOAccess(IOAccess.INPUT_ONLY).allowsAutoOutput().build();
    private static final IOConfigurationRules MACHINE_INPUT_ONLY = IOConfigurationRules.builder().forAllSides().permits(IOAccessSets.INPUT_ONLY_OR_DISABLED).withDefaultIOAccess(IOAccess.INPUT_ONLY).build();
    private static final Set<RelativeHorizontalSide> FABRICATOR_VALID_SIDES = ImmutableSet.copyOf(EnumSet.of(RelativeHorizontalSide.BOTTOM, RelativeHorizontalSide.FRONT, RelativeHorizontalSide.REAR, RelativeHorizontalSide.LEFT));
    private static final IOConfigurationRules FABRICATOR_ITEM_RULES = IOConfigurationRules.builder().forSides(FABRICATOR_VALID_SIDES).permits(IOAccessSets.OUTPUT_ONLY_OR_DISABLED).withDefaultIOAccess(IOAccess.OUTPUT_ONLY).allowsAutoOutput().build();
    private static final IOConfigurationRules FABRICATOR_ENERGY_RULES = IOConfigurationRules.builder().forSides(FABRICATOR_VALID_SIDES).permits(IOAccessSets.INPUT_ONLY_OR_DISABLED).withDefaultIOAccess(IOAccess.INPUT_ONLY).build();
    private static final Set<RelativeHorizontalSide> DOUBLE_BLOCK_VALID_SIDES = ImmutableSet.copyOf(EnumSet.of(RelativeHorizontalSide.BOTTOM, RelativeHorizontalSide.FRONT, RelativeHorizontalSide.REAR, RelativeHorizontalSide.LEFT, RelativeHorizontalSide.RIGHT));
    private static final IOConfigurationRules DOUBLE_MACHINE_ENERGY_RULES = IOConfigurationRules.builder().forSides(DOUBLE_BLOCK_VALID_SIDES).permits(IOAccessSets.INPUT_ONLY_OR_DISABLED).withDefaultIOAccess(IOAccess.INPUT_ONLY).build();
    private static final IOConfigurationRules DOUBLE_MACHINE_ITEM_RULES = IOConfigurationRules.builder().forSides(DOUBLE_BLOCK_VALID_SIDES).permits(IOAccessSets.ALL_ALLOWED).withDefaultIOAccess(IOAccess.INPUT_ONLY).allowsAutoOutput().build();
    private static final IOConfigurationRules TURRET_ITEM_RULES = IOConfigurationRules.builder().forSides(DOUBLE_BLOCK_VALID_SIDES).permits(IOAccessSets.OUTPUT_ONLY_OR_DISABLED).withDefaultIOAccess(IOAccess.OUTPUT_ONLY).allowsAutoOutput().build();
    public static final DeferredHolder<BlockEntityType<?>, LimaBlockEntityType<EquipmentUpgradeStationBlockEntity>> EQUIPMENT_UPGRADE_STATION = TYPES.register("equipment_upgrade_station", () -> LimaBlockEntityType.of(EquipmentUpgradeStationBlockEntity::new, LTXIBlocks.EQUIPMENT_UPGRADE_STATION, LTXIMenus.EQUIPMENT_UPGRADE_STATION));
    public static final DeferredHolder<BlockEntityType<?>, ConfigurableIOBlockEntityType<EnergyCellArrayBlockEntity>> ENERGY_CELL_ARRAY = TYPES.register("energy_cell_array", () -> ((ConfigurableIOBlockEntityType.Builder)((ConfigurableIOBlockEntityType.Builder)ConfigurableIOBlockEntityType.sidedBuilder(EnergyCellArrayBlockEntity::new).withBlock((Holder)LTXIBlocks.ENERGY_CELL_ARRAY)).hasMenu((Holder)LTXIMenus.ENERGY_CELL_ARRAY)).withConfigRules(BlockEntityInputType.ITEMS, MACHINE_STANDARD_IO).withConfigRules(BlockEntityInputType.ENERGY, builder -> builder.forAllSides().permits(IOAccessSets.INPUT_XOR_OUTPUT_OR_DISABLED).withDefaultIOAccess(IOAccess.INPUT_ONLY).autoOutputByDefault()).build());
    public static final DeferredHolder<BlockEntityType<?>, ConfigurableIOBlockEntityType<InfiniteECABlockEntity>> INFINITE_ENERGY_CELL_ARRAY = TYPES.register("infinite_energy_cell_array", () -> ((ConfigurableIOBlockEntityType.Builder)((ConfigurableIOBlockEntityType.Builder)ConfigurableIOBlockEntityType.sidedBuilder(InfiniteECABlockEntity::new).withBlock((Holder)LTXIBlocks.INFINITE_ENERGY_CELL_ARRAY)).hasMenu((Holder)LTXIMenus.ENERGY_CELL_ARRAY)).withConfigRules(BlockEntityInputType.ITEMS, MACHINE_STANDARD_IO).withConfigRules(BlockEntityInputType.ENERGY, builder -> builder.forAllSides().permits(IOAccessSets.OUTPUT_ONLY_OR_DISABLED).withDefaultIOAccess(IOAccess.OUTPUT_ONLY).autoOutputByDefault()).build());
    public static final DeferredHolder<BlockEntityType<?>, ConfigurableIOBlockEntityType<DigitalFurnaceBlockEntity>> DIGITAL_FURNACE = LTXIBlockEntities.registerItemEnergyMachine("digital_furnace", DigitalFurnaceBlockEntity::new, builder -> (ConfigurableIOBlockEntityType.Builder)((ConfigurableIOBlockEntityType.Builder)builder.withBlock((Holder)LTXIBlocks.DIGITAL_FURNACE)).hasMenu((Holder)LTXIMenus.DIGITAL_FURNACE));
    public static final DeferredHolder<BlockEntityType<?>, ConfigurableIOBlockEntityType<DigitalSmokerBlockEntity>> DIGITAL_SMOKER = LTXIBlockEntities.registerItemEnergyMachine("digital_smoker", DigitalSmokerBlockEntity::new, builder -> (ConfigurableIOBlockEntityType.Builder)((ConfigurableIOBlockEntityType.Builder)builder.withBlock((Holder)LTXIBlocks.DIGITAL_SMOKER)).hasMenu((Holder)LTXIMenus.DIGITAL_SMOKER));
    public static final DeferredHolder<BlockEntityType<?>, ConfigurableIOBlockEntityType<DigitalBlastFurnaceBlockEntity>> DIGITAL_BLAST_FURNACE = LTXIBlockEntities.registerItemEnergyMachine("digital_blast_furnace", DigitalBlastFurnaceBlockEntity::new, builder -> (ConfigurableIOBlockEntityType.Builder)((ConfigurableIOBlockEntityType.Builder)builder.withBlock((Holder)LTXIBlocks.DIGITAL_BLAST_FURNACE)).hasMenu((Holder)LTXIMenus.DIGITAL_BLAST_FURNACE));
    public static final DeferredHolder<BlockEntityType<?>, ConfigurableIOBlockEntityType<GrinderBlockEntity>> GRINDER = LTXIBlockEntities.registerItemEnergyMachine("grinder", GrinderBlockEntity::new, builder -> (ConfigurableIOBlockEntityType.Builder)((ConfigurableIOBlockEntityType.Builder)builder.withBlock((Holder)LTXIBlocks.GRINDER)).hasMenu((Holder)LTXIMenus.GRINDER));
    public static final DeferredHolder<BlockEntityType<?>, ConfigurableIOBlockEntityType<MaterialFusingChamberBlockEntity>> MATERIAL_FUSING_CHAMBER = LTXIBlockEntities.registerItemEnergyFluidMachine("material_fusing_chamber", MaterialFusingChamberBlockEntity::new, MACHINE_STANDARD_IO, MACHINE_INPUT_ONLY, MACHINE_INPUT_ONLY, builder -> (ConfigurableIOBlockEntityType.Builder)((ConfigurableIOBlockEntityType.Builder)builder.withBlock((Holder)LTXIBlocks.MATERIAL_FUSING_CHAMBER)).hasMenu((Holder)LTXIMenus.MATERIAL_FUSING_CHAMBER));
    public static final DeferredHolder<BlockEntityType<?>, ConfigurableIOBlockEntityType<ElectroCentrifugeBlockEntity>> ELECTROCENTRIFUGE = LTXIBlockEntities.registerItemEnergyFluidMachine("electrocentrifuge", ElectroCentrifugeBlockEntity::new, MACHINE_STANDARD_IO, MACHINE_INPUT_ONLY, MACHINE_STANDARD_IO, builder -> (ConfigurableIOBlockEntityType.Builder)((ConfigurableIOBlockEntityType.Builder)builder.withBlock((Holder)LTXIBlocks.ELECTROCENTRIFUGE)).hasMenu((Holder)LTXIMenus.ELECTROCENTRIFUGE));
    public static final DeferredHolder<BlockEntityType<?>, ConfigurableIOBlockEntityType<MixerBlockEntity>> MIXER = LTXIBlockEntities.registerItemEnergyFluidMachine("mixer", MixerBlockEntity::new, MACHINE_STANDARD_IO, MACHINE_INPUT_ONLY, MACHINE_STANDARD_IO, builder -> (ConfigurableIOBlockEntityType.Builder)((ConfigurableIOBlockEntityType.Builder)builder.withBlock((Holder)LTXIBlocks.MIXER)).hasMenu((Holder)LTXIMenus.MIXER));
    public static final DeferredHolder<BlockEntityType<?>, ConfigurableIOBlockEntityType<VoltaicInjectorBlockEntity>> VOLTAIC_INJECTOR = LTXIBlockEntities.registerItemEnergyMachine("voltaic_injector", VoltaicInjectorBlockEntity::new, builder -> (ConfigurableIOBlockEntityType.Builder)((ConfigurableIOBlockEntityType.Builder)builder.withBlock((Holder)LTXIBlocks.VOLTAIC_INJECTOR)).hasMenu((Holder)LTXIMenus.VOLTAIC_INJECTOR));
    public static final DeferredHolder<BlockEntityType<?>, ConfigurableIOBlockEntityType<ChemLabBlockEntity>> CHEM_LAB = LTXIBlockEntities.registerItemEnergyFluidMachine("chem_lab", ChemLabBlockEntity::new, MACHINE_STANDARD_IO, MACHINE_INPUT_ONLY, MACHINE_STANDARD_IO, builder -> (ConfigurableIOBlockEntityType.Builder)((ConfigurableIOBlockEntityType.Builder)builder.withBlock((Holder)LTXIBlocks.CHEM_LAB)).hasMenu((Holder)LTXIMenus.CHEM_LAB));
    public static final DeferredHolder<BlockEntityType<?>, ConfigurableIOBlockEntityType<AssemblerBlockEntity>> ASSEMBLER = LTXIBlockEntities.registerItemEnergyFluidMachine("assembler", AssemblerBlockEntity::new, MACHINE_STANDARD_IO, MACHINE_INPUT_ONLY, MACHINE_INPUT_ONLY, builder -> (ConfigurableIOBlockEntityType.Builder)((ConfigurableIOBlockEntityType.Builder)builder.withBlock((Holder)LTXIBlocks.ASSEMBLER)).hasMenu((Holder)LTXIMenus.ASSEMBLER));
    public static final DeferredHolder<BlockEntityType<?>, ConfigurableIOBlockEntityType<FabricatorBlockEntity>> FABRICATOR = LTXIBlockEntities.registerItemEnergyMachine("fabricator", FabricatorBlockEntity::new, FABRICATOR_ITEM_RULES, FABRICATOR_ENERGY_RULES, builder -> (ConfigurableIOBlockEntityType.Builder)((ConfigurableIOBlockEntityType.Builder)builder.withBlock((Holder)LTXIBlocks.FABRICATOR)).hasMenu((Holder)LTXIMenus.FABRICATOR));
    public static final DeferredHolder<BlockEntityType<?>, ConfigurableIOBlockEntityType<AutoFabricatorBlockEntity>> AUTO_FABRICATOR = LTXIBlockEntities.registerItemEnergyMachine("auto_fabricator", AutoFabricatorBlockEntity::new, builder -> (ConfigurableIOBlockEntityType.Builder)((ConfigurableIOBlockEntityType.Builder)builder.withBlock((Holder)LTXIBlocks.AUTO_FABRICATOR)).hasMenu((Holder)LTXIMenus.AUTO_FABRICATOR));
    public static final DeferredHolder<BlockEntityType<?>, ConfigurableIOBlockEntityType<MolecularReconstructorBlockEntity>> MOLECULAR_RECONSTRUCTOR = LTXIBlockEntities.registerItemEnergyMachine("molecular_reconstructor", MolecularReconstructorBlockEntity::new, DOUBLE_MACHINE_ITEM_RULES, DOUBLE_MACHINE_ENERGY_RULES, builder -> (ConfigurableIOBlockEntityType.Builder)((ConfigurableIOBlockEntityType.Builder)builder.withBlock((Holder)LTXIBlocks.MOLECULAR_RECONSTRUCTOR)).hasMenu((Holder)LTXIMenus.MOLECULAR_RECONSTRUCTOR));
    public static final DeferredHolder<BlockEntityType<?>, ConfigurableIOBlockEntityType<DigitalGardenBlockEntity>> DIGITAL_GARDEN = LTXIBlockEntities.registerItemEnergyFluidMachine("digital_garden", DigitalGardenBlockEntity::new, DOUBLE_MACHINE_ITEM_RULES, DOUBLE_MACHINE_ENERGY_RULES, DOUBLE_MACHINE_ENERGY_RULES, builder -> (ConfigurableIOBlockEntityType.Builder)((ConfigurableIOBlockEntityType.Builder)builder.withBlock((Holder)LTXIBlocks.DIGITAL_GARDEN)).hasMenu((Holder)LTXIMenus.DIGITAL_GARDEN));
    public static final DeferredHolder<BlockEntityType<?>, ConfigurableIOBlockEntityType<RocketTurretBlockEntity>> ROCKET_TURRET = LTXIBlockEntities.registerTurret("rocket_turret", RocketTurretBlockEntity::new, builder -> (ConfigurableIOBlockEntityType.Builder)((ConfigurableIOBlockEntityType.Builder)builder.withBlock((Holder)LTXIBlocks.ROCKET_TURRET)).hasMenu((Holder)LTXIMenus.ROCKET_TURRET));
    public static final DeferredHolder<BlockEntityType<?>, ConfigurableIOBlockEntityType<RailgunTurretBlockEntity>> RAILGUN_TURRET = LTXIBlockEntities.registerTurret("railgun_turret", RailgunTurretBlockEntity::new, builder -> (ConfigurableIOBlockEntityType.Builder)((ConfigurableIOBlockEntityType.Builder)builder.withBlock((Holder)LTXIBlocks.RAILGUN_TURRET)).hasMenu((Holder)LTXIMenus.RAILGUN_TURRET));
    public static final DeferredHolder<BlockEntityType<?>, LimaBlockEntityType<MeshBlockEntity>> MESH_BLOCK = TYPES.register("mesh_block", () -> LimaBlockEntityType.of(MeshBlockEntity::new, LTXIBlocks.MESH_BLOCK));

    private LTXIBlockEntities() {
    }

    public static void register(IEventBus bus) {
        TYPES.register(bus);
        bus.addListener(RegisterCapabilitiesEvent.class, LTXIBlockEntities::registerCapabilities);
    }

    private static void registerCapabilities(RegisterCapabilitiesEvent event) {
        Stream.of(ENERGY_CELL_ARRAY, INFINITE_ENERGY_CELL_ARRAY, DIGITAL_FURNACE, DIGITAL_SMOKER, DIGITAL_BLAST_FURNACE, GRINDER, VOLTAIC_INJECTOR, FABRICATOR, AUTO_FABRICATOR, MOLECULAR_RECONSTRUCTOR, ROCKET_TURRET, RAILGUN_TURRET).map(DeferredHolder::get).forEach(type -> LTXIBlockEntities.registerItemEnergyCaps(event, type));
        Stream.of(MATERIAL_FUSING_CHAMBER, ELECTROCENTRIFUGE, MIXER, CHEM_LAB).map(DeferredHolder::get).forEach(type -> LTXIBlockEntities.registerItemEnergyFluidCaps(event, type));
    }

    private static <T extends LimaBlockEntity & EnergyHolderBlockEntity> void registerItemEnergyCaps(RegisterCapabilitiesEvent event, BlockEntityType<? extends T> type) {
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, type, (rec$, x$0) -> ((ItemHolderBlockEntity)rec$).createItemIOWrapper(x$0));
        event.registerBlockEntity(Capabilities.EnergyStorage.BLOCK, type, (rec$, x$0) -> ((EnergyHolderBlockEntity)rec$).createEnergyIOWrapper(x$0));
    }

    private static <T extends LimaBlockEntity & EnergyHolderBlockEntity> void registerItemEnergyFluidCaps(RegisterCapabilitiesEvent event, BlockEntityType<? extends T> type) {
        LTXIBlockEntities.registerItemEnergyCaps(event, type);
        event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, type, (rec$, x$0) -> ((FluidHolderBlockEntity)rec$).createFluidIOWrapper(x$0));
    }

    private static <BE extends LimaBlockEntity> DeferredHolder<BlockEntityType<?>, ConfigurableIOBlockEntityType<BE>> registerItemEnergyMachine(String name, BlockEntityType.BlockEntitySupplier<BE> beFactory, IOConfigurationRules itemRules, IOConfigurationRules energyRules, UnaryOperator<ConfigurableIOBlockEntityType.Builder<BE>> builderOp) {
        return TYPES.register(name, () -> ((ConfigurableIOBlockEntityType.Builder)((Object)((Object)builderOp.apply(ConfigurableIOBlockEntityType.sidedBuilder(beFactory))))).withConfigRules(BlockEntityInputType.ITEMS, itemRules).withConfigRules(BlockEntityInputType.ENERGY, energyRules).build());
    }

    private static <BE extends LimaBlockEntity> DeferredHolder<BlockEntityType<?>, ConfigurableIOBlockEntityType<BE>> registerItemEnergyFluidMachine(String name, BlockEntityType.BlockEntitySupplier<BE> beFactory, IOConfigurationRules itemRules, IOConfigurationRules energyRules, IOConfigurationRules fluidRules, UnaryOperator<ConfigurableIOBlockEntityType.Builder<BE>> builderOp) {
        return TYPES.register(name, () -> ((ConfigurableIOBlockEntityType.Builder)((Object)((Object)builderOp.apply(ConfigurableIOBlockEntityType.sidedBuilder(beFactory))))).withConfigRules(BlockEntityInputType.ITEMS, itemRules).withConfigRules(BlockEntityInputType.ENERGY, energyRules).withConfigRules(BlockEntityInputType.FLUIDS, fluidRules).build());
    }

    private static <BE extends LimaBlockEntity> DeferredHolder<BlockEntityType<?>, ConfigurableIOBlockEntityType<BE>> registerItemEnergyMachine(String name, BlockEntityType.BlockEntitySupplier<BE> beFactory, UnaryOperator<ConfigurableIOBlockEntityType.Builder<BE>> builderOp) {
        return LTXIBlockEntities.registerItemEnergyMachine(name, beFactory, MACHINE_STANDARD_IO, MACHINE_INPUT_ONLY, builderOp);
    }

    private static <BE extends BaseTurretBlockEntity> DeferredHolder<BlockEntityType<?>, ConfigurableIOBlockEntityType<BE>> registerTurret(String name, BlockEntityType.BlockEntitySupplier<BE> beFactory, UnaryOperator<ConfigurableIOBlockEntityType.Builder<BE>> builderOp) {
        return LTXIBlockEntities.registerItemEnergyMachine(name, beFactory, TURRET_ITEM_RULES, DOUBLE_MACHINE_ENERGY_RULES, builderOp);
    }
}

