/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.registry.game;

import java.util.Collection;
import java.util.Map;
import java.util.function.Supplier;
import liedge.limacore.registry.DeferredBlockWithItem;
import liedge.limacore.registry.LimaDeferredBlocksWithItems;
import liedge.limacore.util.LimaCollectionsUtil;
import liedge.ltxindustries.LTXIndustries;
import liedge.ltxindustries.block.BerryVinesBlock;
import liedge.ltxindustries.block.BerryVinesPlantBlock;
import liedge.ltxindustries.block.EnergyCellArrayBlock;
import liedge.ltxindustries.block.EquipmentUpgradeStationBlock;
import liedge.ltxindustries.block.FabricatorBlock;
import liedge.ltxindustries.block.GloomShroomBlock;
import liedge.ltxindustries.block.LTXIBlockShapes;
import liedge.ltxindustries.block.MeshBlock;
import liedge.ltxindustries.block.NeonLightColor;
import liedge.ltxindustries.block.PrimaryMeshBlock;
import liedge.ltxindustries.block.SparkFruitBlock;
import liedge.ltxindustries.block.StateMachineBlock;
import liedge.ltxindustries.block.SurfaceStickingBlock;
import liedge.ltxindustries.block.mesh.LTXIBlockMeshes;
import liedge.ltxindustries.item.ContentsTooltipBlockItem;
import liedge.ltxindustries.item.ECABlockItem;
import liedge.ltxindustries.item.EnergyHolderItem;
import liedge.ltxindustries.item.InfiniteECABlockItem;
import liedge.ltxindustries.item.LTXIItemRarities;
import liedge.ltxindustries.registry.game.LTXIFluids;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CaveVines;
import net.minecraft.world.level.block.DropExperienceBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.TransparentBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredHolder;

public final class LTXIBlocks {
    private static final LimaDeferredBlocksWithItems BLOCKS = LTXIndustries.RESOURCES.deferredBlocksWithItems();
    private static final BlockBehaviour.StatePredicate NEVER = (state, level, pos) -> false;
    public static final DeferredBlockWithItem<DropExperienceBlock, BlockItem> TITANIUM_ORE = BLOCKS.registerBlockAndSimpleItem("titanium_ore", () -> new DropExperienceBlock((IntProvider)ConstantInt.of((int)0), BlockBehaviour.Properties.of().mapColor(MapColor.STONE).strength(3.0f).requiresCorrectToolForDrops()));
    public static final DeferredBlockWithItem<DropExperienceBlock, BlockItem> DEEPSLATE_TITANIUM_ORE = BLOCKS.registerBlockAndSimpleItem("deepslate_titanium_ore", () -> new DropExperienceBlock((IntProvider)ConstantInt.of((int)0), BlockBehaviour.Properties.of().mapColor(MapColor.DEEPSLATE).strength(4.5f, 3.0f).sound(SoundType.DEEPSLATE).requiresCorrectToolForDrops()));
    public static final DeferredBlockWithItem<DropExperienceBlock, BlockItem> NIOBIUM_ORE = BLOCKS.registerBlockAndSimpleItem("niobium_ore", () -> new DropExperienceBlock((IntProvider)UniformInt.of((int)1, (int)4), BlockBehaviour.Properties.of().mapColor(MapColor.SAND).strength(3.2f, 9.0f).requiresCorrectToolForDrops()));
    public static final DeferredBlockWithItem<Block, BlockItem> RAW_TITANIUM_BLOCK = BLOCKS.registerSimpleBlockAndItem("raw_titanium_block", BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_LIGHT_GRAY).strength(5.0f, 6.0f).requiresCorrectToolForDrops());
    public static final DeferredBlockWithItem<Block, BlockItem> RAW_NIOBIUM_BLOCK = BLOCKS.registerSimpleBlockAndItem("raw_niobium_block", BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_PURPLE).strength(5.0f, 9.0f).requiresCorrectToolForDrops());
    public static final DeferredBlockWithItem<SurfaceStickingBlock, BlockItem> RAW_TITANIUM_CLUSTER = BLOCKS.registerBlockAndSimpleItem("raw_titanium_cluster", () -> new SurfaceStickingBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_LIGHT_GRAY).strength(5.0f, 6.0f).requiresCorrectToolForDrops().noOcclusion(), LTXIBlockShapes.RAW_ORE_CLUSTER, false));
    public static final DeferredBlockWithItem<SurfaceStickingBlock, BlockItem> RAW_NIOBIUM_CLUSTER = BLOCKS.registerBlockAndSimpleItem("raw_niobium_cluster", () -> new SurfaceStickingBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_PURPLE).strength(5.0f, 9.0f).requiresCorrectToolForDrops().noOcclusion(), LTXIBlockShapes.RAW_ORE_CLUSTER, false));
    public static final DeferredBlockWithItem<Block, BlockItem> TITANIUM_BLOCK = BLOCKS.registerSimpleBlockAndItem("titanium_block", BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_LIGHT_GRAY).strength(5.0f, 6.0f).sound(SoundType.METAL).requiresCorrectToolForDrops());
    public static final DeferredBlockWithItem<Block, BlockItem> NIOBIUM_BLOCK = BLOCKS.registerSimpleBlockAndItem("niobium_block", BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_LIGHT_GRAY).strength(6.0f, 9.0f).sound(SoundType.METAL).requiresCorrectToolForDrops());
    public static final DeferredBlockWithItem<Block, BlockItem> SLATESTEEL_BLOCK = BLOCKS.registerSimpleBlockAndItem("slatesteel_block", BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_LIGHT_GRAY).strength(5.0f, 12.0f).sound(SoundType.METAL).requiresCorrectToolForDrops());
    public static final Map<NeonLightColor, DeferredBlock<Block>> NEON_LIGHTS = LimaCollectionsUtil.fillAndCreateImmutableEnumMap(NeonLightColor.class, color -> BLOCKS.registerSimpleBlockAndItem(color.toString() + "_neon_light", LTXIBlocks.neonLightProperties().mapColor(color.getMapColor())));
    public static final DeferredBlockWithItem<Block, BlockItem> TITANIUM_PANEL = BLOCKS.registerSimpleBlockAndItem("titanium_panel", BlockBehaviour.Properties.of().mapColor(DyeColor.WHITE).strength(2.0f).sound(SoundType.COPPER).requiresCorrectToolForDrops());
    public static final DeferredBlockWithItem<Block, BlockItem> SMOOTH_TITANIUM_PANEL = BLOCKS.registerSimpleBlockAndItem("smooth_titanium_panel", BlockBehaviour.Properties.of().mapColor(DyeColor.WHITE).strength(2.0f).sound(SoundType.COPPER).requiresCorrectToolForDrops());
    public static final DeferredBlockWithItem<Block, BlockItem> TITANIUM_GLASS = BLOCKS.registerBlockAndSimpleItem("titanium_glass", () -> new TransparentBlock(LTXIBlocks.quartzGlassProperties()), new Item.Properties());
    public static final DeferredBlockWithItem<Block, BlockItem> SLATESTEEL_PANEL = BLOCKS.registerSimpleBlockAndItem("slatesteel_panel", BlockBehaviour.Properties.of().mapColor(DyeColor.GRAY).strength(3.0f).sound(SoundType.METAL).requiresCorrectToolForDrops());
    public static final DeferredBlockWithItem<Block, BlockItem> SMOOTH_SLATESTEEL_PANEL = BLOCKS.registerSimpleBlockAndItem("smooth_slatesteel_panel", BlockBehaviour.Properties.of().mapColor(DyeColor.GRAY).strength(3.0f).sound(SoundType.METAL).requiresCorrectToolForDrops());
    public static final DeferredBlock<SparkFruitBlock> SPARK_FRUIT = BLOCKS.registerBlock("spark_fruit", SparkFruitBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).randomTicks().strength(0.2f, 3.0f).sound(SoundType.WET_GRASS).noOcclusion().pushReaction(PushReaction.DESTROY).lightLevel(state -> (Integer)state.getValue((Property)BlockStateProperties.AGE_2) == 2 ? 7 : 0));
    public static final DeferredBlock<BerryVinesBlock> BILEVINE = BLOCKS.registerBlock("bilevine", BerryVinesBlock::new, LTXIBlocks.berryVinesProperties());
    public static final DeferredBlock<BerryVinesPlantBlock> BILEVINE_PLANT = BLOCKS.registerBlock("bilevine_plant", BerryVinesPlantBlock::new, LTXIBlocks.berryVinesProperties());
    public static final DeferredBlock<GloomShroomBlock> GLOOM_SHROOM = BLOCKS.registerBlock("gloom_shroom", GloomShroomBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BLUE).instabreak().noCollission().sound(SoundType.FUNGUS).pushReaction(PushReaction.DESTROY));
    public static final DeferredBlockWithItem<EquipmentUpgradeStationBlock, BlockItem> EQUIPMENT_UPGRADE_STATION = BLOCKS.registerBlockAndSimpleItem("equipment_upgrade_station", () -> new EquipmentUpgradeStationBlock(LTXIBlocks.machineProperties().noOcclusion()), new Item.Properties().stacksTo(1));
    public static final DeferredBlockWithItem<EnergyCellArrayBlock, ECABlockItem> ENERGY_CELL_ARRAY = BLOCKS.registerBlockAndItem("energy_cell_array", () -> new EnergyCellArrayBlock(LTXIBlocks.machineProperties().noOcclusion()), block -> new ECABlockItem((Block)block, new Item.Properties().stacksTo(1)));
    public static final DeferredBlockWithItem<EnergyCellArrayBlock, InfiniteECABlockItem> INFINITE_ENERGY_CELL_ARRAY = BLOCKS.registerBlockAndItem("infinite_energy_cell_array", () -> new EnergyCellArrayBlock(LTXIBlocks.machineProperties().noOcclusion()), block -> new InfiniteECABlockItem((Block)block, new Item.Properties().stacksTo(1).rarity(Rarity.EPIC)));
    public static final DeferredBlockWithItem<StateMachineBlock, BlockItem> DIGITAL_FURNACE = LTXIBlocks.registerWithEnergyTooltip("digital_furnace", () -> StateMachineBlock.staticShape(LTXIBlocks.machineProperties(), LTXIBlockShapes.COOKING_MACHINE, false));
    public static final DeferredBlockWithItem<StateMachineBlock, BlockItem> DIGITAL_SMOKER = LTXIBlocks.registerWithEnergyTooltip("digital_smoker", () -> StateMachineBlock.staticShape(LTXIBlocks.machineProperties(), LTXIBlockShapes.COOKING_MACHINE, false));
    public static final DeferredBlockWithItem<StateMachineBlock, BlockItem> DIGITAL_BLAST_FURNACE = LTXIBlocks.registerWithEnergyTooltip("digital_blast_furnace", () -> StateMachineBlock.staticShape(LTXIBlocks.machineProperties(), LTXIBlockShapes.COOKING_MACHINE, false));
    public static final DeferredBlockWithItem<StateMachineBlock, BlockItem> GRINDER = LTXIBlocks.registerWithEnergyTooltip("grinder", () -> StateMachineBlock.staticShape(LTXIBlocks.machineProperties(), LTXIBlockShapes.COOKING_MACHINE, false));
    public static final DeferredBlockWithItem<StateMachineBlock, BlockItem> MATERIAL_FUSING_CHAMBER = LTXIBlocks.registerWithEnergyTooltip("material_fusing_chamber", () -> StateMachineBlock.staticShape(LTXIBlocks.machineProperties(), LTXIBlockShapes.COOKING_MACHINE, false));
    public static final DeferredBlockWithItem<StateMachineBlock, BlockItem> ELECTROCENTRIFUGE = LTXIBlocks.registerWithEnergyTooltip("electrocentrifuge", () -> StateMachineBlock.staticShape(LTXIBlocks.machineProperties().noOcclusion(), LTXIBlockShapes.ELECTROCENTRIFUGE, true));
    public static final DeferredBlockWithItem<StateMachineBlock, BlockItem> MIXER = LTXIBlocks.registerWithEnergyTooltip("mixer", () -> StateMachineBlock.rotatingShape(LTXIBlocks.machineProperties().noOcclusion(), LTXIBlockShapes.MIXER, true));
    public static final DeferredBlockWithItem<StateMachineBlock, BlockItem> VOLTAIC_INJECTOR = LTXIBlocks.registerWithEnergyTooltip("voltaic_injector", () -> StateMachineBlock.rotatingShape(LTXIBlocks.machineProperties().noOcclusion(), LTXIBlockShapes.VOLTAIC_INJECTOR, false));
    public static final DeferredBlockWithItem<StateMachineBlock, BlockItem> CHEM_LAB = LTXIBlocks.registerWithEnergyTooltip("chem_lab", () -> StateMachineBlock.rotatingShape(LTXIBlocks.machineProperties().noOcclusion(), LTXIBlockShapes.CHEM_LAB, false));
    public static final DeferredBlockWithItem<StateMachineBlock, BlockItem> ASSEMBLER = LTXIBlocks.registerWithEnergyTooltip("assembler", () -> StateMachineBlock.staticShape(LTXIBlocks.machineProperties().noOcclusion(), LTXIBlockShapes.ASSEMBLER, false));
    public static final DeferredBlockWithItem<PrimaryMeshBlock, BlockItem> FABRICATOR = LTXIBlocks.registerWithEnergyTooltip("fabricator", () -> PrimaryMeshBlock.create(LTXIBlocks.machineProperties().noOcclusion(), LTXIBlockMeshes.WIDE_STATION, LTXIBlockShapes.FABRICATOR, true));
    public static final DeferredBlockWithItem<FabricatorBlock, BlockItem> AUTO_FABRICATOR = LTXIBlocks.registerWithEnergyTooltip("auto_fabricator", () -> new FabricatorBlock(LTXIBlocks.machineProperties().noOcclusion()));
    public static final DeferredBlockWithItem<PrimaryMeshBlock, BlockItem> MOLECULAR_RECONSTRUCTOR = LTXIBlocks.registerWithEnergyTooltip("molecular_reconstructor", () -> PrimaryMeshBlock.create(LTXIBlocks.machineProperties().noOcclusion(), LTXIBlockMeshes.DOUBLE_VERTICAL, LTXIBlockShapes.MOLECULAR_RECONSTRUCTOR, false));
    public static final DeferredBlockWithItem<PrimaryMeshBlock, BlockItem> DIGITAL_GARDEN = LTXIBlocks.registerWithEnergyTooltip("digital_garden", () -> PrimaryMeshBlock.create(LTXIBlocks.machineProperties().noCollission(), LTXIBlockMeshes.DOUBLE_VERTICAL, LTXIBlockShapes.DIGITAL_GARDEN, false));
    public static final DeferredBlockWithItem<PrimaryMeshBlock, BlockItem> ROCKET_TURRET = BLOCKS.registerBlockAndItem("rocket_turret", () -> PrimaryMeshBlock.create(LTXIBlocks.machineProperties().noOcclusion(), LTXIBlockMeshes.DOUBLE_VERTICAL, LTXIBlockShapes.GENERAL_TURRET, true), block -> ContentsTooltipBlockItem.energyOwnerTooltipItem((Block)block, new Item.Properties().stacksTo(1).rarity(LTXIItemRarities.ltxGearRarity())));
    public static final DeferredBlockWithItem<PrimaryMeshBlock, BlockItem> RAILGUN_TURRET = BLOCKS.registerBlockAndItem("railgun_turret", () -> PrimaryMeshBlock.create(LTXIBlocks.machineProperties().noOcclusion(), LTXIBlockMeshes.DOUBLE_VERTICAL, LTXIBlockShapes.GENERAL_TURRET, true), block -> ContentsTooltipBlockItem.energyOwnerTooltipItem((Block)block, new Item.Properties().stacksTo(1).rarity(LTXIItemRarities.ltxGearRarity())));
    public static final DeferredBlock<LiquidBlock> VIRIDIC_ACID_BLOCK = BLOCKS.register("viridic_acid", () -> new LiquidBlock((FlowingFluid)LTXIFluids.VIRIDIC_ACID.get(), BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).replaceable().noCollission().strength(100.0f).pushReaction(PushReaction.DESTROY).noLootTable().liquid().lightLevel(state -> 7).sound(SoundType.EMPTY)));
    public static final DeferredBlock<SurfaceStickingBlock> GLOWSTICK = BLOCKS.registerBlock("glowstick", properties -> new SurfaceStickingBlock((BlockBehaviour.Properties)properties, LTXIBlockShapes.GLOWSTICK, true), BlockBehaviour.Properties.of().noCollission().instabreak().pushReaction(PushReaction.DESTROY).lightLevel(state -> 15).noLootTable());
    public static final DeferredBlock<MeshBlock> MESH_BLOCK = BLOCKS.registerBlock("mesh_block", MeshBlock::new, LTXIBlocks.machineProperties().dynamicShape().noOcclusion().noLootTable());

    private LTXIBlocks() {
    }

    public static void register(IEventBus bus) {
        BLOCKS.register(bus);
        bus.addListener(RegisterCapabilitiesEvent.class, LTXIBlocks::registerCapabilities);
    }

    private static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerItem(Capabilities.EnergyStorage.ITEM, (stack, $) -> EnergyHolderItem.createEnergyAccess(stack), new ItemLike[]{ENERGY_CELL_ARRAY, INFINITE_ENERGY_CELL_ARRAY});
    }

    static Collection<DeferredHolder<Block, ? extends Block>> getRegisteredBlocks() {
        return BLOCKS.getEntriesWithItemsOnly();
    }

    private static BlockBehaviour.Properties neonLightProperties() {
        return BlockBehaviour.Properties.of().sound(SoundType.GLASS).strength(2.0f).lightLevel(state -> 15);
    }

    private static BlockBehaviour.Properties machineProperties() {
        return BlockBehaviour.Properties.of().mapColor(MapColor.SNOW).pushReaction(PushReaction.BLOCK).strength(6.0f, 32.0f).requiresCorrectToolForDrops();
    }

    private static BlockBehaviour.Properties berryVinesProperties() {
        return BlockBehaviour.Properties.of().mapColor(MapColor.WARPED_NYLIUM).randomTicks().noCollission().lightLevel(CaveVines.emission((int)14)).instabreak().sound(SoundType.CAVE_VINES).pushReaction(PushReaction.DESTROY);
    }

    private static BlockBehaviour.Properties quartzGlassProperties() {
        return BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.HAT).noOcclusion().sound(SoundType.GLASS).strength(1.0f, 1200.0f).isValidSpawn(Blocks::never).isRedstoneConductor(NEVER).isSuffocating(NEVER).isViewBlocking(NEVER).requiresCorrectToolForDrops();
    }

    private static <T extends Block> DeferredBlockWithItem<T, BlockItem> registerWithEnergyTooltip(String name, Supplier<T> supplier) {
        return BLOCKS.registerBlockAndItem(name, supplier, block -> ContentsTooltipBlockItem.energyTooltipItem(block, new Item.Properties().stacksTo(1)));
    }
}

