/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.registry.game;

import liedge.limacore.item.LimaCreativeTabFillerItem;
import liedge.limacore.util.LimaItemUtil;
import liedge.ltxindustries.LTXIndustries;
import liedge.ltxindustries.integration.guideme.GuideMEIntegration;
import liedge.ltxindustries.item.weapon.GrenadeLauncherItem;
import liedge.ltxindustries.lib.weapons.GrenadeType;
import liedge.ltxindustries.registry.bootstrap.LTXIEnchantments;
import liedge.ltxindustries.registry.game.LTXIBlocks;
import liedge.ltxindustries.registry.game.LTXIItems;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public final class LTXICreativeTabs {
    private static final DeferredRegister<CreativeModeTab> TABS = LTXIndustries.RESOURCES.deferredRegister(Registries.CREATIVE_MODE_TAB);
    public static final DeferredHolder<CreativeModeTab, CreativeModeTab> MAIN_TAB = TABS.register("main", id -> LimaItemUtil.tabBuilderWithTitle((ResourceLocation)id).icon(() -> ((GrenadeLauncherItem)LTXIItems.GRENADE_LAUNCHER.get()).createDecorativeStack(GrenadeType.ELECTRIC)).displayItems((parameters, output) -> LTXICreativeTabs.buildMainTab(id, parameters, output)).build());
    public static final DeferredHolder<CreativeModeTab, CreativeModeTab> EQUIPMENT_MODULES_TAB = TABS.register("equipment_modules", id -> LimaItemUtil.tabBuilderWithTitle((ResourceLocation)id).icon(() -> LTXIItems.EQUIPMENT_UPGRADE_MODULE.toStack()).displayItems((parameters, output) -> LimaCreativeTabFillerItem.addToTab((ResourceLocation)id, (CreativeModeTab.ItemDisplayParameters)parameters, (CreativeModeTab.Output)output, (CreativeModeTab.TabVisibility)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS, LTXIItems.EQUIPMENT_UPGRADE_MODULE)).build());
    public static final DeferredHolder<CreativeModeTab, CreativeModeTab> MACHINE_MODULES_TAB = TABS.register("machine_modules", id -> LimaItemUtil.tabBuilderWithTitle((ResourceLocation)id).icon(() -> LTXIItems.MACHINE_UPGRADE_MODULE.toStack()).displayItems((parameters, output) -> LimaCreativeTabFillerItem.addToTab((ResourceLocation)id, (CreativeModeTab.ItemDisplayParameters)parameters, (CreativeModeTab.Output)output, (CreativeModeTab.TabVisibility)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS, LTXIItems.MACHINE_UPGRADE_MODULE)).build());

    private LTXICreativeTabs() {
    }

    public static void register(IEventBus bus) {
        TABS.register(bus);
    }

    private static void buildMainTab(ResourceLocation tabId, CreativeModeTab.ItemDisplayParameters parameters, CreativeModeTab.Output output) {
        LimaCreativeTabFillerItem.addHoldersToTab((ResourceLocation)tabId, (CreativeModeTab.ItemDisplayParameters)parameters, (CreativeModeTab.Output)output, (CreativeModeTab.TabVisibility)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS, LTXIBlocks.getRegisteredBlocks());
        LimaCreativeTabFillerItem.addHoldersToTab((ResourceLocation)tabId, (CreativeModeTab.ItemDisplayParameters)parameters, (CreativeModeTab.Output)output, (CreativeModeTab.TabVisibility)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS, LTXIItems.getRegisteredItems());
        ItemStack guideTablet = GuideMEIntegration.createGuideTabletItem();
        if (!guideTablet.isEmpty()) {
            output.accept(guideTablet, CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
        }
        HolderLookup.RegistryLookup enchantments = parameters.holders().lookupOrThrow(Registries.ENCHANTMENT);
        LTXICreativeTabs.addEnchantedBooks(output, (HolderLookup<Enchantment>)enchantments, LTXIEnchantments.AMMO_SCAVENGER);
        LTXICreativeTabs.addEnchantedBooks(output, (HolderLookup<Enchantment>)enchantments, LTXIEnchantments.RAZOR);
    }

    private static void addEnchantedBooks(CreativeModeTab.Output output, HolderLookup<Enchantment> registries, ResourceKey<Enchantment> enchantment) {
        Holder.Reference holder = registries.getOrThrow(enchantment);
        int max = ((Enchantment)holder.value()).getMaxLevel();
        for (int i = 1; i <= max; ++i) {
            CreativeModeTab.TabVisibility visibility = i == max ? CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS : CreativeModeTab.TabVisibility.PARENT_TAB_ONLY;
            output.accept(EnchantedBookItem.createForEnchantment((EnchantmentInstance)new EnchantmentInstance((Holder)holder, i)), visibility);
        }
    }
}

