/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.registry.game;

import java.util.function.UnaryOperator;
import liedge.ltxindustries.LTXIndustries;
import liedge.ltxindustries.entity.EquipmentRocketEntity;
import liedge.ltxindustries.entity.GlowstickProjectileEntity;
import liedge.ltxindustries.entity.LimaTraceableProjectile;
import liedge.ltxindustries.entity.OrbGrenadeEntity;
import liedge.ltxindustries.entity.StickyFlameEntity;
import liedge.ltxindustries.entity.TurretRocketEntity;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public final class LTXIEntities {
    private static final DeferredRegister<EntityType<?>> ENTITIES = LTXIndustries.RESOURCES.deferredRegister((Registry)BuiltInRegistries.ENTITY_TYPE);
    public static final DeferredHolder<EntityType<?>, EntityType<GlowstickProjectileEntity>> GLOWSTICK_PROJECTILE = LTXIEntities.projectile("glowstick_projectile", GlowstickProjectileEntity::new, 0.25f, 0.25f, 10);
    public static final DeferredHolder<EntityType<?>, EntityType<OrbGrenadeEntity>> ORB_GRENADE = LTXIEntities.projectile("orb_grenade", OrbGrenadeEntity::new, 0.4f, 0.4f, 2);
    public static final DeferredHolder<EntityType<?>, EntityType<EquipmentRocketEntity>> DAYBREAK_ROCKET = LTXIEntities.projectile("daybreak_rocket", EquipmentRocketEntity::new, 0.6f, 0.6f, 2);
    public static final DeferredHolder<EntityType<?>, EntityType<TurretRocketEntity>> TURRET_ROCKET = LTXIEntities.projectile("turret_rocket", TurretRocketEntity::new, 0.6f, 0.6f, 2);
    public static final DeferredHolder<EntityType<?>, EntityType<StickyFlameEntity>> STICKY_FLAME = LTXIEntities.register("sticky_flame", StickyFlameEntity::new, MobCategory.MISC, builder -> builder.sized(2.0f, 2.0f).clientTrackingRange(10).updateInterval(20));

    private LTXIEntities() {
    }

    public static void register(IEventBus bus) {
        ENTITIES.register(bus);
    }

    private static <T extends Entity> DeferredHolder<EntityType<?>, EntityType<T>> register(String name, EntityType.EntityFactory<T> factory, MobCategory category, UnaryOperator<EntityType.Builder<T>> builderOp) {
        return ENTITIES.register(name, () -> {
            EntityType.Builder builder = (EntityType.Builder)builderOp.apply(EntityType.Builder.of((EntityType.EntityFactory)factory, (MobCategory)category));
            return builder.build(name);
        });
    }

    private static <T extends LimaTraceableProjectile> DeferredHolder<EntityType<?>, EntityType<T>> projectile(String name, EntityType.EntityFactory<T> factory, float width, float height, int updateInterval) {
        return LTXIEntities.register(name, factory, MobCategory.MISC, builder -> builder.sized(width, height).clientTrackingRange(10).updateInterval(updateInterval).fireImmune());
    }
}

