/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.registry.game;

import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import liedge.ltxindustries.LTXIndustries;
import liedge.ltxindustries.registry.game.LTXIBlocks;
import liedge.ltxindustries.registry.game.LTXIItems;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.fluids.BaseFlowingFluid;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import net.neoforged.neoforge.registries.RegisterEvent;

public final class LTXIFluids {
    private static final DeferredRegister<FluidType> TYPES = LTXIndustries.RESOURCES.deferredRegister(NeoForgeRegistries.FLUID_TYPES);
    public static final int VIRIDIC_ACID_LIGHT = 7;
    public static final DeferredHolder<FluidType, FluidType> VIRIDIC_ACID_TYPE = TYPES.register("viridic_acid", () -> new FluidType(FluidType.Properties.create().lightLevel(7)));
    public static final DeferredHolder<FluidType, FluidType> HYDROGEN_TYPE = TYPES.register("hydrogen", () -> new FluidType(FluidType.Properties.create()));
    public static final DeferredHolder<FluidType, FluidType> OXYGEN_TYPE = TYPES.register("oxygen", () -> new FluidType(FluidType.Properties.create()));
    public static final DeferredHolder<Fluid, BaseFlowingFluid.Source> VIRIDIC_ACID = LTXIFluids.source(VIRIDIC_ACID_TYPE);
    public static final DeferredHolder<Fluid, BaseFlowingFluid.Flowing> FLOWING_VIRIDIC_ACID = LTXIFluids.flowing(VIRIDIC_ACID_TYPE);
    public static final DeferredHolder<Fluid, BaseFlowingFluid.Source> HYDROGEN = LTXIFluids.source(HYDROGEN_TYPE);
    public static final DeferredHolder<Fluid, BaseFlowingFluid.Flowing> FLOWING_HYDROGEN = LTXIFluids.flowing(HYDROGEN_TYPE);
    public static final DeferredHolder<Fluid, BaseFlowingFluid.Source> OXYGEN = LTXIFluids.source(OXYGEN_TYPE);
    public static final DeferredHolder<Fluid, BaseFlowingFluid.Flowing> FLOWING_OXYGEN = LTXIFluids.flowing(OXYGEN_TYPE);

    private LTXIFluids() {
    }

    public static void register(IEventBus bus) {
        TYPES.register(bus);
    }

    public static void registerFluids(RegisterEvent.RegisterHelper<Fluid> helper) {
        LTXIFluids.registerFluid(helper, VIRIDIC_ACID_TYPE, VIRIDIC_ACID, FLOWING_VIRIDIC_ACID, properties -> properties.block(LTXIBlocks.VIRIDIC_ACID_BLOCK).bucket(LTXIItems.VIRIDIC_ACID_BUCKET));
        LTXIFluids.registerFluid(helper, HYDROGEN_TYPE, HYDROGEN, FLOWING_HYDROGEN, UnaryOperator.identity());
        LTXIFluids.registerFluid(helper, OXYGEN_TYPE, OXYGEN, FLOWING_OXYGEN, UnaryOperator.identity());
    }

    private static DeferredHolder<Fluid, BaseFlowingFluid.Source> source(DeferredHolder<FluidType, ?> typeHolder) {
        return DeferredHolder.create((ResourceKey)Registries.FLUID, (ResourceLocation)typeHolder.getId());
    }

    private static DeferredHolder<Fluid, BaseFlowingFluid.Flowing> flowing(DeferredHolder<FluidType, ?> typeHolder) {
        return DeferredHolder.create((ResourceKey)Registries.FLUID, (ResourceLocation)typeHolder.getId().withPrefix("flowing_"));
    }

    private static void registerFluid(RegisterEvent.RegisterHelper<Fluid> helper, Supplier<FluidType> typeSupplier, DeferredHolder<Fluid, BaseFlowingFluid.Source> sourceHolder, DeferredHolder<Fluid, BaseFlowingFluid.Flowing> flowingHolder, UnaryOperator<BaseFlowingFluid.Properties> propertiesOp) {
        BaseFlowingFluid.Properties properties = (BaseFlowingFluid.Properties)propertiesOp.apply(new BaseFlowingFluid.Properties(typeSupplier, sourceHolder, flowingHolder));
        helper.register(sourceHolder.getId(), (Object)new BaseFlowingFluid.Source(properties));
        helper.register(flowingHolder.getId(), (Object)new BaseFlowingFluid.Flowing(properties));
    }
}

