/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.registry.game;

import java.util.function.UnaryOperator;
import liedge.limacore.recipe.LimaRecipeSerializer;
import liedge.limacore.registry.LimaDeferredRecipeSerializers;
import liedge.ltxindustries.LTXIndustries;
import liedge.ltxindustries.recipe.AssemblingRecipe;
import liedge.ltxindustries.recipe.ChemicalReactingRecipe;
import liedge.ltxindustries.recipe.DefaultUpgradeModuleRecipe;
import liedge.ltxindustries.recipe.ElectroCentrifugingRecipe;
import liedge.ltxindustries.recipe.EnergizingRecipe;
import liedge.ltxindustries.recipe.FabricatingRecipe;
import liedge.ltxindustries.recipe.GardenSimulatingRecipe;
import liedge.ltxindustries.recipe.GrindingRecipe;
import liedge.ltxindustries.recipe.LTXIRecipe;
import liedge.ltxindustries.recipe.LTXIRecipeSerializer;
import liedge.ltxindustries.recipe.LTXIRecipeSupplier;
import liedge.ltxindustries.recipe.MaterialFusingRecipe;
import liedge.ltxindustries.recipe.MixingRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleCraftingRecipeSerializer;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredHolder;

public final class LTXIRecipeSerializers {
    private static final LimaDeferredRecipeSerializers SERIALIZERS = LTXIndustries.RESOURCES.deferredRecipeSerializers();
    public static final DeferredHolder<RecipeSerializer<?>, LTXIRecipeSerializer<GrindingRecipe>> GRINDING = LTXIRecipeSerializers.register("grinding", GrindingRecipe::new, builder -> (LTXIRecipeSerializer.Builder)((LTXIRecipeSerializer.Builder)builder.withItemIngredients(1)).withItemResults(3));
    public static final DeferredHolder<RecipeSerializer<?>, LTXIRecipeSerializer<MaterialFusingRecipe>> MATERIAL_FUSING = LTXIRecipeSerializers.register("material_fusing", MaterialFusingRecipe::new, builder -> (LTXIRecipeSerializer.Builder)((LTXIRecipeSerializer.Builder)((LTXIRecipeSerializer.Builder)builder.withItemIngredients(3)).withOptionalFluidIngredients(1)).withItemResults(1));
    public static final DeferredHolder<RecipeSerializer<?>, LTXIRecipeSerializer<ElectroCentrifugingRecipe>> ELECTRO_CENTRIFUGING = LTXIRecipeSerializers.register("electro_centrifuging", ElectroCentrifugingRecipe::new, builder -> (LTXIRecipeSerializer.Builder)((LTXIRecipeSerializer.Builder)((LTXIRecipeSerializer.Builder)((LTXIRecipeSerializer.Builder)builder.withOptionalItemIngredients(1)).withOptionalFluidIngredients(1)).withOptionalItemResults(4)).withOptionalFluidResults(2));
    public static final DeferredHolder<RecipeSerializer<?>, LTXIRecipeSerializer<MixingRecipe>> MIXING = LTXIRecipeSerializers.register("mixing", MixingRecipe::new, builder -> (LTXIRecipeSerializer.Builder)((LTXIRecipeSerializer.Builder)((LTXIRecipeSerializer.Builder)((LTXIRecipeSerializer.Builder)builder.withOptionalItemIngredients(4)).withOptionalFluidIngredients(2)).withOptionalItemResults(1)).withOptionalFluidResults(1));
    public static final DeferredHolder<RecipeSerializer<?>, LTXIRecipeSerializer<EnergizingRecipe>> ENERGIZING = LTXIRecipeSerializers.register("energizing", EnergizingRecipe::new, builder -> (LTXIRecipeSerializer.Builder)((LTXIRecipeSerializer.Builder)builder.withItemIngredients(1)).withItemResults(1));
    public static final DeferredHolder<RecipeSerializer<?>, LTXIRecipeSerializer<ChemicalReactingRecipe>> CHEMICAL_REACTING = LTXIRecipeSerializers.register("chemical_reacting", ChemicalReactingRecipe::new, builder -> (LTXIRecipeSerializer.Builder)((LTXIRecipeSerializer.Builder)((LTXIRecipeSerializer.Builder)((LTXIRecipeSerializer.Builder)builder.withOptionalItemIngredients(3)).withOptionalFluidIngredients(3)).withOptionalItemResults(2)).withOptionalFluidResults(2));
    public static final DeferredHolder<RecipeSerializer<?>, LTXIRecipeSerializer<AssemblingRecipe>> ASSEMBLING = LTXIRecipeSerializers.register("assembling", AssemblingRecipe::new, builder -> (LTXIRecipeSerializer.Builder)((LTXIRecipeSerializer.Builder)((LTXIRecipeSerializer.Builder)builder.withItemIngredients(6)).withOptionalFluidIngredients(1)).withItemResults(1));
    public static final DeferredHolder<RecipeSerializer<?>, LimaRecipeSerializer<FabricatingRecipe>> FABRICATING = SERIALIZERS.register("fabricating", id -> LimaRecipeSerializer.of((ResourceLocation)id, FabricatingRecipe.CODEC, FabricatingRecipe.STREAM_CODEC));
    public static final DeferredHolder<RecipeSerializer<?>, LTXIRecipeSerializer<GardenSimulatingRecipe>> GARDEN_SIMULATING = LTXIRecipeSerializers.register("garden_simulating", GardenSimulatingRecipe::new, builder -> (LTXIRecipeSerializer.Builder)((LTXIRecipeSerializer.Builder)((LTXIRecipeSerializer.Builder)builder.defaultTime(600).withItemIngredients(1)).withOptionalFluidIngredients(1)).withItemResults(4));
    public static final DeferredHolder<RecipeSerializer<?>, SimpleCraftingRecipeSerializer<DefaultUpgradeModuleRecipe>> DEFAULT_UPGRADE_MODULE = SERIALIZERS.register("default_upgrade_module", () -> new SimpleCraftingRecipeSerializer(DefaultUpgradeModuleRecipe::new));

    private LTXIRecipeSerializers() {
    }

    public static void register(IEventBus bus) {
        SERIALIZERS.register(bus);
    }

    private static <R extends LTXIRecipe> DeferredHolder<RecipeSerializer<?>, LTXIRecipeSerializer<R>> register(String name, LTXIRecipeSupplier<R> factory, UnaryOperator<LTXIRecipeSerializer.Builder<R>> op) {
        return SERIALIZERS.register(name, id -> ((LTXIRecipeSerializer.Builder)((Object)((Object)op.apply(LTXIRecipeSerializer.builder(factory))))).build((ResourceLocation)id));
    }
}

