/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.util;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import liedge.ltxindustries.LTXICapabilities;
import liedge.ltxindustries.entity.BubbleShieldUser;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.RegisterCommandsEvent;

@EventBusSubscriber(modid="ltxi")
public final class LTXICommands {
    private LTXICommands() {
    }

    @SubscribeEvent
    public static void register(RegisterCommandsEvent event) {
        ObjectArrayList subCommands = new ObjectArrayList();
        subCommands.add((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"shield").requires(ctx -> ctx.hasPermission(2))).then(LTXICommands.shieldCmd("set"))).then(LTXICommands.shieldCmd("give"))).then(LTXICommands.shieldCmd("remove")));
        LiteralArgumentBuilder masterCommand = subCommands.stream().reduce(Commands.literal((String)"ltxi"), ArgumentBuilder::then);
        event.getDispatcher().register(masterCommand);
    }

    private static ArgumentBuilder<CommandSourceStack, ?> shieldCmd(String action) {
        return Commands.literal((String)action).then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).then(Commands.argument((String)"amount", (ArgumentType)FloatArgumentType.floatArg()).executes(ctx -> {
            ServerPlayer player = EntityArgument.getPlayer((CommandContext)ctx, (String)"player");
            float amt = FloatArgumentType.getFloat((CommandContext)ctx, (String)"amount");
            BubbleShieldUser user = (BubbleShieldUser)player.getCapability(LTXICapabilities.ENTITY_BUBBLE_SHIELD);
            if (user != null) {
                switch (action) {
                    case "set": {
                        user.setShieldHealth((LivingEntity)player, amt);
                        break;
                    }
                    case "give": {
                        user.addShieldHealth((LivingEntity)player, amt, 1000.0f);
                        break;
                    }
                    case "remove": {
                        user.reduceShieldHealth((LivingEntity)player, amt, 0.0f);
                    }
                }
            }
            return 1;
        })));
    }
}

