/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.util;

import java.util.List;
import java.util.UUID;
import liedge.limacore.capability.energy.LimaEnergyUtil;
import liedge.limacore.client.gui.TooltipLineConsumer;
import liedge.limacore.lib.Translatable;
import liedge.limacore.util.LimaTextUtil;
import liedge.ltxindustries.LTXIConstants;
import liedge.ltxindustries.LTXIndustries;
import liedge.ltxindustries.client.LTXILangKeys;
import liedge.ltxindustries.menu.tooltip.ItemGridTooltip;
import net.minecraft.ChatFormatting;
import net.minecraft.core.HolderSet;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.tags.TagKey;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.UsernameCache;
import net.neoforged.neoforge.registries.holdersets.AnyHolderSet;
import org.jetbrains.annotations.Nullable;

public final class LTXITooltipUtil {
    public static final Translatable ALL_HOLDER_SET = LTXIndustries.RESOURCES.translationHolder("{}.any_holder_set");
    public static final Translatable AMBIGUOUS_HOLDER_SET = LTXIndustries.RESOURCES.translationHolder("{}.ambiguous_holder_set");

    private LTXITooltipUtil() {
    }

    public static void appendEnergyOnlyTooltip(TooltipLineConsumer consumer, int energy) {
        consumer.accept((FormattedText)LTXILangKeys.INLINE_ENERGY.translateArgs(new Object[]{LimaEnergyUtil.toEnergyString((int)energy)}).withStyle(LTXIConstants.REM_BLUE.chatStyle()));
    }

    public static void appendEnergyWithCapacityTooltip(TooltipLineConsumer consumer, int energy, int capacity) {
        consumer.accept((FormattedText)LTXILangKeys.INLINE_ENERGY.translateArgs(new Object[]{LimaEnergyUtil.toEnergyStoredString((int)energy, (int)capacity)}).withStyle(LTXIConstants.REM_BLUE.chatStyle()));
    }

    public static void appendEnergyUsageTooltip(TooltipLineConsumer consumer, int energyUsage) {
        consumer.accept((FormattedText)LTXILangKeys.INLINE_ENERGY_USAGE.translateArgs(new Object[]{LimaEnergyUtil.toEnergyString((int)energyUsage)}).withStyle(LTXIConstants.REM_BLUE.chatStyle()));
    }

    public static void appendEnergyUsagePerTickTooltip(TooltipLineConsumer consumer, int energyUsage) {
        consumer.accept((FormattedText)LTXILangKeys.INLINE_ENERGY_USAGE.translateArgs(new Object[]{LimaEnergyUtil.toEnergyPerTickString((int)energyUsage)}).withStyle(LTXIConstants.REM_BLUE.chatStyle()));
    }

    public static void appendStorageEnergyTooltip(TooltipLineConsumer consumer, int energy, int capacity, int transferRate) {
        LTXITooltipUtil.appendEnergyWithCapacityTooltip(consumer, energy, capacity);
        consumer.accept((FormattedText)LTXILangKeys.INLINE_ENERGY_TRANSFER_RATE.translateArgs(new Object[]{LimaEnergyUtil.toEnergyPerTickString((int)transferRate)}).withStyle(LTXIConstants.REM_BLUE.chatStyle()));
    }

    @Deprecated
    public static void appendInventoryPreviewTooltip(TooltipLineConsumer consumer, ItemStack stack) {
        List<ItemStack> inventory = ((ItemContainerContents)stack.getOrDefault(DataComponents.CONTAINER, (Object)ItemContainerContents.EMPTY)).nonEmptyStream().toList();
        if (!inventory.isEmpty()) {
            consumer.accept((FormattedText)LTXILangKeys.ITEM_INVENTORY_TOOLTIP.translate().withStyle(ChatFormatting.GRAY));
            consumer.accept((TooltipComponent)new ItemGridTooltip(inventory, 6, 1, true));
        } else {
            consumer.accept((FormattedText)LTXILangKeys.EMPTY_ITEM_INVENTORY_TOOLTIP.translate().withStyle(ChatFormatting.GRAY));
        }
    }

    public static String formatFlatNumber(double value) {
        return value < 1000.0 ? LimaTextUtil.format2PlaceDecimal((double)value) : LimaTextUtil.formatWholeNumber((double)value);
    }

    public static MutableComponent flatNumberWithSign(double value) {
        Object formattedValue = LTXITooltipUtil.formatFlatNumber(value);
        if (value >= 0.0) {
            formattedValue = "+" + (String)formattedValue;
        }
        return Component.literal((String)formattedValue);
    }

    public static MutableComponent flatNumberWithoutSign(double value) {
        return Component.literal((String)LTXITooltipUtil.formatFlatNumber(value));
    }

    public static MutableComponent percentageWithSign(double value) {
        Object formattedValue = LimaTextUtil.formatPercentage((double)value);
        if (value >= 0.0) {
            formattedValue = "+" + (String)formattedValue;
        }
        return Component.literal((String)formattedValue);
    }

    public static MutableComponent percentageWithoutSign(double value) {
        return Component.literal((String)LimaTextUtil.formatPercentage((double)value));
    }

    public static MutableComponent makeOwnerComponent(@Nullable UUID uuid) {
        if (uuid == null) {
            return LTXILangKeys.INLINE_NO_OWNER_TOOLTIP.translate();
        }
        String username = UsernameCache.getLastKnownUsername((UUID)uuid);
        MutableComponent nameComponent = username != null ? Component.literal((String)username) : ComponentUtils.wrapInSquareBrackets((Component)Component.literal((String)uuid.toString()));
        return LTXILangKeys.INLINE_OWNER_TOOLTIP.translateArgs(new Object[]{nameComponent});
    }

    public static MutableComponent translateHolderSet(HolderSet<?> set) {
        if (set instanceof AnyHolderSet) {
            return ALL_HOLDER_SET.translate();
        }
        if (set instanceof HolderSet.Named) {
            HolderSet.Named named = (HolderSet.Named)set;
            return Component.translatable((String)Tags.getTagTranslationKey((TagKey)named.key()));
        }
        return AMBIGUOUS_HOLDER_SET.translate();
    }
}

