/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.world;

import com.mojang.serialization.MapCodec;
import java.util.Optional;
import liedge.ltxindustries.entity.AutoTrackingProjectile;
import liedge.ltxindustries.registry.game.LTXILootRegistries;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.EntitySubPredicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public record AutoTrackingTargetSubPredicate(Optional<EntityPredicate> targetPredicate) implements EntitySubPredicate
{
    public static final MapCodec<AutoTrackingTargetSubPredicate> CODEC = EntityPredicate.CODEC.optionalFieldOf("target_predicate").xmap(AutoTrackingTargetSubPredicate::new, AutoTrackingTargetSubPredicate::targetPredicate);

    public static AutoTrackingTargetSubPredicate trackingAny() {
        return new AutoTrackingTargetSubPredicate(Optional.empty());
    }

    public MapCodec<? extends EntitySubPredicate> codec() {
        return (MapCodec)LTXILootRegistries.AUTO_TRACKING_TARGET_SUB_PREDICATE.get();
    }

    public boolean matches(Entity entity, ServerLevel level, @Nullable Vec3 position) {
        AutoTrackingProjectile projectile;
        Entity targetEntity;
        if (entity instanceof AutoTrackingProjectile && (targetEntity = (projectile = (AutoTrackingProjectile)entity).getTargetEntity()) != null) {
            return this.targetPredicate.map(p -> p.matches(level, targetEntity.position(), targetEntity)).orElse(true);
        }
        return false;
    }
}

