---
navigation:
    title: Vitriol Berries
    position: 1
    icon: vitriol_berries
    parent: resources/index.md
---

# Vitriol Berries

## About

<ItemImage id="vitriol_berries" scale="2" />

The mineral-rich ancient structures of the Nether are a prime nutrient source for any flora willing to adapt to the
harsh environment. You might encounter the hardy **Bilevine** while exploring these places. And if you're lucky, the
vines will have **Vitriol Berries** growing on them.

## Natural Generation

Vitriol berries' parent plant, **Bilevine**, generates in the Nether's Fortresses and Bastion Remnants. Their preferred
growth spots are underneath any solid block. You'll likely find them in the hallways or bridge overhangs in Fortresses,
and on the ceiling of Bastions.

<GameScene zoom={2} interactive={true}>
<ImportStructure src="bilevines.nbt" />
</GameScene>

## Farming

You may plant Vitriol Berries underneath any solid block, which will place a Bilevine plant. Over time, this vine will
grow downwards until it hits a solid block. When a new vine block grows, there is a small chance for it to generate with
a berry. Existing vine blocks will **not** generate berries over time.

### Breaking the vines

- Breaking an empty Bilevine without **Shears** will drop nothing.
- Breaking a Bilevine with berries or an empty Bilevine with **Shears** will drop 1 Vitriol Berry.
- You can farm berries with shears in this manner, but growth might be slow.

### Growing berries

- Apply bone meal to an empty Bilevine to instantly grow a Vitriol Berry on that vine block.
- Right-click a Bilevine that has berries to harvest the Vitriol Berry. This will not affect the vine.
- You can produce a large amount of berries in a short amount of time, as long as you have enough bone meal.

## Usage

### Viridic Acid

<ItemGrid>
<ItemIcon id="acidic_biomass" />
<ItemIcon id="viridic_acid_bucket" />
</ItemGrid>

This berry is the source of Viridic Acid, the backbone chemical of most of LTX Industries' chemistry processing lines and
a key ingredient for Polymer. Find some berries and set up a farm as soon as you're able to. You'll need it.

### Weapons-Grade Refining

<ItemImage id="viridic_weapon_chemical" scale="2" />

As versatile as Viridic Acid is, it's offensive properties leave a lot to be desired. And LTXI's equipment division
does not do subtle. Enriching a batch of acid with *Hydrogen* and *Gunpowder* in the [Chem Lab](../machines/gpm/chem_lab.md)
will yield you a tiny vial of Weapons-Grade Viridic Acid. You can use this to make the [Acid Shells](../weapons/hanabi.md#acid)
equipment upgrade module for the *Hanabi*.