/*
 * Decompiled with CFR 0.152.
 */
package org.mangorage.tiab.common.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import org.mangorage.tiab.common.client.renderer.BlockFaceTextRenderer;
import org.mangorage.tiab.common.entities.TimeAcceleratorEntity;

public final class TimeAcceleratorEntityRenderer
extends EntityRenderer<TimeAcceleratorEntity> {
    private static final BlockFaceTextRenderer textRenderer = BlockFaceTextRenderer.create();
    private static final float TEXT_1PX_BELOW_MIDDLE = 0.4375f;
    private static final float TEXT_1PX_ABOVE_MIDDLE = 0.7063f;
    private static final float PADDING_2CHAR = 0.11f;
    private static final float PADDING_3CHAR = 0.19f;

    public TimeAcceleratorEntityRenderer(EntityRendererProvider.Context erp) {
        super(erp);
    }

    public void render(TimeAcceleratorEntity entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int packedLightIn) {
        String timeRate = "x" + 2 * entity.getTimeRate();
        float paddingLeftRightMult = 2 * entity.getTimeRate() < 10 ? 0.11f : 0.19f;
        int remainingTimeSeconds = entity.getRemainingTime() / 20;
        String timeRemaining = remainingTimeSeconds + "s";
        float paddingLeftRightTime = remainingTimeSeconds < 10 ? 0.11f : 0.19f;
        BlockFaceTextRenderer.IDrawText rendererText = textRenderer.of(poseStack, bufferSource);
        rendererText.render(BlockFaceTextRenderer.Face.valuesList(), timeRate, packedLightIn, ChatFormatting.WHITE.getColor(), paddingLeftRightMult, 0.4375f, 0.51f);
        rendererText.render(BlockFaceTextRenderer.Face.valuesList(), timeRemaining, packedLightIn, remainingTimeSeconds > 10 ? ChatFormatting.WHITE.getColor() : ChatFormatting.RED.getColor(), paddingLeftRightTime, 0.7063f, 0.51f);
    }

    public ResourceLocation getTextureLocation(TimeAcceleratorEntity entity) {
        return ResourceLocation.fromNamespaceAndPath((String)"tiab", (String)"accelerate");
    }
}

