/*
 * Decompiled with CFR 0.152.
 */
package org.mangorage.tiab.neoforge.core;

import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.mangorage.tiab.common.api.ITiabRegistration;
import org.mangorage.tiab.common.api.impl.IStoredTimeComponent;
import org.mangorage.tiab.common.api.impl.ITiabItem;
import org.mangorage.tiab.common.core.StoredTimeComponent;
import org.mangorage.tiab.common.entities.TimeAcceleratorEntity;
import org.mangorage.tiab.common.items.TiabItem;
import org.mangorage.tiab.common.lang.Translation;

public final class Registration {
    private static final DeferredRegister.Items ITEMS = DeferredRegister.createItems((String)"tiab");
    private static final DeferredRegister.DataComponents DATA_COMPONENT_TYPES = DeferredRegister.createDataComponents((String)"tiab");
    private static final DeferredRegister<CreativeModeTab> TABS = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"tiab");
    private static final DeferredRegister<EntityType<?>> ENTITY_TYPES = DeferredRegister.create((ResourceKey)Registries.ENTITY_TYPE, (String)"tiab");
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<IStoredTimeComponent>> STORED_TIME_COMPONENT = DATA_COMPONENT_TYPES.register("stored_time", () -> new DataComponentType.Builder().persistent(StoredTimeComponent.DIRECT_CODEC).networkSynchronized(StoredTimeComponent.DIRECT_STREAM_CODEC).build());
    public static final DeferredItem<TiabItem> TIAB_ITEM = ITEMS.register("time_in_a_bottle", () -> new TiabItem(new Item.Properties().component((DataComponentType)STORED_TIME_COMPONENT.get(), (Object)new StoredTimeComponent(0, 0)).component(DataComponents.MAX_STACK_SIZE, (Object)1)));
    public static final DeferredHolder<EntityType<?>, EntityType<TimeAcceleratorEntity>> ACCELERATOR_ENTITY = ENTITY_TYPES.register("accelerator", () -> EntityType.Builder.of((entityType, level) -> new TimeAcceleratorEntity(level), (MobCategory)MobCategory.MISC).sized(1.0f, 1.0f).build("accelerator"));
    public static final DeferredHolder<CreativeModeTab, CreativeModeTab> TIAB_CREATIVE_TAB = TABS.register("tiab", () -> CreativeModeTab.builder().icon(() -> ((TiabItem)TIAB_ITEM.get()).getDefaultInstance()).title((Component)Translation.ITEM.componentTranslation(new Object[0])).displayItems((parameters, output) -> output.accept((ItemLike)TIAB_ITEM.get())).build());

    public static void register(IEventBus modBus) {
        ITEMS.register(modBus);
        ENTITY_TYPES.register(modBus);
        DATA_COMPONENT_TYPES.register(modBus);
        TABS.register(modBus);
    }

    public static interface NeoForgeRegistration
    extends ITiabRegistration {
        @Override
        default public ITiabItem getTiabItem() {
            return (ITiabItem)TIAB_ITEM.get();
        }

        @Override
        default public CreativeModeTab getCreativeTab() {
            return (CreativeModeTab)TIAB_CREATIVE_TAB.get();
        }

        @Override
        default public DataComponentType<IStoredTimeComponent> getStoredTime() {
            return (DataComponentType)STORED_TIME_COMPONENT.get();
        }

        @Override
        default public EntityType<? extends Entity> getAcceleratorEntityType() {
            return (EntityType)ACCELERATOR_ENTITY.get();
        }
    }
}

