/*
 * Decompiled with CFR 0.152.
 */
package org.mangorage.tiab.common;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2248;
import net.minecraft.class_238;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import org.mangorage.tiab.common.api.ICommonTimeInABottleAPI;
import org.mangorage.tiab.common.api.ITiabConfig;
import org.mangorage.tiab.common.api.ITiabItemSearch;
import org.mangorage.tiab.common.api.LoaderSide;
import org.mangorage.tiab.common.api.impl.IStoredTimeComponent;
import org.mangorage.tiab.common.api.impl.ITiabItem;
import org.mangorage.tiab.common.api.impl.ITimeAcceleratorEntity;
import org.mangorage.tiab.common.commands.TiabCommands;
import org.mangorage.tiab.common.core.StoredTimeComponent;
import org.mangorage.tiab.common.entities.TimeAcceleratorEntity;

public abstract class TiabMod
implements ICommonTimeInABottleAPI {
    private static ICommonTimeInABottleAPI API;
    private static final class_6862<class_2248> TIAB_UN_ACCELERATABLE;
    private final List<ITiabItemSearch> itemSearchList = new ObjectArrayList();
    private final LoaderSide loaderSide;
    private final ITiabConfig defaultConfig = new ITiabConfig(this){};

    public static Supplier<ICommonTimeInABottleAPI> getAPIHolder() {
        return () -> API;
    }

    public TiabMod(LoaderSide loaderSide) {
        this.loaderSide = loaderSide;
        API = this;
        this.registerItemSearch(p -> {
            for (class_1799 item : p.method_31548().field_7547) {
                if (!(item.method_7909() instanceof ITiabItem)) continue;
                return item;
            }
            return null;
        });
    }

    @Override
    public List<ITiabItemSearch> getSearchHandlers() {
        return List.copyOf(this.itemSearchList);
    }

    @Override
    public String getModId() {
        return "tiab";
    }

    @Override
    public LoaderSide getLoaderSide() {
        return this.loaderSide;
    }

    protected void registerCommand(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"tiab").then(TiabCommands.addTimeCommand)).then(TiabCommands.removeTimeCommand));
    }

    @Override
    public void registerItemSearch(ITiabItemSearch search) {
        this.itemSearchList.add(search);
    }

    @Override
    public class_1799 findTiabItem(class_1657 player) {
        for (ITiabItemSearch search : this.itemSearchList) {
            class_1799 item = search.findItem(player);
            if (item == null) continue;
            return item;
        }
        return null;
    }

    @Override
    public class_6862<class_2248> getTagKey() {
        return TIAB_UN_ACCELERATABLE;
    }

    @Override
    public ITiabConfig getConfig() {
        return this.defaultConfig;
    }

    @Override
    public IStoredTimeComponent createStoredTimeComponent(int stored, int total) {
        return new StoredTimeComponent(stored, total);
    }

    @Override
    public ITimeAcceleratorEntity createEntity(class_3218 level) {
        return (ITimeAcceleratorEntity)this.getRegistration().getAcceleratorEntityType().method_5883((class_1937)level);
    }

    @Override
    public List<? extends ITimeAcceleratorEntity> getEntities(class_1937 level, class_238 aabb) {
        return level.method_18467(TimeAcceleratorEntity.class, aabb);
    }

    protected void tickPlayer(class_1657 player) {
        class_3222 serverPlayer;
        MinecraftServer server;
        if (player.method_37908().field_9236) {
            return;
        }
        if (player instanceof class_3222 && (server = (serverPlayer = (class_3222)player).method_5682()) != null && server.method_3780() % 20 == 0) {
            ICommonTimeInABottleAPI.COMMON_API.get().getRegistration().getTiabItem().tickPlayer(player, 20);
        }
    }

    static {
        TIAB_UN_ACCELERATABLE = class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)class_2960.method_60655((String)"tiab", (String)"un_acceleratable"));
    }
}

