/*
 * Decompiled with CFR 0.152.
 */
package org.mangorage.tiab.common.items;

import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_9290;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import org.mangorage.tiab.common.api.ICommonTimeInABottleAPI;
import org.mangorage.tiab.common.api.ITiabConfig;
import org.mangorage.tiab.common.api.ITiabItemSearch;
import org.mangorage.tiab.common.api.impl.IStoredTimeComponent;
import org.mangorage.tiab.common.api.impl.ITiabItem;
import org.mangorage.tiab.common.api.impl.ITimeAcceleratorEntity;
import org.mangorage.tiab.common.core.StoredTimeComponent;
import org.mangorage.tiab.common.misc.CommonHelper;
import org.mangorage.tiab.common.misc.CommonSoundHelper;

public class TiabItem
extends class_1792
implements ITiabItem {
    private final Supplier<IStoredTimeComponent> storedTimeComponentSupplier = () -> new StoredTimeComponent(0, 0);

    public TiabItem(class_1792.class_1793 properties) {
        super(properties);
    }

    @Override
    public void tickPlayer(class_1657 player) {
        this.tickPlayer(player, 1);
    }

    @Override
    public void tickPlayer(class_1657 player, int ticks) {
        for (ITiabItemSearch handler : ICommonTimeInABottleAPI.COMMON_API.get().getSearchHandlers()) {
            class_1799 item = handler.findItem(player);
            if (item == null) continue;
            this.tickBottle(item, ticks);
            break;
        }
    }

    @Override
    public void tickBottle(class_1799 stack) {
        this.tickBottle(stack, 1);
    }

    @Override
    public void tickBottle(class_1799 stack, int ticks) {
        if (stack.method_7909() != this || ticks <= 0) {
            return;
        }
        class_9331<IStoredTimeComponent> comp = ICommonTimeInABottleAPI.COMMON_API.get().getRegistration().getStoredTime();
        IStoredTimeComponent compInst = CommonHelper.modify(stack, comp, this.storedTimeComponentSupplier, old -> {
            if (CommonHelper.isPositive(old.stored() + ticks) && CommonHelper.isPositive(old.total() + ticks)) {
                ITiabConfig cfg = ICommonTimeInABottleAPI.COMMON_API.get().getConfig();
                return new StoredTimeComponent(Math.min(old.stored() + ticks, cfg.MAX_STORED_TIME()), old.total() + ticks);
            }
            return old;
        });
        class_9290 lore = new class_9290(List.of(CommonHelper.getStoredTimeTranslated(compInst.stored()), CommonHelper.getTotalTimeTranslated(compInst.total())));
        stack.method_57379(class_9334.field_49632, (Object)lore);
    }

    public class_1269 method_7884(class_1838 context) {
        class_1937 level = context.method_8045();
        ITiabConfig cfg = ICommonTimeInABottleAPI.COMMON_API.get().getConfig();
        if (level.field_9236) {
            return class_1269.field_5811;
        }
        class_2338 pos = context.method_8037();
        class_2680 blockState = level.method_8320(pos);
        class_2586 targetTE = level.method_8321(pos);
        class_1799 stack = context.method_8041();
        class_1657 player = context.method_8036();
        if (targetTE == null && !blockState.method_26229() || blockState.method_26164(ICommonTimeInABottleAPI.COMMON_API.get().getTagKey())) {
            return class_1269.field_5814;
        }
        int nextRate = 1;
        int energyRequired = this.getEnergyCost(nextRate);
        boolean isCreativeMode = player != null && player.method_7337();
        Optional o = ICommonTimeInABottleAPI.COMMON_API.get().getEntities(level, new class_238(pos)).stream().findFirst();
        if (o.isPresent()) {
            entityTA = (ITimeAcceleratorEntity)o.get();
            int currentRate = entityTA.getTimeRate();
            int usedUpTime = this.getEachUseDuration() - entityTA.getRemainingTime();
            if ((double)currentRate >= Math.pow(2.0, cfg.MAX_RATE_MULTI() - 1)) {
                return class_1269.field_5812;
            }
            nextRate = currentRate * 2;
            int timeAdded = usedUpTime / 2;
            energyRequired = this.getEnergyCost(nextRate);
            if (!this.canUse(stack, isCreativeMode, energyRequired)) {
                return class_1269.field_5812;
            }
            entityTA.setTimeRate(nextRate);
            entityTA.setRemainingTime(entityTA.getRemainingTime() + timeAdded);
        } else {
            if (!this.canUse(stack, isCreativeMode, energyRequired)) {
                return class_1269.field_5812;
            }
            entityTA = ICommonTimeInABottleAPI.COMMON_API.get().createEntity((class_3218)level);
            entityTA.setBlockPos(pos);
            entityTA.setRemainingTime(this.getEachUseDuration());
            level.method_8649(entityTA.asEntity());
        }
        if (!isCreativeMode) {
            int required = energyRequired;
            CommonHelper.modify(stack, ICommonTimeInABottleAPI.COMMON_API.get().getRegistration().getStoredTime(), () -> new StoredTimeComponent(0, 0), old -> {
                int newStoredTime = Math.min(old.stored() - required, cfg.MAX_STORED_TIME());
                return new StoredTimeComponent(newStoredTime, old.total());
            });
        }
        CommonSoundHelper.playSound(level, pos, nextRate);
        return class_1269.field_5812;
    }

    public int getEachUseDuration() {
        return ICommonTimeInABottleAPI.COMMON_API.get().getConfig().TICKS_CONST() * ICommonTimeInABottleAPI.COMMON_API.get().getConfig().EACH_USE_DURATION();
    }

    public int getEnergyCost(int timeRate) {
        if (timeRate <= 1) {
            return this.getEachUseDuration();
        }
        return timeRate / 2 * this.getEachUseDuration();
    }

    public boolean canUse(class_1799 stack, boolean isCreativeMode, int energyRequired) {
        return this.getStoredComponent(stack).stored() >= energyRequired || isCreativeMode;
    }

    @Override
    public IStoredTimeComponent getStoredComponent(class_1799 stack) {
        return (IStoredTimeComponent)stack.method_57825(ICommonTimeInABottleAPI.COMMON_API.get().getRegistration().getStoredTime(), (Object)new StoredTimeComponent(0, 0));
    }

    public boolean allowComponentsUpdateAnimation(class_1657 player, class_1268 hand, class_1799 oldStack, class_1799 newStack) {
        return false;
    }

    public boolean allowContinuingBlockBreaking(class_1657 player, class_1799 oldStack, class_1799 newStack) {
        return true;
    }

    public boolean shouldCauseReequipAnimation(class_1799 oldStack, class_1799 newStack, boolean slotChanged) {
        return false;
    }

    public boolean shouldCauseBlockBreakReset(class_1799 oldStack, class_1799 newStack) {
        return false;
    }
}

