/*
 * Decompiled with CFR 0.152.
 */
package com.github.gtexpert.gtwp;

import com.github.gtexpert.gtwp.api.util.ModLog;
import com.github.gtexpert.gtwp.module.ModuleManager;
import com.github.gtexpert.gtwp.module.Modules;
import com.google.common.collect.ImmutableList;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLConstructionEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLLoadCompleteEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.common.event.FMLServerStartedEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppedEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppingEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod(modid="gtwp", name="GregTech Wood Processing", version="1.2.3-beta", updateJSON="https://forge.curseupdate.com/1093753/gtwoodprocessing", acceptedMinecraftVersions="[1.12.2,1.13)", dependencies="required-after:gregtech@[2.8.10-beta,);after:gregtechfoodoption;after:thaumcraft;after:forestry;after:extratrees;after:advancedrocketry;after:pvj;after:plants2;after:extrautils2;after:integrateddynamics;after:randomthings;after:rustic;after:mysticalworld;after:roots;after:biomesoplenty;after:iceandfire;after:wizardry;after:traverse;after:twilightforest;after:botania;after:natura")
@Mod.EventBusSubscriber(modid="gtwp")
public class GTWPMod {
    private ModuleManager moduleManager;

    @Mod.EventHandler
    public void onConstruction(FMLConstructionEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)this);
        ModLog.logger.info("starting construction event...");
        this.moduleManager = ModuleManager.getInstance();
        this.moduleManager.registerContainer(new Modules());
        this.moduleManager.setup(event.getASMHarvestedData(), Loader.instance().getConfigDir());
        this.moduleManager.onConstruction(event);
        ModLog.logger.info("finished construction!");
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        this.moduleManager.onPreInit(event);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        this.moduleManager.onInit(event);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        this.moduleManager.onPostInit(event);
    }

    @Mod.EventHandler
    public void loadComplete(FMLLoadCompleteEvent event) {
        this.moduleManager.onLoadComplete(event);
    }

    @Mod.EventHandler
    public void serverAboutToStart(FMLServerAboutToStartEvent event) {
        this.moduleManager.onServerAboutToStart(event);
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        this.moduleManager.onServerStarting(event);
    }

    @Mod.EventHandler
    public void serverStarted(FMLServerStartedEvent event) {
        this.moduleManager.onServerStarted(event);
    }

    @Mod.EventHandler
    public void serverStopping(FMLServerStoppingEvent event) {
        this.moduleManager.onServerStopping(event);
    }

    @Mod.EventHandler
    public void serverStopped(FMLServerStoppedEvent event) {
        this.moduleManager.onServerStopped(event);
    }

    @Mod.EventHandler
    public void respondIMC(FMLInterModComms.IMCEvent event) {
        this.moduleManager.processIMC((ImmutableList<FMLInterModComms.IMCMessage>)event.getMessages());
    }

    @SubscribeEvent
    public void registerBlocks(RegistryEvent.Register<Block> event) {
        ModLog.logger.info("Registering Blocks...");
        this.moduleManager.registerBlocks(event);
    }

    @SubscribeEvent
    public void registerItems(RegistryEvent.Register<Item> event) {
        ModLog.logger.info("Registering Items...");
        this.moduleManager.registerItems(event);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void registerRecipesHighest(RegistryEvent.Register<IRecipe> event) {
        this.moduleManager.registerRecipesHighest(event);
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void registerRecipesHigh(RegistryEvent.Register<IRecipe> event) {
        this.moduleManager.registerRecipesHigh(event);
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        this.moduleManager.registerRecipesNormal(event);
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void registerRecipesLow(RegistryEvent.Register<IRecipe> event) {
        this.moduleManager.registerRecipesLow(event);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void registerRecipesLowest(RegistryEvent.Register<IRecipe> event) {
        this.moduleManager.registerRecipesLowest(event);
    }

    public static <T extends Block> ItemBlock createItemBlock(T block, Function<T, ItemBlock> producer) {
        ItemBlock itemBlock = producer.apply(block);
        ResourceLocation registryName = block.getRegistryName();
        if (registryName == null) {
            ModLog.logger.error("Block has no registry name: {}", (Object)block.func_149739_a(), (Object)new Throwable());
        } else {
            itemBlock.setRegistryName(registryName);
        }
        return itemBlock;
    }

    @SubscribeEvent
    public static void syncConfigValues(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("gtwp")) {
            ConfigManager.sync((String)"gtwp", (Config.Type)Config.Type.INSTANCE);
        }
    }
}

