/*
 * Decompiled with CFR 0.152.
 */
package com.github.gtexpert.gtwp.api.util;

import com.github.gtexpert.gtwp.api.util.ModIncompatibilityException;
import forestry.modules.ModuleHelper;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.FMLLaunchHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum Mods {
    AEAdditions("aeadditions"),
    AE2FluidCrafting("ae2fc"),
    AppliedEnergistics2("appliedenergistics2"),
    AdvancedRocketry("advancedrocketry"),
    Avaritia("avaritia"),
    Avaritiaaddons("avaritiaddons"),
    Baubles("baubles"),
    BoP("biomesoplenty"),
    Botania("botania"),
    Botany("botany"),
    Chisel("chisel"),
    CTM("ctm"),
    CraftTweaker("crafttweaker"),
    DraconicAdditions("draconicadditions"),
    DraconicEvolution("draconicevolution"),
    EnderCore("endercore"),
    EnderIO("enderio"),
    EnderIOEndergy("enderioendergy"),
    EnderIOMachines("enderiomachines"),
    EnderIOConduits("enderioconduits"),
    EnderIOAE2Conduits("enderioconduitsappliedenergistics"),
    ExtraBees("extrabees"),
    ExtraCPUs("extracpus"),
    ExtraTrees("extratrees"),
    ExtraUtilities("extrautils2"),
    Forestry("forestry"),
    ForestryApiculture("forestry", Mods.forestryModule("apiculture")),
    ForestryArboriculture("forestry", Mods.forestryModule("arboriculture")),
    ForestryCharcoal("forestry", Mods.forestryModule("charcoal")),
    ForestryCore("forestry", Mods.forestryModule("core")),
    ForestryEnergy("forestry", Mods.forestryModule("energy")),
    ForestryFactory("forestry", Mods.forestryModule("factory")),
    ForestryWorktable("forestry", Mods.forestryModule("worktable")),
    ForestryFarming("forestry", Mods.forestryModule("farming")),
    ForestryClimatology("forestry", Mods.forestryModule("climatology")),
    ForestryGreenhouse("forestry", Mods.forestryModule("greenhouse")),
    ForestryFluids("forestry", Mods.forestryModule("fluids")),
    ForestryFood("forestry", Mods.forestryModule("food")),
    ForestryLepidopterology("forestry", Mods.forestryModule("lepidopterology")),
    ForestryMail("forestry", Mods.forestryModule("mail")),
    ForestryCrate("forestry", Mods.forestryModule("crates")),
    ForestryBackpacks("forestry", Mods.forestryModule("backpacks")),
    ForestryDatabase("forestry", Mods.forestryModule("database")),
    ForestrySorting("forestry", Mods.forestryModule("sorting")),
    ForestryBook("forestry", Mods.forestryModule("book")),
    ForestryCultivation("forestry", Mods.forestryModule("cultivation")),
    ForestryResearch("forestry", Mods.forestryModule("research")),
    GalacticraftCore("galacticraftcore"),
    Genetics("genetics"),
    Gendustry("gendustry"),
    GregicalityMultiblocks("gcym"),
    GregTech("gregtech"),
    GregTechFoodOption("gregtechfoodoption"),
    GregTechExpertCore("gtexpert"),
    GregTechWoodProcessing("gtwp"),
    GroovyScript("groovyscript"),
    HWYLA("hwyla"),
    InventoryTweaks("inventorytweaks"),
    IntegratedDynamics("integrateddynamics"),
    IceAndFire("iceandfire"),
    JourneyMap("journeymap"),
    JustEnoughItems("jei"),
    MagicBees("magicbees"),
    ModularUI("modularui"),
    MixinBooter("mixinbooter"),
    MysticalWorld("mysticalworld"),
    Natura("natura"),
    NeevesAE2("nae2"),
    Nothirium("nothirium"),
    NuclearCraft("nuclearcraft", Mods.versionExcludes("2o")),
    NuclearCraftOverhauled("nuclearcraft", Mods.versionContains("2o")),
    NetherUpdateBackport("netherbackport"),
    OpenComputers("opencomputers"),
    ProjectRedCore("projred-core"),
    ProjectRedIllumination("projectred-illumination"),
    Railcraft("railcraft"),
    RandomThings("randomthings"),
    Roots("roots"),
    Plants("plants2"),
    RefinedStorage("refinedstorage"),
    ProjectVibrantJourneys("pvj"),
    Rustic("rustic"),
    Thaumcraft("thaumcraft"),
    Traverse("traverse"),
    TwilightForest("twilightforest"),
    ThaumicEnergistics("haumicenergistics"),
    Wizardry("wizardry"),
    TheOneProbe("theoneprobe"),
    TinkersConstruct("tconstruct"),
    TOPAddons("topaddons"),
    Vanilla("minecraft"),
    Optifine(null){

        @Override
        public boolean isModLoaded() {
            if (this.modLoaded == null) {
                try {
                    Class<?> c = Class.forName("net.optifine.shaders.Shaders");
                    Field f = c.getDeclaredField("shaderPackLoaded");
                    f.setAccessible(true);
                    this.modLoaded = f.getBoolean(null);
                }
                catch (Exception ignored) {
                    this.modLoaded = false;
                }
            }
            return this.modLoaded;
        }
    };

    private final String ID;
    private final Function<Mods, Boolean> extraCheck;
    protected Boolean modLoaded;

    private Mods(String ID) {
        this.ID = ID;
        this.extraCheck = null;
    }

    private Mods(String ID, Function<Mods, Boolean> extraCheck) {
        this.ID = ID;
        this.extraCheck = extraCheck;
    }

    public boolean isModLoaded() {
        if (this.modLoaded == null) {
            this.modLoaded = Loader.isModLoaded((String)this.ID);
            if (this.modLoaded.booleanValue() && this.extraCheck != null && !this.extraCheck.apply(this).booleanValue()) {
                this.modLoaded = false;
            }
        }
        return this.modLoaded;
    }

    public void throwIncompatibilityIfLoaded(String ... customMessages) {
        if (this.isModLoaded()) {
            String modName = TextFormatting.BOLD + this.ID + TextFormatting.RESET;
            ArrayList<String> messages = new ArrayList<String>();
            messages.add(modName + " mod detected, this mod is incompatible with GregTech CE Unofficial.");
            messages.addAll(Arrays.asList(customMessages));
            if (FMLLaunchHandler.side() == Side.SERVER) {
                throw new RuntimeException(String.join((CharSequence)",", messages));
            }
            Mods.throwClientIncompatibility(messages);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static void throwClientIncompatibility(List<String> messages) {
        throw new ModIncompatibilityException(messages);
    }

    public ItemStack getItem(@NotNull String name) {
        return this.getItem(name, 1, 0, null);
    }

    @NotNull
    public ItemStack getItem(@NotNull String name, int count) {
        return this.getItem(name, count, 0, null);
    }

    @NotNull
    public ItemStack getItem(@NotNull String name, int count, int meta) {
        return this.getItem(name, count, meta, null);
    }

    @NotNull
    public ItemStack getItem(@NotNull String name, int count, int meta, @Nullable String nbt) {
        return GameRegistry.makeItemStack((String)(this.ID + ":" + name), (int)meta, (int)count, (String)nbt);
    }

    @NotNull
    public ResourceLocation getResource(@NotNull String path) {
        return new ResourceLocation(this.ID, path);
    }

    private static Function<Mods, Boolean> versionContains(String versionPart) {
        return mod -> {
            if (mod.ID == null) {
                return false;
            }
            if (!mod.isModLoaded()) {
                return false;
            }
            ModContainer container = (ModContainer)Loader.instance().getIndexedModList().get(mod.ID);
            if (container == null) {
                return false;
            }
            return container.getVersion().contains(versionPart);
        };
    }

    private static Function<Mods, Boolean> versionExcludes(String versionPart) {
        return mod -> {
            if (mod.ID == null) {
                return false;
            }
            if (!mod.isModLoaded()) {
                return false;
            }
            ModContainer container = (ModContainer)Loader.instance().getIndexedModList().get(mod.ID);
            if (container == null) {
                return false;
            }
            return !container.getVersion().contains(versionPart);
        };
    }

    private static Function<Mods, Boolean> forestryModule(String moduleID) {
        if (Forestry.isModLoaded()) {
            return mod -> ModuleHelper.isEnabled((String)moduleID);
        }
        return $ -> false;
    }

    public static class Names {
        public static final String AE_ADDITIONS = "aeadditions";
        public static final String AE2_FLUID_CRAFTING = "ae2fc";
        public static final String APPLIED_ENERGISTICS2 = "appliedenergistics2";
        public static final String ADVANCED_ROCKETRY = "advancedrocketry";
        public static final String AVARITIA = "avaritia";
        public static final String AVARITIAADDONS = "avaritiaddons";
        public static final String BAUBLES = "baubles";
        public static final String BIOMES_O_PLENTY = "biomesoplenty";
        public static final String BOTANIA = "botania";
        public static final String BOTANY = "botany";
        public static final String CHISEL = "chisel";
        public static final String CONNECTED_TEXTURES_MOD = "ctm";
        public static final String CRAFT_TWEAKER = "crafttweaker";
        public static final String DRACONIC_ADDITIONS = "draconicadditions";
        public static final String DRACONIC_EVOLUTION = "draconicevolution";
        public static final String ENDER_CORE = "endercore";
        public static final String ENDER_IO = "enderio";
        public static final String ENDER_ENDERGY = "enderioendergy";
        public static final String ENDER_MACHINES = "enderiomachines";
        public static final String ENDER_CONDUITS = "enderioconduits";
        public static final String ENDER_AE2_CONDUITS = "enderioconduitsappliedenergistics";
        public static final String EXTRA_BEES = "extrabees";
        public static final String EXTRA_CPUS = "extracpus";
        public static final String EXTRA_TREES = "extratrees";
        public static final String EXTRA_UTILITIES = "extrautils2";
        public static final String FORESTRY = "forestry";
        public static final String FORESTRY_APICULTURE = "apiculture";
        public static final String FORESTRY_ARBORICULTURE = "arboriculture";
        public static final String FORESTRY_CHARCOAL = "charcoal";
        public static final String FORESTRY_CORE = "core";
        public static final String FORESTRY_ENERGY = "energy";
        public static final String FORESTRY_FACTORY = "factory";
        public static final String FORESTRY_WORKTABLE = "worktable";
        public static final String FORESTRY_FARMING = "farming";
        public static final String FORESTRY_CLIMATOLOGY = "climatology";
        public static final String FORESTRY_GREENHOUSE = "greenhouse";
        public static final String FORESTRY_FLUIDS = "fluids";
        public static final String FORESTRY_FOOD = "food";
        public static final String FORESTRY_LEPIDOPTEROLOGY = "lepidopterology";
        public static final String FORESTRY_MAIL = "mail";
        public static final String FORESTRY_CRATE = "crates";
        public static final String FORESTRY_BACKPACKS = "backpacks";
        public static final String FORESTRY_DATABASE = "database";
        public static final String FORESTRY_SORTING = "sorting";
        public static final String FORESTRY_BOOK = "book";
        public static final String FORESTRY_CULTIVATION = "cultivation";
        public static final String FORESTRY_RESEARCH = "research";
        public static final String GALACTICRAFT_CORE = "galacticraftcore";
        public static final String GENETICS = "genetics";
        public static final String GENDUSTRY = "gendustry";
        public static final String GREGICALITY_MULTIBLOCKS = "gcym";
        public static final String GREGTECH = "gregtech";
        public static final String GREGTECH_FOOD_OPTION = "gregtechfoodoption";
        public static final String GREGTECH_EXPERT_CORE = "gtexpert";
        public static final String GREGTECH_WOOD_PROCESSING = "gtwp";
        public static final String GROOVY_SCRIPT = "groovyscript";
        public static final String HWYLA = "hwyla";
        public static final String INVENTORY_TWEAKS = "inventorytweaks";
        public static final String INTERGRATED_DYNAMICS = "integrateddynamics";
        public static final String ICE_AND_FIRE = "iceandfire";
        public static final String JOURNEY_MAP = "journeymap";
        public static final String JUST_ENOUGH_ITEMS = "jei";
        public static final String MAGIC_BEES = "magicbees";
        public static final String MODULRAUI = "modularui";
        public static final String MIXINBOOTER = "mixinbooter";
        public static final String MYSTICAL_WORLD = "mysticalworld";
        public static final String NATURA = "natura";
        public static final String NEEVES_AE2 = "nae2";
        public static final String NOTHIRIUM = "nothirium";
        public static final String NUCLEAR_CRAFT = "nuclearcraft";
        public static final String NETHER_UPDATE_BACKPORT = "netherbackport";
        public static final String OPEN_COMPUTERS = "opencomputers";
        public static final String PROJECT_RED_CORE = "projred-core";
        public static final String PROJECT_RED_ILLUMINATION = "projectred-illumination";
        public static final String RAILCRAFT = "railcraft";
        public static final String RANDOM_THINGS = "randomthings";
        public static final String ROOTS = "roots";
        public static final String PLANTS = "plants2";
        public static final String REFINED_STORAGE = "refinedstorage";
        public static final String PROJECT_VIBRANT_JOURNEYS = "pvj";
        public static final String RUSTIC = "rustic";
        public static final String THAUMCRAFT = "thaumcraft";
        public static final String TRAVERES = "traverse";
        public static final String TWILIGHT_FOREST = "twilightforest";
        public static final String THAUMIC_ENERGISTICS = "haumicenergistics";
        public static final String WIZARDRY = "wizardry";
        public static final String THE_ONE_PROBE = "theoneprobe";
        public static final String TINKERS_CONSTRUCT = "tconstruct";
        public static final String TOP_ADDONS = "topaddons";
        public static final String VANILLA = "minecraft";
    }
}

