/*
 * Decompiled with CFR 0.152.
 */
package com.github.gtexpert.gtwp.common.metatileentities;

import com.github.gtexpert.gtwp.api.recipes.GTWPRecipeMaps;
import com.github.gtexpert.gtwp.client.GTWPTextures;
import com.github.gtexpert.gtwp.common.blocks.GTWPBlockMetalCasing;
import com.github.gtexpert.gtwp.common.blocks.GTWPMetaBlocks;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.IMultiblockPart;
import gregtech.api.metatileentity.multiblock.RecipeMapMultiblockController;
import gregtech.api.pattern.BlockPattern;
import gregtech.api.pattern.FactoryBlockPattern;
import gregtech.api.pattern.TraceabilityPredicate;
import gregtech.client.renderer.ICubeRenderer;
import gregtech.core.sound.GTSoundEvents;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MetaTileEntitySawmill
extends RecipeMapMultiblockController {
    public MetaTileEntitySawmill(ResourceLocation metaTileEntityId) {
        super(metaTileEntityId, GTWPRecipeMaps.SAWMILL_RECIPES);
    }

    @NotNull
    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity tileEntity) {
        return new MetaTileEntitySawmill(this.metaTileEntityId);
    }

    @NotNull
    protected BlockPattern createStructurePattern() {
        TraceabilityPredicate casing = MetaTileEntitySawmill.states((IBlockState[])new IBlockState[]{this.getCasingState()}).setMinGlobalLimited(14);
        TraceabilityPredicate abilities = this.autoAbilities(true, false, true, true, true, false, false);
        return FactoryBlockPattern.start().aisle(new String[]{"XCX", "X#X", "X X"}).aisle(new String[]{" C ", " # ", "XXX"}).aisle(new String[]{" C ", " # ", "X X"}).aisle(new String[]{" C ", " # ", "XXX"}).aisle(new String[]{"XCX", "S#X", "X X"}).where('S', this.selfPredicate()).where('X', casing.or(abilities)).where('C', MetaTileEntitySawmill.blocks((Block[])new Block[]{GTWPMetaBlocks.BLOCK_SAWMILL_CONVEYOR})).where('#', MetaTileEntitySawmill.air()).where(' ', MetaTileEntitySawmill.any()).build();
    }

    public boolean allowsExtendedFacing() {
        return false;
    }

    public boolean allowsFlip() {
        return false;
    }

    public boolean hasMaintenanceMechanics() {
        return false;
    }

    public boolean canBeDistinct() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public ICubeRenderer getBaseTexture(IMultiblockPart iMultiblockPart) {
        return GTWPTextures.SAWMILL_CASING;
    }

    protected IBlockState getCasingState() {
        return GTWPMetaBlocks.GTWP_METAL_CASING.getState(GTWPBlockMetalCasing.MetalCasingType.SAWMill);
    }

    public SoundEvent getBreakdownSound() {
        return GTSoundEvents.BREAKDOWN_ELECTRICAL;
    }

    public void addInformation(ItemStack stack, @Nullable World player, @NotNull List<String> tooltip, boolean advanced) {
        super.addInformation(stack, player, tooltip, advanced);
        tooltip.add(I18n.func_135052_a((String)"gtwp.machine.sawmill.tooltip.1", (Object[])new Object[0]));
    }

    @SideOnly(value=Side.CLIENT)
    @NotNull
    protected ICubeRenderer getFrontOverlay() {
        return GTWPTextures.SAWMILL_OVERLAY;
    }
}

