/*
 * Decompiled with CFR 0.152.
 */
package com.github.gtexpert.gtwp.integration.binnies.extratrees.loaders.recipes;

import binnie.extratrees.wood.EnumETLog;
import com.github.gtexpert.gtwp.api.util.Mods;
import com.github.gtexpert.gtwp.loaders.GTWPWoodRecipeLoader;
import gregtech.api.recipes.ModHandler;
import gregtech.loaders.WoodTypeEntry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.ResourceLocation;

public class ExtraTreesWoodRecipe {
    private static final String mcModId = "extratrees";
    private static List<WoodTypeEntry> DEFAULT_ENTRIES;
    private static List<WoodTypeEntry> FIREPROOF_ENTRIES;

    private static List<WoodTypeEntry> getDefaultEntries() {
        if (DEFAULT_ENTRIES == null) {
            ExtraTreesWoodRecipe.initEntries();
        }
        return DEFAULT_ENTRIES;
    }

    private static List<WoodTypeEntry> getFireproofEntries() {
        if (FIREPROOF_ENTRIES == null) {
            ExtraTreesWoodRecipe.initEntries();
        }
        return FIREPROOF_ENTRIES;
    }

    private static void initEntries() {
        DEFAULT_ENTRIES = new ArrayList<WoodTypeEntry>();
        FIREPROOF_ENTRIES = new ArrayList<WoodTypeEntry>();
        int plankId = -1;
        int logId = -1;
        int slabId = -1;
        for (int i = 0; i < EnumETLog.values().length; ++i) {
            String woodName = EnumETLog.values()[i].name().toLowerCase();
            int plankMeta = i % 16;
            int logMeta = i % 4;
            int slabMeta = i % 8;
            if (plankMeta == 0) {
                ++plankId;
            }
            if (logMeta == 0) {
                ++logId;
            }
            if (slabMeta == 0) {
                ++slabId;
            }
            DEFAULT_ENTRIES.add(ExtraTreesWoodRecipe.getEntryByName(woodName, plankId, logId, slabId, plankMeta, logMeta, slabMeta));
            FIREPROOF_ENTRIES.add(ExtraTreesWoodRecipe.getFireProofEntryByName(woodName, plankId, logId, slabId, plankMeta, logMeta, slabMeta));
        }
    }

    private static WoodTypeEntry getEntryByName(String woodName, int plankId, int logId, int slabId, int plankMeta, int logMeta, int slabMeta) {
        return new WoodTypeEntry.Builder(mcModId, woodName).log(Mods.ExtraTrees.getItem("logs." + logId, 1, logMeta)).removeCharcoalRecipe().planks(Mods.ExtraTrees.getItem("planks." + plankId, 1, plankMeta), null).door(Mods.ExtraTrees.getItem("doors." + woodName), null).slab(Mods.ExtraTrees.getItem("slabs." + slabId, 1, slabMeta), null).fence(Mods.ExtraTrees.getItem("fences." + plankId, 1, plankMeta), null).fenceGate(Mods.ExtraTrees.getItem("fence.gates." + woodName), null).stairs(Mods.ExtraTrees.getItem("stairs." + woodName), null).addStairsRecipe().registerAllUnificationInfo().build();
    }

    private static WoodTypeEntry getFireProofEntryByName(String woodName, int plankId, int logId, int slabId, int plankMeta, int logMeta, int slabMeta) {
        return new WoodTypeEntry.Builder(mcModId, woodName).log(Mods.ExtraTrees.getItem("logs.fireproof." + logId, 1, logMeta)).removeCharcoalRecipe().planks(Mods.ExtraTrees.getItem("planks.fireproof." + plankId, 1, plankMeta), "fireproof_planks_" + woodName).slab(Mods.ExtraTrees.getItem("slabs.fireproof." + slabId, 1, slabMeta), "fireproof_slab_" + woodName).fence(Mods.ExtraTrees.getItem("fences.fireproof." + plankId, 1, plankMeta), "fireproof_fence_" + woodName).fenceGate(Mods.ExtraTrees.getItem("fence.gates.fireproof." + woodName), "fireproof_fence_gate_" + woodName).stairs(Mods.ExtraTrees.getItem("stairs.fireproof." + woodName), "fireproof_stair_" + woodName).addStairsRecipe().registerAllUnificationInfo().build();
    }

    public static void init() {
        String[] types = new String[]{"_planks", "_slabs", "_fences", "_fence_gates", "_stairs"};
        for (WoodTypeEntry entry : ExtraTreesWoodRecipe.getDefaultEntries()) {
            for (String type : types) {
                ModHandler.removeRecipeByName((ResourceLocation)Mods.ExtraTrees.getResource(entry.woodName + type));
            }
            ModHandler.removeRecipeByName((ResourceLocation)Mods.ExtraTrees.getResource(entry.woodName + "_doors"));
            GTWPWoodRecipeLoader.registerWoodTypeRecipe(true, entry);
            GTWPWoodRecipeLoader.addCuttingRecipe(entry);
            GTWPWoodRecipeLoader.addSawmillRecipe(entry);
        }
        for (WoodTypeEntry entry : ExtraTreesWoodRecipe.getFireproofEntries()) {
            for (String type : types) {
                ModHandler.removeRecipeByName((ResourceLocation)Mods.ExtraTrees.getResource(entry.woodName + "_fireproof" + type));
            }
            GTWPWoodRecipeLoader.registerWoodTypeRecipe(true, entry);
            GTWPWoodRecipeLoader.addCuttingRecipe(entry);
            GTWPWoodRecipeLoader.addSawmillRecipe(entry);
            ModHandler.removeRecipeByName((ResourceLocation)new ResourceLocation("gtwp", entry.woodName + "_saw"));
        }
    }
}

