/*
 * Decompiled with CFR 0.152.
 */
package com.github.gtexpert.gtwp.integration.botania.recipes;

import com.github.gtexpert.gtwp.api.recipes.GTWPRecipeMaps;
import com.github.gtexpert.gtwp.api.util.Mods;
import com.github.gtexpert.gtwp.loaders.GTWPWoodRecipeLoader;
import gregtech.api.GTValues;
import gregtech.api.recipes.ModHandler;
import gregtech.api.recipes.RecipeMaps;
import gregtech.api.recipes.builders.AssemblerRecipeBuilder;
import gregtech.api.recipes.builders.SimpleRecipeBuilder;
import gregtech.api.unification.material.Materials;
import gregtech.api.unification.ore.OrePrefix;
import gregtech.api.util.GTUtility;
import gregtech.common.ConfigHolder;
import gregtech.loaders.WoodTypeEntry;
import java.util.Arrays;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

public class BotaniaWoodRecipe {
    private static List<WoodTypeEntry> DEFAULT_ENTRIES;
    private static final String mcModId = "botania";

    private static List<WoodTypeEntry> getDefaultEntries() {
        if (DEFAULT_ENTRIES == null) {
            DEFAULT_ENTRIES = Arrays.asList(new WoodTypeEntry.Builder(mcModId, "living_wood").log(Mods.Botania.getItem("livingwood")).planks(Mods.Botania.getItem("livingwood", 1, 1), "livingwood_1").slab(Mods.Botania.getItem("livingwood1slab"), "livingwood1slab_0").stairs(Mods.Botania.getItem("livingwood1stairs"), "livingwood1stairs").registerAllUnificationInfo().build(), new WoodTypeEntry.Builder(mcModId, "dream_wood").log(Mods.Botania.getItem("dreamwood")).planks(Mods.Botania.getItem("dreamwood", 1, 1), "dreamwood_1").slab(Mods.Botania.getItem("dreamwood1slab"), "dreamwood1slab_0").stairs(Mods.Botania.getItem("dreamwood1stairs"), "dreamwood1stairs").registerAllUnificationInfo().build());
            return DEFAULT_ENTRIES;
        }
        return DEFAULT_ENTRIES;
    }

    public static void init() {
        String[] woodName;
        for (WoodTypeEntry entry : BotaniaWoodRecipe.getDefaultEntries()) {
            GTWPWoodRecipeLoader.removePlankRecipe(false, entry);
            GTWPWoodRecipeLoader.registerWoodTypeRecipe(false, entry);
            GTWPWoodRecipeLoader.addCuttingRecipe(entry);
            GTWPWoodRecipeLoader.addSawmillRecipe(entry);
        }
        for (String name : woodName = new String[]{"livingwood", "dreamwood", "shimmerwoodplanks"}) {
            ItemStack wood = Mods.Botania.getItem(name);
            ItemStack stair = Mods.Botania.getItem(name + "0stairs");
            ItemStack slab = Mods.Botania.getItem(name + "0slab");
            ModHandler.removeRecipeByName((ResourceLocation)new ResourceLocation(mcModId, name + "0stairs"));
            ModHandler.addShapedRecipe((String)(mcModId + name + "_stairs"), (ItemStack)GTUtility.copy((int)4, (ItemStack)stair), (Object[])new Object[]{"P  ", "PP ", "PPP", Character.valueOf('P'), wood});
            ((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder()).inputs(new ItemStack[]{GTUtility.copy((int)6, (ItemStack)wood)})).outputs(new ItemStack[]{GTUtility.copy((int)4, (ItemStack)stair)})).circuitMeta(7)).EUt(1)).duration(100)).buildAndRegister();
            ModHandler.addShapedRecipe((String)(mcModId + name + "_slab_saw"), (ItemStack)GTUtility.copy((int)2, (ItemStack)slab), (Object[])new Object[]{"sS", Character.valueOf('S'), wood});
            if (ConfigHolder.recipes.hardWoodRecipes) {
                ModHandler.removeRecipeByName((ResourceLocation)new ResourceLocation(mcModId, name + "0slab_0"));
            }
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CUTTER_RECIPES.recipeBuilder()).inputs(new ItemStack[]{wood.func_77946_l()})).outputs(new ItemStack[]{GTUtility.copy((int)2, (ItemStack)slab)})).duration(200)).EUt(GTValues.VA[0])).buildAndRegister();
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)GTWPRecipeMaps.SAWMILL_RECIPES.recipeBuilder()).circuitMeta(17)).inputs(new ItemStack[]{GTUtility.copy((int)6, (ItemStack)wood)})).fluidInputs(new FluidStack[]{Materials.Water.getFluid(1000)})).outputs(new ItemStack[]{GTUtility.copy((int)24, (ItemStack)slab)})).output(OrePrefix.dust, Materials.Wood, 12)).duration(600)).EUt(GTValues.VA[1])).buildAndRegister();
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)GTWPRecipeMaps.SAWMILL_RECIPES.recipeBuilder()).circuitMeta(18)).inputs(new ItemStack[]{GTUtility.copy((int)6, (ItemStack)wood)})).fluidInputs(new FluidStack[]{Materials.Water.getFluid(2500)})).outputs(new ItemStack[]{GTUtility.copy((int)36, (ItemStack)slab)})).duration(800)).EUt(GTValues.VA[1])).buildAndRegister();
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)GTWPRecipeMaps.SAWMILL_RECIPES.recipeBuilder()).circuitMeta(19)).inputs(new ItemStack[]{GTUtility.copy((int)6, (ItemStack)wood)})).fluidInputs(new FluidStack[]{Materials.DistilledWater.getFluid(600)})).outputs(new ItemStack[]{GTUtility.copy((int)24, (ItemStack)slab)})).output(OrePrefix.dust, Materials.Wood, 12)).duration(450)).EUt(GTValues.VA[1])).buildAndRegister();
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)GTWPRecipeMaps.SAWMILL_RECIPES.recipeBuilder()).circuitMeta(20)).inputs(new ItemStack[]{GTUtility.copy((int)6, (ItemStack)wood)})).fluidInputs(new FluidStack[]{Materials.DistilledWater.getFluid(1500)})).outputs(new ItemStack[]{GTUtility.copy((int)36, (ItemStack)slab)})).duration(650)).EUt(GTValues.VA[1])).buildAndRegister();
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)GTWPRecipeMaps.SAWMILL_RECIPES.recipeBuilder()).circuitMeta(21)).inputs(new ItemStack[]{GTUtility.copy((int)6, (ItemStack)wood)})).fluidInputs(new FluidStack[]{Materials.Lubricant.getFluid(120)})).outputs(new ItemStack[]{GTUtility.copy((int)24, (ItemStack)slab)})).output(OrePrefix.dust, Materials.Wood, 12)).duration(300)).EUt(GTValues.VA[1])).buildAndRegister();
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)GTWPRecipeMaps.SAWMILL_RECIPES.recipeBuilder()).circuitMeta(22)).inputs(new ItemStack[]{GTUtility.copy((int)6, (ItemStack)wood)})).fluidInputs(new FluidStack[]{Materials.Lubricant.getFluid(300)})).outputs(new ItemStack[]{GTUtility.copy((int)36, (ItemStack)slab)})).duration(500)).EUt(GTValues.VA[1])).buildAndRegister();
        }
    }
}

