/*
 * Decompiled with CFR 0.152.
 */
package com.github.gtexpert.gtwp.integration.forestry.loaders.recipes;

import com.github.gtexpert.gtwp.api.util.Mods;
import com.github.gtexpert.gtwp.loaders.GTWPWoodRecipeLoader;
import forestry.api.arboriculture.EnumForestryWoodType;
import forestry.api.arboriculture.EnumVanillaWoodType;
import gregtech.api.recipes.ModHandler;
import gregtech.api.recipes.RecipeMaps;
import gregtech.api.recipes.builders.SimpleRecipeBuilder;
import gregtech.common.ConfigHolder;
import gregtech.loaders.WoodTypeEntry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class ForestryWoodRecipe {
    private static final String mcModId = "forestry";
    private static List<WoodTypeEntry> DEFAULT_ENTRIES;
    private static List<WoodTypeEntry> FIREPROOF_ENTRIES;

    private static void initEntries() {
        int slabMeta;
        int logMeta;
        int plankMeta;
        DEFAULT_ENTRIES = new ArrayList<WoodTypeEntry>();
        FIREPROOF_ENTRIES = new ArrayList<WoodTypeEntry>();
        int plankId = -1;
        int logId = -1;
        int slabId = -1;
        List woodNames = Arrays.stream(EnumForestryWoodType.values()).map(Enum::name).collect(Collectors.toList());
        for (int i = 0; i < woodNames.size(); ++i) {
            String woodName = ((String)woodNames.get(i)).toLowerCase();
            plankMeta = i % 16;
            logMeta = i % 4;
            slabMeta = i % 8;
            if (plankMeta == 0) {
                ++plankId;
            }
            if (logMeta == 0) {
                ++logId;
            }
            if (slabMeta == 0) {
                ++slabId;
            }
            DEFAULT_ENTRIES.add(ForestryWoodRecipe.getEntry(woodName, plankMeta, logMeta, slabMeta, plankId, logId, slabId, ""));
            FIREPROOF_ENTRIES.add(ForestryWoodRecipe.getEntry(woodName, plankMeta, logMeta, slabMeta, plankId, logId, slabId, "fireproof."));
        }
        plankId = -1;
        logId = -1;
        slabId = -1;
        List vanillaWoodNames = Arrays.stream(EnumVanillaWoodType.values()).map(Enum::name).collect(Collectors.toList());
        for (int i = 0; i < vanillaWoodNames.size(); ++i) {
            plankMeta = i % 16;
            logMeta = i % 4;
            slabMeta = i % 8;
            if (plankMeta == 0) {
                ++plankId;
            }
            if (logMeta == 0) {
                ++logId;
            }
            if (slabMeta == 0) {
                ++slabId;
            }
            FIREPROOF_ENTRIES.add(ForestryWoodRecipe.getEntry(((String)vanillaWoodNames.get(i)).toLowerCase(), plankMeta, logMeta, slabMeta, plankId, logId, slabId, "vanilla.fireproof."));
        }
    }

    private static WoodTypeEntry getEntry(String woodName, int plankMeta, int logMeta, int slabMeta, int plankId, int logId, int slabId, String separator) {
        return new WoodTypeEntry.Builder(mcModId, woodName).log(Mods.Forestry.getItem("logs." + separator + logId, 1, logMeta)).removeCharcoalRecipe().planks(Mods.Forestry.getItem("planks." + separator + plankId, 1, plankMeta), null).door(Mods.Forestry.getItem("doors." + separator + woodName), null).slab(Mods.Forestry.getItem("slabs." + separator + slabId, 1, slabMeta), null).fence(Mods.Forestry.getItem("fences." + separator + plankId, 1, plankMeta), null).fenceGate(Mods.Forestry.getItem("fence.gates." + separator + woodName), null).stairs(Mods.Forestry.getItem("stairs." + separator + woodName), null).addStairsRecipe().registerAllUnificationInfo().build();
    }

    public static void init() {
        String[] vanillaWoodNames;
        String type;
        int n;
        int n2;
        String[] stringArray;
        ForestryWoodRecipe.initEntries();
        String[] types = new String[]{"planks_", "slabs_", "fences_", "fence_gates_", "stairs_"};
        for (WoodTypeEntry entry : DEFAULT_ENTRIES) {
            stringArray = types;
            n2 = stringArray.length;
            for (n = 0; n < n2; ++n) {
                type = stringArray[n];
                ModHandler.removeRecipeByName((ResourceLocation)Mods.Forestry.getResource(type + entry.woodName));
            }
            ModHandler.removeRecipeByName((ResourceLocation)Mods.Forestry.getResource("doors_" + entry.woodName));
            GTWPWoodRecipeLoader.registerWoodTypeRecipe(true, entry);
            GTWPWoodRecipeLoader.addCuttingRecipe(entry);
            GTWPWoodRecipeLoader.addSawmillRecipe(entry);
        }
        for (WoodTypeEntry entry : FIREPROOF_ENTRIES) {
            stringArray = types;
            n2 = stringArray.length;
            for (n = 0; n < n2; ++n) {
                type = stringArray[n];
                ModHandler.removeRecipeByName((ResourceLocation)Mods.Forestry.getResource("fireproof_" + type + entry.woodName));
            }
            GTWPWoodRecipeLoader.registerWoodTypeRecipe(true, entry);
            GTWPWoodRecipeLoader.addCuttingRecipe(entry);
            GTWPWoodRecipeLoader.addSawmillRecipe(entry);
        }
        for (String woodName : vanillaWoodNames = new String[]{"oak", "spruce", "birch", "jungle", "acacia", "dark_oak"}) {
            ModHandler.removeRecipeByName((ResourceLocation)new ResourceLocation("gtwp", woodName + "_planks_saw"));
        }
        if (!Mods.ForestryCharcoal.isModLoaded()) {
            return;
        }
        if (!ConfigHolder.recipes.harderCharcoalRecipe) {
            return;
        }
        ModHandler.removeRecipeByName((ResourceLocation)Mods.Forestry.getResource("wood_pile"));
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.COMPRESSOR_RECIPES.recipeBuilder()).input("logWood", 4)).outputs(new ItemStack[]{Mods.Forestry.getItem("wood_pile")})).duration(300)).EUt(2)).buildAndRegister();
    }
}

