/*
 * Decompiled with CFR 0.152.
 */
package com.github.gtexpert.gtwp.loaders;

import com.github.gtexpert.gtwp.api.recipes.GTWPRecipeMaps;
import com.github.gtexpert.gtwp.api.util.ModUtility;
import com.github.gtexpert.gtwp.common.GTWPConfigHolder;
import gregtech.api.GTValues;
import gregtech.api.recipes.ModHandler;
import gregtech.api.recipes.RecipeMaps;
import gregtech.api.recipes.builders.AssemblerRecipeBuilder;
import gregtech.api.recipes.builders.SimpleRecipeBuilder;
import gregtech.api.unification.material.Materials;
import gregtech.api.unification.ore.OrePrefix;
import gregtech.api.unification.stack.UnificationEntry;
import gregtech.api.util.GTUtility;
import gregtech.common.ConfigHolder;
import gregtech.common.blocks.MetaBlocks;
import gregtech.loaders.WoodTypeEntry;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.registry.GameRegistry;
import org.jetbrains.annotations.NotNull;

public class GTWPWoodRecipeLoader {
    public static void registerWoodTypeRecipe(boolean randomRecipeID, @NotNull WoodTypeEntry entry) {
        String prefix;
        String name = entry.woodName;
        String string = prefix = randomRecipeID ? entry.modid + "_pf" + ModUtility.generateRandomString(6) : entry.modid;
        if (entry.planks.func_190926_b()) {
            throw new IllegalStateException("Could not find planks form of WoodTypeEntry '" + name + "'.");
        }
        if (!entry.log.func_190926_b()) {
            boolean hasPlanksRecipe = entry.planksRecipeName != null;
            int plank_normal = GTWPConfigHolder.ceuOverride.moreNerfPlankCrafting ? 1 : 2;
            plank_normal = ConfigHolder.recipes.nerfWoodCrafting ? plank_normal : 4;
            int plank_saw = GTWPConfigHolder.ceuOverride.moreNerfPlankCrafting ? 2 : 4;
            int n = plank_saw = ConfigHolder.recipes.nerfWoodCrafting ? plank_saw : 6;
            if (hasPlanksRecipe) {
                ModHandler.addShapelessRecipe((String)(prefix + "_" + entry.planksRecipeName), (ItemStack)GTUtility.copy((int)plank_normal, (ItemStack)entry.planks), (Object[])new Object[]{entry.log.func_77946_l()});
                ModHandler.addMirroredShapedRecipe((String)(prefix + "_" + entry.planksRecipeName + "_saw"), (ItemStack)GTUtility.copy((int)plank_saw, (ItemStack)entry.planks), (Object[])new Object[]{"s", "L", Character.valueOf('L'), entry.log.func_77946_l()});
            } else {
                ModHandler.addShapelessRecipe((String)(prefix + "_" + name + "_plank"), (ItemStack)GTUtility.copy((int)plank_normal, (ItemStack)entry.planks), (Object[])new Object[]{entry.log.func_77946_l()});
                ModHandler.addMirroredShapedRecipe((String)(prefix + "_" + name + "_plank_saw"), (ItemStack)GTUtility.copy((int)plank_saw, (ItemStack)entry.planks), (Object[])new Object[]{"s", "L", Character.valueOf('L'), entry.log.func_77946_l()});
            }
            if (ConfigHolder.recipes.harderCharcoalRecipe) {
                ItemStack outputStack;
                if (entry.removeCharcoalRecipe && (outputStack = FurnaceRecipes.func_77602_a().func_151395_a(entry.log)).func_77973_b() == Items.field_151044_h && outputStack.func_77952_i() == 1) {
                    ModHandler.removeFurnaceSmelting((ItemStack)entry.log);
                }
            } else if (entry.addCharcoalRecipe) {
                GameRegistry.addSmelting((Block)MetaBlocks.RUBBER_LOG, (ItemStack)new ItemStack(Items.field_151044_h, 1, 1), (float)0.15f);
            }
        }
        if (!entry.door.func_190926_b()) {
            boolean hasDoorRecipe;
            boolean bl = hasDoorRecipe = entry.doorRecipeName != null;
            if (ConfigHolder.recipes.hardWoodRecipes) {
                if (hasDoorRecipe) {
                    ModHandler.removeRecipeByName((ResourceLocation)new ResourceLocation(entry.modid, entry.doorRecipeName));
                }
                ModHandler.addShapedRecipe((String)(hasDoorRecipe ? prefix + entry.doorRecipeName : prefix + name + "_door"), (ItemStack)entry.door.func_77946_l(), (Object[])new Object[]{"PTd", "PRS", "PPs", Character.valueOf('P'), entry.planks.func_77946_l(), Character.valueOf('T'), new ItemStack(Blocks.field_150415_aT), Character.valueOf('R'), new UnificationEntry(OrePrefix.ring, Materials.Iron), Character.valueOf('S'), new UnificationEntry(OrePrefix.screw, Materials.Iron)});
                ((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder()).inputs(new ItemStack[]{new ItemStack(Blocks.field_150415_aT)})).inputs(new ItemStack[]{GTUtility.copy((int)4, (ItemStack)entry.planks)})).fluidInputs(new FluidStack[]{Materials.Iron.getFluid(16)})).outputs(new ItemStack[]{entry.door.func_77946_l()})).duration(400)).EUt(4)).buildAndRegister();
            } else {
                if (!hasDoorRecipe) {
                    ModHandler.addShapedRecipe((String)(prefix + name + "_door"), (ItemStack)GTUtility.copy((int)3, (ItemStack)entry.door), (Object[])new Object[]{"PP", "PP", "PP", Character.valueOf('P'), entry.planks.func_77946_l()});
                }
                ((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder()).inputs(new ItemStack[]{GTUtility.copy((int)6, (ItemStack)entry.planks)})).outputs(new ItemStack[]{GTUtility.copy((int)3, (ItemStack)entry.door)})).circuitMeta(6)).duration(600)).EUt(4)).buildAndRegister();
            }
        }
        if (!entry.stairs.func_190926_b()) {
            if (entry.stairsRecipeName != null) {
                ModHandler.removeRecipeByName((ResourceLocation)new ResourceLocation(entry.modid, entry.stairsRecipeName));
            }
            ModHandler.addShapedRecipe((String)(prefix + name + "_stairs"), (ItemStack)GTUtility.copy((int)4, (ItemStack)entry.stairs), (Object[])new Object[]{"P  ", "PP ", "PPP", Character.valueOf('P'), entry.planks.func_77946_l()});
            ((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder()).inputs(new ItemStack[]{GTUtility.copy((int)6, (ItemStack)entry.planks)})).outputs(new ItemStack[]{GTUtility.copy((int)4, (ItemStack)entry.stairs)})).circuitMeta(7)).EUt(1)).duration(100)).buildAndRegister();
        }
        if (!entry.slab.func_190926_b()) {
            if (entry.addSlabCraftingRecipe && !ConfigHolder.recipes.hardWoodRecipes) {
                ModHandler.addShapedRecipe((String)(prefix + name + "_slab"), (ItemStack)GTUtility.copy((int)6, (ItemStack)entry.slab), (Object[])new Object[]{"PPP", Character.valueOf('P'), entry.planks.func_77946_l()});
            }
            ModHandler.addShapedRecipe((String)(prefix + name + "_slab_saw"), (ItemStack)GTUtility.copy((int)2, (ItemStack)entry.slab), (Object[])new Object[]{"sS", Character.valueOf('S'), entry.planks.func_77946_l()});
            if (ConfigHolder.recipes.hardWoodRecipes && entry.slabRecipeName != null) {
                ModHandler.removeRecipeByName((ResourceLocation)new ResourceLocation(entry.modid, entry.slabRecipeName));
            }
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CUTTER_RECIPES.recipeBuilder()).inputs(new ItemStack[]{entry.planks.func_77946_l()})).outputs(new ItemStack[]{GTUtility.copy((int)2, (ItemStack)entry.slab)})).duration(200)).EUt(GTValues.VA[0])).buildAndRegister();
        }
        if (!entry.fence.func_190926_b()) {
            boolean hasFenceRecipe;
            boolean bl = hasFenceRecipe = entry.fenceRecipeName != null;
            if (ConfigHolder.recipes.hardWoodRecipes) {
                if (hasFenceRecipe) {
                    ModHandler.removeRecipeByName((ResourceLocation)new ResourceLocation(entry.modid, entry.fenceRecipeName));
                }
                ModHandler.addShapedRecipe((String)(hasFenceRecipe ? prefix + entry.fenceRecipeName : prefix + name + "_fence"), (ItemStack)entry.fence.func_77946_l(), (Object[])new Object[]{"PSP", "PSP", "PSP", Character.valueOf('P'), entry.planks.func_77946_l(), Character.valueOf('S'), entry.getStick()});
            } else if (!hasFenceRecipe) {
                ModHandler.addShapedRecipe((String)(prefix + name + "_fence"), (ItemStack)GTUtility.copy((int)3, (ItemStack)entry.fence), (Object[])new Object[]{"PSP", "PSP", Character.valueOf('P'), entry.planks.func_77946_l(), Character.valueOf('S'), entry.getStick()});
            }
            ((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder()).inputs(new ItemStack[]{entry.planks.func_77946_l()})).outputs(new ItemStack[]{entry.fence.func_77946_l()})).circuitMeta(1)).duration(100)).EUt(4)).buildAndRegister();
        }
        if (!entry.fenceGate.func_190926_b()) {
            boolean hasFenceGateRecipe;
            boolean bl = hasFenceGateRecipe = entry.fenceGateRecipeName != null;
            if (ConfigHolder.recipes.hardWoodRecipes) {
                if (hasFenceGateRecipe) {
                    ModHandler.removeRecipeByName((ResourceLocation)new ResourceLocation(entry.modid, entry.fenceGateRecipeName));
                }
                ModHandler.addShapedRecipe((String)(hasFenceGateRecipe ? prefix + entry.fenceGateRecipeName : prefix + name + "_fence_gate"), (ItemStack)entry.fenceGate.func_77946_l(), (Object[])new Object[]{"F F", "SPS", "SPS", Character.valueOf('P'), entry.planks.func_77946_l(), Character.valueOf('S'), entry.getStick(), Character.valueOf('F'), new ItemStack(Items.field_151145_ak)});
                ModHandler.addShapedRecipe((String)(prefix + name + "_fence_gate_screws"), (ItemStack)GTUtility.copy((int)2, (ItemStack)entry.fenceGate), (Object[])new Object[]{"IdI", "SPS", "SPS", Character.valueOf('P'), entry.planks, Character.valueOf('S'), entry.getStick(), Character.valueOf('I'), new UnificationEntry(OrePrefix.screw, Materials.Iron)});
            } else if (!hasFenceGateRecipe) {
                ModHandler.addShapedRecipe((String)(prefix + name + "_fence_gate"), (ItemStack)entry.fenceGate.func_77946_l(), (Object[])new Object[]{"SPS", "SPS", Character.valueOf('P'), entry.planks.func_77946_l(), Character.valueOf('S'), entry.getStick()});
            }
            ((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder()).inputs(new ItemStack[]{GTUtility.copy((int)2, (ItemStack)entry.planks)})).input(entry.getStick().toString(), 2)).outputs(new ItemStack[]{entry.fenceGate.func_77946_l()})).circuitMeta(2)).duration(100)).EUt(4)).buildAndRegister();
        }
        if (!entry.boat.func_190926_b()) {
            boolean hasBoatRecipe;
            boolean bl = hasBoatRecipe = entry.boatRecipeName != null;
            if (ConfigHolder.recipes.hardWoodRecipes) {
                if (!entry.slab.func_190926_b()) {
                    if (hasBoatRecipe) {
                        ModHandler.removeRecipeByName((ResourceLocation)new ResourceLocation(entry.modid, entry.boatRecipeName));
                    }
                    ModHandler.addShapedRecipe((String)(hasBoatRecipe ? prefix + entry.boatRecipeName : prefix + name + "_boat"), (ItemStack)entry.boat.func_77946_l(), (Object[])new Object[]{"PHP", "PkP", "SSS", Character.valueOf('P'), entry.planks.func_77946_l(), Character.valueOf('S'), entry.slab.func_77946_l(), Character.valueOf('H'), new ItemStack(Items.field_151038_n)});
                }
            } else if (!hasBoatRecipe) {
                ModHandler.addShapedRecipe((String)(name + "_boat"), (ItemStack)entry.boat.func_77946_l(), (Object[])new Object[]{"P P", "PPP", Character.valueOf('P'), entry.planks.func_77946_l()});
            }
            ((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder()).inputs(new ItemStack[]{GTUtility.copy((int)5, (ItemStack)entry.planks)})).outputs(new ItemStack[]{entry.boat.func_77946_l()})).circuitMeta(15)).duration(100)).EUt(4)).buildAndRegister();
        }
    }

    public static void addCuttingRecipe(@NotNull WoodTypeEntry entry) {
        if (entry.log.func_190926_b()) {
            return;
        }
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CUTTER_RECIPES.recipeBuilder()).inputs(new ItemStack[]{entry.log.func_77946_l()})).fluidInputs(new FluidStack[]{Materials.Water.getFluid(4)})).outputs(new ItemStack[]{GTUtility.copy((int)6, (ItemStack)entry.planks)})).output(OrePrefix.dust, Materials.Wood, 2)).duration(200)).EUt(GTValues.VA[0])).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CUTTER_RECIPES.recipeBuilder()).inputs(new ItemStack[]{entry.log.func_77946_l()})).fluidInputs(new FluidStack[]{Materials.DistilledWater.getFluid(3)})).outputs(new ItemStack[]{GTUtility.copy((int)6, (ItemStack)entry.planks)})).output(OrePrefix.dust, Materials.Wood, 2)).duration(150)).EUt(GTValues.VA[0])).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CUTTER_RECIPES.recipeBuilder()).inputs(new ItemStack[]{entry.log.func_77946_l()})).fluidInputs(new FluidStack[]{Materials.Lubricant.getFluid(1)})).outputs(new ItemStack[]{GTUtility.copy((int)6, (ItemStack)entry.planks)})).output(OrePrefix.dust, Materials.Wood, 2)).duration(100)).EUt(GTValues.VA[0])).buildAndRegister();
    }

    public static void addSawmillRecipe(@NotNull WoodTypeEntry entry) {
        if (entry.log.func_190926_b()) {
            return;
        }
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)GTWPRecipeMaps.SAWMILL_RECIPES.recipeBuilder()).circuitMeta(1)).inputs(new ItemStack[]{GTUtility.copy((int)6, (ItemStack)entry.log)})).fluidInputs(new FluidStack[]{Materials.Water.getFluid(1000)})).outputs(new ItemStack[]{GTUtility.copy((int)48, (ItemStack)entry.planks)})).output(OrePrefix.dust, Materials.Wood, 12)).duration(600)).EUt(GTValues.VA[1])).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)GTWPRecipeMaps.SAWMILL_RECIPES.recipeBuilder()).circuitMeta(2)).inputs(new ItemStack[]{GTUtility.copy((int)6, (ItemStack)entry.log)})).fluidInputs(new FluidStack[]{Materials.Water.getFluid(2500)})).outputs(new ItemStack[]{GTUtility.copy((int)60, (ItemStack)entry.planks)})).duration(800)).EUt(GTValues.VA[1])).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)GTWPRecipeMaps.SAWMILL_RECIPES.recipeBuilder()).circuitMeta(3)).inputs(new ItemStack[]{GTUtility.copy((int)6, (ItemStack)entry.log)})).fluidInputs(new FluidStack[]{Materials.DistilledWater.getFluid(600)})).outputs(new ItemStack[]{GTUtility.copy((int)48, (ItemStack)entry.planks)})).output(OrePrefix.dust, Materials.Wood, 12)).duration(450)).EUt(GTValues.VA[1])).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)GTWPRecipeMaps.SAWMILL_RECIPES.recipeBuilder()).circuitMeta(4)).inputs(new ItemStack[]{GTUtility.copy((int)6, (ItemStack)entry.log)})).fluidInputs(new FluidStack[]{Materials.DistilledWater.getFluid(1500)})).outputs(new ItemStack[]{GTUtility.copy((int)60, (ItemStack)entry.planks)})).duration(650)).EUt(GTValues.VA[1])).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)GTWPRecipeMaps.SAWMILL_RECIPES.recipeBuilder()).circuitMeta(5)).inputs(new ItemStack[]{GTUtility.copy((int)6, (ItemStack)entry.log)})).fluidInputs(new FluidStack[]{Materials.Lubricant.getFluid(120)})).outputs(new ItemStack[]{GTUtility.copy((int)48, (ItemStack)entry.planks)})).output(OrePrefix.dust, Materials.Wood, 12)).duration(300)).EUt(GTValues.VA[1])).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)GTWPRecipeMaps.SAWMILL_RECIPES.recipeBuilder()).circuitMeta(6)).inputs(new ItemStack[]{GTUtility.copy((int)6, (ItemStack)entry.log)})).fluidInputs(new FluidStack[]{Materials.Lubricant.getFluid(300)})).outputs(new ItemStack[]{GTUtility.copy((int)60, (ItemStack)entry.planks)})).duration(500)).EUt(GTValues.VA[1])).buildAndRegister();
        if (entry.slab.func_190926_b()) {
            return;
        }
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)GTWPRecipeMaps.SAWMILL_RECIPES.recipeBuilder()).circuitMeta(7)).inputs(new ItemStack[]{GTUtility.copy((int)6, (ItemStack)entry.log)})).fluidInputs(new FluidStack[]{Materials.Water.getFluid(1000)})).outputs(new ItemStack[]{GTUtility.copy((int)24, (ItemStack)entry.slab)})).output(OrePrefix.dust, Materials.Wood, 12)).duration(600)).EUt(GTValues.VA[1])).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)GTWPRecipeMaps.SAWMILL_RECIPES.recipeBuilder()).circuitMeta(8)).inputs(new ItemStack[]{GTUtility.copy((int)6, (ItemStack)entry.log)})).fluidInputs(new FluidStack[]{Materials.Water.getFluid(2500)})).outputs(new ItemStack[]{GTUtility.copy((int)36, (ItemStack)entry.slab)})).duration(800)).EUt(GTValues.VA[1])).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)GTWPRecipeMaps.SAWMILL_RECIPES.recipeBuilder()).circuitMeta(9)).inputs(new ItemStack[]{GTUtility.copy((int)6, (ItemStack)entry.log)})).fluidInputs(new FluidStack[]{Materials.DistilledWater.getFluid(600)})).outputs(new ItemStack[]{GTUtility.copy((int)24, (ItemStack)entry.slab)})).output(OrePrefix.dust, Materials.Wood, 12)).duration(450)).EUt(GTValues.VA[1])).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)GTWPRecipeMaps.SAWMILL_RECIPES.recipeBuilder()).circuitMeta(10)).inputs(new ItemStack[]{GTUtility.copy((int)6, (ItemStack)entry.log)})).fluidInputs(new FluidStack[]{Materials.DistilledWater.getFluid(1500)})).outputs(new ItemStack[]{GTUtility.copy((int)36, (ItemStack)entry.slab)})).duration(650)).EUt(GTValues.VA[1])).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)GTWPRecipeMaps.SAWMILL_RECIPES.recipeBuilder()).circuitMeta(11)).inputs(new ItemStack[]{GTUtility.copy((int)6, (ItemStack)entry.log)})).fluidInputs(new FluidStack[]{Materials.Lubricant.getFluid(120)})).outputs(new ItemStack[]{GTUtility.copy((int)24, (ItemStack)entry.slab)})).output(OrePrefix.dust, Materials.Wood, 12)).duration(300)).EUt(GTValues.VA[1])).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)GTWPRecipeMaps.SAWMILL_RECIPES.recipeBuilder()).circuitMeta(12)).inputs(new ItemStack[]{GTUtility.copy((int)6, (ItemStack)entry.log)})).fluidInputs(new FluidStack[]{Materials.Lubricant.getFluid(300)})).outputs(new ItemStack[]{GTUtility.copy((int)36, (ItemStack)entry.slab)})).duration(500)).EUt(GTValues.VA[1])).buildAndRegister();
    }

    public static void removePlankRecipe(boolean removeSawRecipes, @NotNull WoodTypeEntry entry) {
        GTWPWoodRecipeLoader.removePlankRecipe(removeSawRecipes, entry, entry.modid);
    }

    public static void removePlankRecipe(boolean removeSawRecipes, @NotNull WoodTypeEntry entry, @NotNull String modId) {
        String name = entry.woodName;
        boolean hasPlanksRecipe = entry.planksRecipeName != null;
        ModHandler.removeRecipeByName((ResourceLocation)new ResourceLocation(modId, hasPlanksRecipe ? entry.planksRecipeName : name + "_planks"));
        if (!removeSawRecipes) {
            return;
        }
        ModHandler.removeRecipeByName((ResourceLocation)new ResourceLocation(modId, hasPlanksRecipe ? entry.planksRecipeName + "_saw" : name + "_planks_saw"));
    }

    public static void removeCharcoalRecipe(@NotNull WoodTypeEntry entry) {
        if (!ConfigHolder.recipes.harderCharcoalRecipe) {
            return;
        }
        ItemStack outputStack = FurnaceRecipes.func_77602_a().func_151395_a(entry.log);
        if (outputStack.func_77973_b() == Items.field_151044_h && outputStack.func_77952_i() == 1) {
            ModHandler.removeFurnaceSmelting((ItemStack)entry.log);
        }
    }

    public static void removeCharcoalRecipe(@NotNull ItemStack log) {
        if (!ConfigHolder.recipes.harderCharcoalRecipe) {
            return;
        }
        ItemStack outputStack = FurnaceRecipes.func_77602_a().func_151395_a(log);
        if (outputStack.func_77973_b() == Items.field_151044_h && outputStack.func_77952_i() == 1) {
            ModHandler.removeFurnaceSmelting((ItemStack)log);
        }
    }
}

