/*
 * Decompiled with CFR 0.152.
 */
package com.github.gtexpert.gtwp.loaders.recipe;

import com.github.gtexpert.gtwp.api.util.Mods;
import com.github.gtexpert.gtwp.common.GTWPConfigHolder;
import com.github.gtexpert.gtwp.loaders.GTWPWoodRecipeLoader;
import gregtech.api.recipes.ModHandler;
import gregtech.api.unification.OreDictUnifier;
import gregtech.api.unification.material.Material;
import gregtech.api.unification.material.Materials;
import gregtech.api.unification.ore.OrePrefix;
import gregtech.api.unification.stack.UnificationEntry;
import gregtech.common.ConfigHolder;
import gregtech.common.blocks.MetaBlocks;
import gregtech.common.blocks.wood.BlockGregPlanks;
import gregtech.loaders.WoodTypeEntry;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class GTWPWoodRecipe {
    private static List<WoodTypeEntry> DEFAULT_ENTRIES;

    private static List<WoodTypeEntry> getDefaultEntries() {
        if (DEFAULT_ENTRIES == null) {
            String mcModId = "minecraft";
            DEFAULT_ENTRIES = Arrays.asList(new WoodTypeEntry.Builder("minecraft", "oak").planks(new ItemStack(Blocks.field_150344_f), null).slab(new ItemStack((Block)Blocks.field_150376_bx), null).log(new ItemStack(Blocks.field_150364_r)).build(), new WoodTypeEntry.Builder("minecraft", "spruce").planks(new ItemStack(Blocks.field_150344_f, 1, 1), null).slab(new ItemStack((Block)Blocks.field_150376_bx, 1, 1), null).log(new ItemStack(Blocks.field_150364_r, 1, 1)).build(), new WoodTypeEntry.Builder("minecraft", "birch").planks(new ItemStack(Blocks.field_150344_f, 1, 2), null).slab(new ItemStack((Block)Blocks.field_150376_bx, 1, 2), null).log(new ItemStack(Blocks.field_150364_r, 1, 2)).build(), new WoodTypeEntry.Builder("minecraft", "jungle").planks(new ItemStack(Blocks.field_150344_f, 1, 3), null).slab(new ItemStack((Block)Blocks.field_150376_bx, 1, 3), null).log(new ItemStack(Blocks.field_150364_r, 1, 3)).build(), new WoodTypeEntry.Builder("minecraft", "acacia").planks(new ItemStack(Blocks.field_150344_f, 1, 4), null).slab(new ItemStack((Block)Blocks.field_150376_bx, 1, 4), null).log(new ItemStack(Blocks.field_150363_s)).build(), new WoodTypeEntry.Builder("minecraft", "dark_oak").planks(new ItemStack(Blocks.field_150344_f, 1, 5), null).slab(new ItemStack((Block)Blocks.field_150376_bx, 1, 5), null).log(new ItemStack(Blocks.field_150363_s, 1, 1)).build(), new WoodTypeEntry.Builder("gregtech", "rubber").planks(MetaBlocks.PLANKS.getItemVariant((Enum)BlockGregPlanks.BlockType.RUBBER_PLANK), null).slab(new ItemStack((Block)MetaBlocks.WOOD_SLAB), null).log(new ItemStack((Block)MetaBlocks.RUBBER_LOG)).build());
            return DEFAULT_ENTRIES;
        }
        return DEFAULT_ENTRIES;
    }

    public static void init() {
        GTWPWoodRecipe.sticks();
        GTWPWoodRecipe.planks();
    }

    private static void sticks() {
        int stick_normal = GTWPConfigHolder.ceuOverride.moreNerfStickCrafting ? 1 : 2;
        stick_normal = ConfigHolder.recipes.harderRods ? stick_normal : 4;
        int stick_saw = GTWPConfigHolder.ceuOverride.moreNerfStickCrafting ? 2 : 4;
        int n = stick_saw = ConfigHolder.recipes.harderRods ? stick_saw : 6;
        if (ConfigHolder.recipes.harderRods) {
            ModHandler.removeRecipeByName((ResourceLocation)Mods.GregTech.getResource("stick_normal"));
            ModHandler.removeRecipeByName((ResourceLocation)Mods.GregTech.getResource("stick_saw"));
        } else {
            ModHandler.removeRecipeByName((ResourceLocation)Mods.Vanilla.getResource("stick"));
        }
        ModHandler.addMirroredShapedRecipe((String)"stick_normal", (ItemStack)new ItemStack(Items.field_151055_y, stick_normal), (Object[])new Object[]{"P", "P", Character.valueOf('P'), new UnificationEntry(OrePrefix.plank, Materials.Wood)});
        ModHandler.addMirroredShapedRecipe((String)"stick_saw", (ItemStack)new ItemStack(Items.field_151055_y, stick_saw), (Object[])new Object[]{"s", "P", "P", Character.valueOf('P'), new UnificationEntry(OrePrefix.plank, Materials.Wood)});
        ModHandler.removeRecipeByName((ResourceLocation)Mods.GregTech.getResource("treated_wood_stick"));
        ModHandler.addMirroredShapedRecipe((String)"treated_wood_stick", (ItemStack)OreDictUnifier.get((OrePrefix)OrePrefix.stick, (Material)Materials.TreatedWood, (int)stick_normal), (Object[])new Object[]{"P", "P", Character.valueOf('P'), MetaBlocks.PLANKS.getItemVariant((Enum)BlockGregPlanks.BlockType.TREATED_PLANK)});
        ModHandler.removeRecipeByName((ResourceLocation)Mods.GregTech.getResource("treated_wood_stick_saw"));
        ModHandler.addMirroredShapedRecipe((String)"treated_wood_stick_saw", (ItemStack)OreDictUnifier.get((OrePrefix)OrePrefix.stick, (Material)Materials.TreatedWood, (int)stick_saw), (Object[])new Object[]{"s", "P", "P", Character.valueOf('P'), MetaBlocks.PLANKS.getItemVariant((Enum)BlockGregPlanks.BlockType.TREATED_PLANK)});
    }

    private static void planks() {
        for (WoodTypeEntry entry : GTWPWoodRecipe.getDefaultEntries()) {
            GTWPWoodRecipeLoader.removePlankRecipe(true, entry, "gregtech");
            if (!ConfigHolder.recipes.hardWoodRecipes) {
                GTWPWoodRecipeLoader.removePlankRecipe(false, entry, "minecraft");
            }
            GTWPWoodRecipeLoader.registerWoodTypeRecipe(false, entry);
            GTWPWoodRecipeLoader.addSawmillRecipe(entry);
        }
    }
}

