/*
 * Decompiled with CFR 0.152.
 */
package com.zephaniahnoah.ezmodlib;

import com.zephaniahnoah.ezmodlib.EzModLib;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.level.ChunkDataEvent;
import net.minecraftforge.event.level.ChunkEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public abstract class ChunkDecorator {
    public static final String tag = "EzModLibGenTag";
    private static final HashSet<ChunkPos> markedForTagging = new HashSet();
    public static List<ChunkDecorator> decorators = new ArrayList<ChunkDecorator>();

    protected abstract void decorate(ChunkAccess var1, Random var2);

    public static void dec(ChunkAccess chunk) {
        for (ChunkDecorator dec : decorators) {
            dec.decorate(chunk, EzModLib.rand);
        }
        markedForTagging.add(chunk.m_7697_());
        chunk.m_8092_(true);
    }

    static {
        MinecraftForge.EVENT_BUS.register(new Object(){

            @SubscribeEvent(priority=EventPriority.LOWEST)
            public void onChunkLoad(ChunkEvent.Load e) {
                LevelAccessor levelAccessor = e.getLevel();
                if (levelAccessor instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)levelAccessor;
                    ((CompletableFuture)serverLevel.m_7726_().f_8325_.m_223454_(e.getChunk().m_7697_()).thenAcceptAsync(optionalTag -> optionalTag.ifPresentOrElse(compoundTag -> {
                        CompoundTag data;
                        if (!(compoundTag != null && compoundTag.m_128441_(ChunkDecorator.tag) || (data = (CompoundTag)((Optional)serverLevel.m_7726_().f_8325_.m_223454_(e.getChunk().m_7697_()).join()).orElse(null)) != null && data.m_128441_(ChunkDecorator.tag))) {
                            ChunkDecorator.dec(e.getChunk());
                        }
                    }, () -> {
                        CompoundTag data = ((Optional)serverLevel.m_7726_().f_8325_.m_223454_(e.getChunk().m_7697_()).join()).orElse(null);
                        if (data == null || !data.m_128441_(ChunkDecorator.tag)) {
                            ChunkDecorator.dec(e.getChunk());
                        }
                    }))).exceptionally(ex -> {
                        ex.printStackTrace();
                        return null;
                    });
                }
            }

            @SubscribeEvent
            public void onChunkDataSave(ChunkDataEvent.Save e) {
                LevelAccessor levelAccessor = e.getLevel();
                if (levelAccessor instanceof ServerLevel) {
                    ServerLevel level = (ServerLevel)levelAccessor;
                    if (markedForTagging.contains(e.getChunk().m_7697_())) {
                        e.getData().m_128379_(ChunkDecorator.tag, false);
                        markedForTagging.remove(e.getChunk().m_7697_());
                    } else {
                        try {
                            CompoundTag data = ((Optional)level.m_7726_().f_8325_.m_223454_(e.getChunk().m_7697_()).join()).orElse(null);
                            if (data != null) {
                                e.getData().m_128379_(ChunkDecorator.tag, true);
                            }
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                }
            }
        });
    }
}

