/*
 * Decompiled with CFR 0.152.
 */
package com.zephaniahnoah.ezmodlib;

import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import com.zephaniahnoah.ezmodlib.VirtualDatapack;
import com.zephaniahnoah.ezmodlib.VirtualResourcepack;
import com.zephaniahnoah.ezmodlib.recipe.Recipe;
import com.zephaniahnoah.ezmodlib.util.Supplier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.event.AddPackFindersEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@Mod(value="ezmodlib")
@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD, modid="ezmodlib")
public class EzModLib {
    public static final Map<String, DeferredRegister<Item>> itemRegisters = new HashMap<String, DeferredRegister<Item>>();
    public static final Map<String, DeferredRegister<Block>> blockRegisters = new HashMap<String, DeferredRegister<Block>>();
    public static final Map<String, DeferredRegister<BlockEntityType<?>>> tileEntityRegisters = new HashMap();
    public static final Map<String, DeferredRegister<EntityType<?>>> entityRegisters = new HashMap();
    public static final Map<ResourceLocation, JsonElement> recipes = new HashMap<ResourceLocation, JsonElement>();
    public static List<Recipe> unbuiltRecipes = new ArrayList<Recipe>();
    public static final Map<ResourceLocation, String> blockModels = new HashMap<ResourceLocation, String>();
    public static final Map<ResourceLocation, Pair<String, Boolean>> itemModels = new HashMap<ResourceLocation, Pair<String, Boolean>>();
    public static final Map<String, Pair<EntityRendererProvider, RegistryObject>> entityRenderers = new HashMap<String, Pair<EntityRendererProvider, RegistryObject>>();
    public static final Map<RegistryObject<BlockEntityType<?>>, BlockEntityRendererProvider> blockEntityRenderers = new HashMap();
    public static Random rand = new Random();
    public static final String DONT_INJECT = "DONT_INJECT";
    public static final String INJECT_EXISTING_MODEL = "INJECT_EXISTING_MODEL";
    public static final Set<String> mods = new HashSet<String>();
    public static final String MODID = "ezmodlib";

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void addPackFinders(AddPackFindersEvent event) {
        if (event.getPackType() == PackType.CLIENT_RESOURCES) {
            event.addRepositorySource(packConsumer -> {
                Pack pack = Pack.m_245429_((String)new ResourceLocation(MODID, "virtual_resources").toString(), (Component)Component.m_237113_((String)"EzModLib resources"), (boolean)true, id -> new VirtualResourcepack(), (PackType)PackType.CLIENT_RESOURCES, (Pack.Position)Pack.Position.TOP, (PackSource)PackSource.f_10527_);
                if (pack != null) {
                    packConsumer.accept(pack);
                }
            });
        } else if (event.getPackType() == PackType.SERVER_DATA) {
            event.addRepositorySource(packConsumer -> {
                Pack pack = Pack.m_245429_((String)new ResourceLocation(MODID, "virtual_data").toString(), (Component)Component.m_237113_((String)"Virtual Datapack"), (boolean)false, id -> new VirtualDatapack(), (PackType)PackType.SERVER_DATA, (Pack.Position)Pack.Position.TOP, (PackSource)PackSource.f_10527_);
                if (pack != null) {
                    packConsumer.accept(pack);
                }
            });
        }
    }

    @SubscribeEvent
    public static void renderRegister(EntityRenderersEvent.RegisterRenderers e) {
        for (Map.Entry<RegistryObject<BlockEntityType<?>>, BlockEntityRendererProvider> entry : blockEntityRenderers.entrySet()) {
            e.registerBlockEntityRenderer((BlockEntityType)entry.getKey().get(), entry.getValue());
        }
        for (Pair pair : entityRenderers.values()) {
            e.registerEntityRenderer((EntityType)((RegistryObject)pair.getSecond()).get(), (EntityRendererProvider)pair.getFirst());
        }
    }

    public static RegistryObject<Item> register(String modid, String name, Supplier<Item> item, boolean tool) {
        return EzModLib.register(modid, name, item, null, tool);
    }

    public static RegistryObject<Item> register(String modid, String name, Supplier<Item> item, String jsonModel, boolean tool) {
        itemModels.put(new ResourceLocation(modid, name), (Pair<String, Boolean>)new Pair((Object)jsonModel, (Object)tool));
        return itemRegisters.get(modid).register(name, item);
    }

    public static Pair<RegistryObject<Block>, ?> register(String modid, String name, Supplier<Block> block) {
        return EzModLib.register(modid, name, block, null, null, null);
    }

    public static Pair<RegistryObject<Block>, RegistryObject<Item>> register(String modid, String name, Supplier<Block> block, String jsonModel, Supplier<Item> i, String itemModel) {
        return new Pair(EzModLib.registerBlockOnly(modid, name, block, jsonModel), EzModLib.register(modid, name, i == null ? Supplier.S(() -> new BlockItem((Block)block.get(), new Item.Properties())) : i, (String)(itemModel == null ? "{\"parent\": \"" + modid + ":block/" + name + "\"}" : itemModel), false));
    }

    public static RegistryObject<Block> registerBlockOnly(String modid, String name, Supplier<Block> block, String jsonModel) {
        blockModels.put(new ResourceLocation(modid, name), jsonModel);
        return blockRegisters.get(modid).register(name, block);
    }

    public static Pair<EntityType.Builder<?>, RegistryObject<?>> register(String modid, String name, EntityType.EntityFactory<?> entity, MobCategory classification) {
        EntityType.Builder builder = EntityType.Builder.m_20704_(entity, (MobCategory)classification);
        RegistryObject regObj = entityRegisters.get(modid).register(name, Supplier.S(() -> builder.m_20712_(name)));
        return new Pair((Object)builder, (Object)regObj);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void registerRender(String modid, String name, EntityRendererProvider renderer, RegistryObject regObject) {
        entityRenderers.put(name, (Pair<EntityRendererProvider, RegistryObject>)new Pair((Object)renderer, (Object)regObject));
    }

    public static RegistryObject<BlockEntityType<?>> registerTileEntity(String modid, String name, Supplier<BlockEntityType<?>> type) {
        return tileEntityRegisters.get(modid).register(name, type);
    }

    public static void init(String modid) {
        mods.add(modid);
        itemRegisters.put(modid, (DeferredRegister<Item>)DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)modid));
        itemRegisters.get(modid).register(FMLJavaModLoadingContext.get().getModEventBus());
        blockRegisters.put(modid, (DeferredRegister<Block>)DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)modid));
        blockRegisters.get(modid).register(FMLJavaModLoadingContext.get().getModEventBus());
        entityRegisters.put(modid, DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITY_TYPES, (String)modid));
        entityRegisters.get(modid).register(FMLJavaModLoadingContext.get().getModEventBus());
        tileEntityRegisters.put(modid, DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCK_ENTITY_TYPES, (String)modid));
        tileEntityRegisters.get(modid).register(FMLJavaModLoadingContext.get().getModEventBus());
    }
}

