/*
 * Decompiled with CFR 0.152.
 */
package com.zephaniahnoah.ezmodlib;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.zephaniahnoah.ezmodlib.EzModLib;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import net.minecraft.server.packs.resources.IoSupplier;
import net.minecraftforge.common.util.Lazy;

public class VirtualDatapack
implements PackResources {
    private final Lazy<JsonObject> metaContents = Lazy.of(() -> {
        JsonObject pack = new JsonObject();
        pack.addProperty("pack_format", (Number)15);
        pack.addProperty("forge:data_pack_format", (Number)15);
        pack.addProperty("description", "Virtual data generated by EzModLib for dependants.");
        JsonObject root = new JsonObject();
        root.add("pack", (JsonElement)pack);
        return root;
    });
    private static final Map<String, Map<ResourceLocation, String>> dataFileTypes = new HashMap<String, Map<ResourceLocation, String>>();

    public static void addFile(String dataType, String modId, String filePath, String fileContents) {
        VirtualDatapack.addFile(dataType, new ResourceLocation(modId, filePath), fileContents);
    }

    public static void addFile(String dataType, ResourceLocation resLoc, String fileContents) {
        if (!dataFileTypes.containsKey(dataType)) {
            dataFileTypes.put(dataType, new HashMap());
        }
        dataFileTypes.get(dataType).put(resLoc, fileContents);
    }

    public IoSupplier<InputStream> m_8017_(String ... paths) {
        if (paths.length > 0 && paths[0].equals("pack.mcmeta")) {
            return () -> new ByteArrayInputStream(((JsonObject)this.metaContents.get()).toString().getBytes(StandardCharsets.UTF_8));
        }
        return null;
    }

    public IoSupplier<InputStream> m_214146_(PackType type, ResourceLocation location) {
        if (type == PackType.SERVER_DATA && EzModLib.mods.contains(location.m_135827_())) {
            for (Map.Entry<String, Map<ResourceLocation, String>> dataFileType : dataFileTypes.entrySet()) {
                Map<ResourceLocation, String> dataFiles;
                if (!location.m_135815_().startsWith(dataFileType.getKey()) || !(dataFiles = dataFileType.getValue()).containsKey(location)) continue;
                return () -> new ByteArrayInputStream(((String)dataFiles.get(location)).getBytes(StandardCharsets.UTF_8));
            }
        }
        return null;
    }

    public void m_8031_(PackType type, String namespace, String dataType, PackResources.ResourceOutput output) {
        if (type == PackType.SERVER_DATA && EzModLib.mods.contains(namespace)) {
            for (String dataFileType : dataFileTypes.keySet()) {
                if (!dataType.equals(dataFileType)) continue;
                for (Map.Entry<ResourceLocation, String> entry : dataFileTypes.get(dataFileType).entrySet()) {
                    output.accept((Object)entry.getKey(), this.m_214146_(type, entry.getKey()));
                }
            }
        }
    }

    public Set<String> m_5698_(PackType type) {
        return type == PackType.SERVER_DATA ? EzModLib.mods : Collections.emptySet();
    }

    public <T> T m_5550_(MetadataSectionSerializer<T> serializer) {
        if (serializer == PackMetadataSection.f_243696_) {
            return (T)serializer.m_6322_(((JsonObject)this.metaContents.get()).getAsJsonObject("pack"));
        }
        return null;
    }

    public String m_5542_() {
        return new ResourceLocation("ezmodlib", "virtual_data").toString();
    }

    public void close() {
    }
}

