/*
 * Decompiled with CFR 0.152.
 */
package com.zephaniahnoah.ezmodlib;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.zephaniahnoah.ezmodlib.EzModLib;
import com.zephaniahnoah.ezmodlib.util.Util;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import net.minecraft.server.packs.resources.IoSupplier;
import net.minecraftforge.common.util.Lazy;

public class VirtualResourcepack
implements PackResources {
    private final Lazy<JsonObject> metaContents = Lazy.of(() -> {
        JsonObject pack = new JsonObject();
        pack.addProperty("pack_format", (Number)15);
        pack.addProperty("forge:resource_pack_format", (Number)15);
        pack.addProperty("description", "Virtual resources generated by EzModLib for dependants.");
        JsonObject root = new JsonObject();
        root.add("pack", (JsonElement)pack);
        return root;
    });
    private static final Map<ResourceLocation, IoSupplier<ByteArrayInputStream>> virtualResources = new HashMap<ResourceLocation, IoSupplier<ByteArrayInputStream>>();

    public static void addFile(String modId, String filePath, String textFile) {
        VirtualResourcepack.addFile(new ResourceLocation(modId, filePath), textFile);
    }

    public static void addFile(ResourceLocation file, String textFile) {
        VirtualResourcepack.addFile(file, (IoSupplier<ByteArrayInputStream>)((IoSupplier)() -> new ByteArrayInputStream(textFile.getBytes(StandardCharsets.UTF_8))));
    }

    public static void addFile(String modId, String filePath, IoSupplier<ByteArrayInputStream> bytes) {
        VirtualResourcepack.addFile(new ResourceLocation(modId, filePath), bytes);
    }

    public static void addFile(ResourceLocation file, IoSupplier<ByteArrayInputStream> bytes) {
        virtualResources.put(file, bytes);
    }

    public IoSupplier<InputStream> m_8017_(String ... paths) {
        if (paths.length > 0 && paths[0].equals("pack.mcmeta")) {
            return () -> new ByteArrayInputStream(((JsonObject)this.metaContents.get()).toString().getBytes(StandardCharsets.UTF_8));
        }
        return null;
    }

    public IoSupplier<InputStream> m_214146_(PackType type, ResourceLocation location) {
        block9: {
            String modId;
            String path;
            block10: {
                if (type != PackType.CLIENT_RESOURCES || !EzModLib.mods.contains(location.m_135827_())) break block9;
                IoSupplier<ByteArrayInputStream> bytes = virtualResources.get(location);
                if (bytes != null) {
                    return bytes;
                }
                path = location.m_135815_();
                modId = location.m_135827_();
                if (!path.startsWith("models/")) break block10;
                boolean block = path.startsWith("models/block/");
                if (block) {
                    ResourceLocation id = new ResourceLocation(modId, path.substring(13, path.length() - 5));
                    for (Map.Entry<ResourceLocation, String> entry : EzModLib.blockModels.entrySet()) {
                        if (!entry.getKey().equals((Object)id)) continue;
                        String json = entry.getValue();
                        if (json != "DONT_INJECT" && json != "INJECT_EXISTING_MODEL") {
                            return () -> new ByteArrayInputStream(this.getModel((ResourceLocation)entry.getKey(), json, true, false).getBytes(StandardCharsets.UTF_8));
                        }
                        break block9;
                    }
                } else {
                    ResourceLocation id = new ResourceLocation(modId, path.substring(12, path.length() - 5));
                    for (Map.Entry<ResourceLocation, Pair<String, Boolean>> entry : EzModLib.itemModels.entrySet()) {
                        if (!entry.getKey().equals((Object)id)) continue;
                        String json = (String)entry.getValue().getFirst();
                        if (json != "DONT_INJECT" && json != "INJECT_EXISTING_MODEL") {
                            return () -> new ByteArrayInputStream(this.getModel((ResourceLocation)entry.getKey(), json, false, (Boolean)((Pair)entry.getValue()).getSecond()).getBytes(StandardCharsets.UTF_8));
                        }
                        break block9;
                    }
                }
                break block9;
            }
            if (!path.startsWith("blockstates/")) break block9;
            ResourceLocation id = new ResourceLocation(modId, path.substring(12, path.length() - 5));
            for (Map.Entry<ResourceLocation, String> entry : EzModLib.blockModels.entrySet()) {
                if (!entry.getKey().equals((Object)id)) continue;
                String json = entry.getValue();
                String existingBlockstate = Util.readFileFromOtherMod(modId, "assets/" + modId + "/" + location.m_135815_());
                if (existingBlockstate == null && json != "DONT_INJECT") {
                    return () -> new ByteArrayInputStream("{\n\t\"variants\": {\n\t\t\"\": {\n\t\t\t\"model\": \"%s:block/%s\"\n\t\t}\n\t}\n}\n".formatted(modId, id.m_135815_()).getBytes(StandardCharsets.UTF_8));
                }
                break;
            }
        }
        return null;
    }

    public void m_8031_(PackType type, String namespace, String startingPath, PackResources.ResourceOutput output) {
        if (type == PackType.CLIENT_RESOURCES && EzModLib.mods.contains(namespace)) {
            virtualResources.forEach((location, content) -> {
                if (location.m_135827_().equals(namespace) && location.m_135815_().startsWith(startingPath)) {
                    output.accept(location, this.m_214146_(type, (ResourceLocation)location));
                }
            });
            if (startingPath.equals("models")) {
                EzModLib.blockModels.entrySet().forEach(entry -> {
                    if (((ResourceLocation)entry.getKey()).m_135827_().equals(namespace)) {
                        ResourceLocation loc = new ResourceLocation(namespace, "models/block/" + ((ResourceLocation)entry.getKey()).m_135815_() + ".json");
                        String json = (String)entry.getValue();
                        if (json != "DONT_INJECT" && json != "INJECT_EXISTING_MODEL") {
                            output.accept((Object)loc, this.m_214146_(type, loc));
                        }
                    }
                });
                EzModLib.itemModels.entrySet().forEach(entry -> {
                    if (((ResourceLocation)entry.getKey()).m_135827_().equals(namespace)) {
                        ResourceLocation loc = new ResourceLocation(namespace, "models/item/" + ((ResourceLocation)entry.getKey()).m_135815_() + ".json");
                        String json = (String)((Pair)entry.getValue()).getFirst();
                        if (json != "DONT_INJECT" && json != "INJECT_EXISTING_MODEL") {
                            output.accept((Object)loc, this.m_214146_(type, loc));
                        }
                    }
                });
            } else if (startingPath.equals("blockstates")) {
                EzModLib.blockModels.entrySet().forEach(entry -> {
                    if (((ResourceLocation)entry.getKey()).m_135827_().equals(namespace)) {
                        String blockName = ((ResourceLocation)entry.getKey()).m_135815_();
                        ResourceLocation loc = new ResourceLocation(namespace, "blockstates/" + blockName + ".json");
                        String json = (String)entry.getValue();
                        String existingBlockstate = Util.readFileFromOtherMod(namespace, "assets/" + namespace + "/" + loc.m_135815_());
                        if (existingBlockstate == null && json != "DONT_INJECT") {
                            output.accept((Object)loc, this.m_214146_(type, loc));
                        }
                    }
                });
            }
            Util.cache.clear();
        }
    }

    private String getModel(ResourceLocation loc, String json, boolean block, boolean tool) {
        ResourceLocation resourceLocation = new ResourceLocation(loc.m_135827_(), (block ? "block" : "item") + "/" + loc.m_135815_());
        if (json == null) {
            json = VirtualResourcepack.json(resourceLocation.toString(), block, tool);
        }
        return json;
    }

    private static String json(String textureName, boolean block, boolean tool) {
        JsonObject model = new JsonObject();
        JsonObject layer = new JsonObject();
        layer.addProperty(block ? "all" : "layer0", textureName);
        model.addProperty("parent", (String)(block ? "minecraft:block/cube_all" : "minecraft:item/" + (tool ? "handheld" : "generated")));
        model.add("textures", (JsonElement)layer);
        return model.toString();
    }

    public Set<String> m_5698_(PackType type) {
        return type == PackType.CLIENT_RESOURCES ? EzModLib.mods : Collections.emptySet();
    }

    public <T> T m_5550_(MetadataSectionSerializer<T> serializer) {
        if (serializer == PackMetadataSection.f_243696_) {
            return (T)serializer.m_6322_(((JsonObject)this.metaContents.get()).getAsJsonObject("pack"));
        }
        return null;
    }

    public String m_5542_() {
        return new ResourceLocation("ezmodlib", "virtual_resources").toString();
    }

    public void close() {
    }
}

