/*
 * Decompiled with CFR 0.152.
 */
package com.zephaniahnoah.ezmodlib.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.zephaniahnoah.ezmodlib.recipe.MultiInputRecipe;
import com.zephaniahnoah.ezmodlib.util.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraftforge.registries.ForgeRegistries;

public class SmithingRecipe
extends MultiInputRecipe {
    private Supplier<String> base;
    private Supplier<String> addition;
    private Supplier<String> template;

    public SmithingRecipe(ResourceLocation rl, String base, String addition, String result, String template) {
        this(rl, Supplier.S(() -> base), Supplier.S(() -> addition), Supplier.S(() -> result), Supplier.S(() -> template));
    }

    public SmithingRecipe(ResourceLocation rl, Item base, Item addition, Item result, Item template) {
        this(rl, Supplier.S(() -> ForgeRegistries.ITEMS.getKey((Object)base).toString()), Supplier.S(() -> ForgeRegistries.ITEMS.getKey((Object)addition).toString()), Supplier.S(() -> ForgeRegistries.ITEMS.getKey((Object)result).toString()), Supplier.S(() -> ForgeRegistries.ITEMS.getKey((Object)template).toString()));
    }

    public SmithingRecipe(ResourceLocation rl, Supplier<String> base, Supplier<String> addition, Supplier<String> result, Supplier<String> template) {
        super(rl, result, 1);
        this.base = base;
        this.addition = addition;
        this.template = template;
    }

    @Override
    public void build() {
        JsonObject el = new JsonObject();
        el.addProperty("type", "minecraft:smithing_transform");
        JsonObject baseItem = new JsonObject();
        baseItem.addProperty("item", this.base.get());
        el.add("base", (JsonElement)baseItem);
        JsonObject additionItem = new JsonObject();
        additionItem.addProperty("item", this.addition.get());
        el.add("addition", (JsonElement)additionItem);
        JsonObject templateItem = new JsonObject();
        templateItem.addProperty("item", this.template.get());
        el.add("template", (JsonElement)templateItem);
        this.buildPost(el);
    }
}

