/*
 * Decompiled with CFR 0.152.
 */
package com.zephaniahnoah.ezmodlib.util;

import com.mojang.datafixers.util.Pair;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.moddiscovery.ModFile;
import net.minecraftforge.fml.loading.moddiscovery.ModInfo;

public class Util {
    public static Map<Pair<String, String>, String> cache = new HashMap<Pair<String, String>, String>();

    public static String readFileFromOtherMod(String targetModId, String resourcePath) {
        Pair pair = new Pair((Object)targetModId, (Object)resourcePath);
        Optional modContainerOptional = ModList.get().getModContainerById(targetModId);
        if (!cache.containsKey(pair)) {
            if (modContainerOptional.isPresent()) {
                ModContainer modContainer = (ModContainer)modContainerOptional.get();
                ModFile modFile = ((ModInfo)modContainer.getModInfo()).getOwningFile().getFile();
                if (modFile != null) {
                    Path filePath = modFile.findResource(new String[]{resourcePath});
                    if (Files.exists(filePath, new LinkOption[0])) {
                        try (InputStream inputStream = Files.newInputStream(filePath, new OpenOption[0]);
                             InputStreamReader reader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
                             BufferedReader bufferedReader = new BufferedReader(reader);){
                            cache.put((Pair<String, String>)pair, bufferedReader.lines().collect(Collectors.joining(System.lineSeparator())));
                        }
                        catch (IOException e) {
                            cache.put((Pair<String, String>)pair, null);
                        }
                    } else {
                        cache.put((Pair<String, String>)pair, null);
                    }
                } else {
                    cache.put((Pair<String, String>)pair, null);
                }
            } else {
                cache.put((Pair<String, String>)pair, null);
            }
        }
        return cache.get(pair);
    }
}

