var Opcodes = Java.type("org.objectweb.asm.Opcodes");
var VarInsnNode = Java.type("org.objectweb.asm.tree.VarInsnNode");
var MethodInsnNode = Java.type("org.objectweb.asm.tree.MethodInsnNode");

function initializeCoreMod() {
    return {
        'ezmodlib': {
            'target': {
                'type': 'CLASS',
                'name': 'net.minecraft.world.level.storage.loot.LootDataManager'
            },
            'transformer': function (classNode) {
                var methods = classNode.methods;
                for (m in methods) {
                    var method = methods[m];
                    if (method.name === "reload" || method.name === "m_5540_") {
                        var instructions = method.instructions;
                        var firstInstruction = instructions.get(0);

                        // Parameters
                        //instructions.insertBefore(firstInstruction, new VarInsnNode(Opcodes.ALOAD, 1));
                        instructions.insertBefore(firstInstruction, new VarInsnNode(Opcodes.ALOAD, 2));
                        //instructions.insertBefore(firstInstruction, new VarInsnNode(Opcodes.ALOAD, 3));
						//instructions.insertBefore(firstInstruction, new VarInsnNode(Opcodes.ALOAD, 4));
                        //instructions.insertBefore(firstInstruction, new VarInsnNode(Opcodes.ALOAD, 5));
                        //instructions.insertBefore(firstInstruction, new VarInsnNode(Opcodes.ALOAD, 6));

                        // Method
						var injectRecipeMethod = new MethodInsnNode(Opcodes.INVOKESTATIC, "com/zephaniahnoah/ezmodlib/LootTableInjector", "getResourceManager", "(Lnet/minecraft/server/packs/resources/ResourceManager;)V", false);
                        instructions.insertBefore(firstInstruction, injectRecipeMethod);
                        break;
                    }
                }
                return classNode;
            }
        }
    }
}
