var Opcodes = Java.type("org.objectweb.asm.Opcodes");
var VarInsnNode = Java.type("org.objectweb.asm.tree.VarInsnNode");
var MethodInsnNode = Java.type("org.objectweb.asm.tree.MethodInsnNode");

function initializeCoreMod() {
    return {
        'ezmodlib': {
            'target': {
                'type': 'CLASS',
                'name': 'net.minecraft.world.level.storage.loot.LootDataManager'
            },
            'transformer': function (classNode) {
                var methods = classNode.methods;
                for (m in methods) {
                    var method = methods[m];
                    if (method.name === "apply" || method.name === "m_278787_") {
                        var instructions = method.instructions;
                        var firstInstruction = instructions.get(0);

                        // Load parameters
                        instructions.insertBefore(firstInstruction, new VarInsnNode(Opcodes.ALOAD, 1)); // Map
                        instructions.insertBefore(firstInstruction, new VarInsnNode(Opcodes.ALOAD, 0)); // this (LootDataManager)

                        // Method
                        var injectRecipeMethod = new MethodInsnNode(Opcodes.INVOKESTATIC, "com/zephaniahnoah/ezmodlib/LootTableInjector", "injectLootTableManager", "(Ljava/util/Map;Lnet/minecraft/world/level/storage/loot/LootDataManager;)V", false);
                        instructions.insertBefore(firstInstruction, injectRecipeMethod);
                        break;
                    }
                }
                return classNode;
            }
        }
    }
}