/*
 * Decompiled with CFR 0.152.
 */
package net.stardomga.stardomsmagic.enchantments;

import java.util.HashSet;
import java.util.LinkedList;
import net.minecraft.class_1268;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3481;

public class TimberLogic {
    private static final ThreadLocal<Boolean> isTimbering = ThreadLocal.withInitial(() -> false);
    private static final int MAX_BLOCKS_TO_BREAK = 100;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void timber(class_3218 world, class_3222 player, class_1799 tool, class_2338 startPos) {
        if (isTimbering.get().booleanValue()) {
            return;
        }
        isTimbering.set(true);
        try {
            class_2680 startState = world.method_8320(startPos);
            if (!startState.method_26164(class_3481.field_15475)) {
                return;
            }
            class_2338 topLogPos = TimberLogic.findTopLog(world, startPos);
            if (!TimberLogic.isTree(world, topLogPos)) {
                return;
            }
            TimberLogic.breakTree(world, player, tool, topLogPos);
        }
        finally {
            isTimbering.set(false);
        }
    }

    private static class_2338 findTopLog(class_3218 world, class_2338 pos) {
        class_2338 currentPos = pos.method_10062();
        while (world.method_8320(currentPos.method_10084()).method_26164(class_3481.field_15475)) {
            currentPos = currentPos.method_10084();
        }
        return currentPos;
    }

    private static boolean isTree(class_3218 world, class_2338 logPos) {
        for (class_2338 neighborPos : class_2338.method_10097((class_2338)logPos.method_10069(-1, -1, -1), (class_2338)logPos.method_10069(1, 1, 1))) {
            if (!world.method_8320(neighborPos).method_26164(class_3481.field_15503)) continue;
            return true;
        }
        return false;
    }

    private static void breakTree(class_3218 world, class_3222 player, class_1799 tool, class_2338 startPos) {
        HashSet<class_2338> visited = new HashSet<class_2338>();
        LinkedList<class_2338> toVisit = new LinkedList<class_2338>();
        int blocksBroken = 0;
        toVisit.add(startPos);
        visited.add(startPos);
        while (!toVisit.isEmpty() && blocksBroken < 100) {
            class_2338 currentPos = (class_2338)toVisit.poll();
            if (tool.method_7963() && tool.method_7919() >= tool.method_7936() - 1) break;
            class_2680 currentState = world.method_8320(currentPos);
            class_2586 blockEntity = world.method_8321(currentPos);
            class_2248 block = currentState.method_26204();
            block.method_9556((class_1937)world, (class_1657)player, currentPos, currentState, blockEntity, tool);
            world.method_8650(currentPos, false);
            if (currentState.method_26164(class_3481.field_15475)) {
                tool.method_7970(1, (class_1309)player, class_3222.method_56079((class_1268)player.method_6058()));
            }
            ++blocksBroken;
            for (class_2338 neighborPos : class_2338.method_10097((class_2338)currentPos.method_10069(-1, -1, -1), (class_2338)currentPos.method_10069(1, 1, 1))) {
                class_2680 neighborState;
                if (!visited.add(neighborPos.method_10062()) || !(neighborState = world.method_8320(neighborPos)).method_26164(class_3481.field_15475) && !neighborState.method_26164(class_3481.field_15503)) continue;
                toVisit.add(neighborPos.method_10062());
            }
        }
    }
}

