/*
 * Decompiled with CFR 0.152.
 */
package net.stardomga.stardomsmagic.networking;

import java.util.ArrayList;
import java.util.Optional;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1263;
import net.minecraft.class_1293;
import net.minecraft.class_1703;
import net.minecraft.class_1718;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1842;
import net.minecraft.class_1844;
import net.minecraft.class_1847;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_9334;
import net.stardomga.stardomsmagic.client.screen.BrewingScreenHandler;
import net.stardomga.stardomsmagic.networking.CraftPotionPayload;
import net.stardomga.stardomsmagic.networking.EnchantmentScreenHandlerExtension;
import net.stardomga.stardomsmagic.networking.SwitchEnchantTabPayload;
import net.stardomga.stardomsmagic.networking.SyncTabPayload;
import net.stardomga.stardomsmagic.util.RecipeUtils;

public class ModServerNetworking {
    public static void register() {
        ServerPlayNetworking.registerGlobalReceiver(SwitchEnchantTabPayload.ID, (payload, context) -> {
            class_3222 player = context.player();
            int tabId = payload.tabId();
            player.method_5682().execute(() -> {
                if (player.field_7512 instanceof class_1718) {
                    ((EnchantmentScreenHandlerExtension)player.field_7512).stardomsmagic_setHandlerTab(tabId);
                }
            });
        });
        ServerPlayNetworking.registerGlobalReceiver(CraftPotionPayload.ID, (payload, context) -> {
            class_3222 player = context.player();
            player.method_5682().execute(() -> {
                Predicate<class_1799> predicate;
                Optional<RecipeUtils.PotionRecipe> recipeOpt = RecipeUtils.getRecipeFor(payload.itemId(), payload.potionType(), payload.level());
                if (recipeOpt.isEmpty()) {
                    player.method_7353((class_2561)class_2561.method_43470((String)"Invalid recipe."), true);
                    return;
                }
                RecipeUtils.PotionRecipe recipe = recipeOpt.get();
                ArrayList<class_1799> requiredStacks = new ArrayList<class_1799>();
                for (RecipeUtils.Ingredient ingredient : recipe.ingredients) {
                    class_1792 item = (class_1792)class_7923.field_41178.method_63535(class_2960.method_60654((String)ingredient.item_id));
                    class_1799 requiredStack = new class_1799((class_1935)item, ingredient.count);
                    requiredStacks.add(requiredStack);
                }
                for (class_1799 requiredStack : requiredStacks) {
                    predicate = ModServerNetworking.getPredicateForItem(requiredStack);
                    int playerHasCount = 0;
                    for (int i = 0; i < player.method_31548().method_5439(); ++i) {
                        class_1799 playerStack = player.method_31548().method_5438(i);
                        if (!predicate.test(playerStack)) continue;
                        playerHasCount += playerStack.method_7947();
                    }
                    if (playerHasCount >= requiredStack.method_7947()) continue;
                    String missingItemName = requiredStack.method_31574(class_1802.field_8574) ? "Water Bottle" : requiredStack.method_7964().getString();
                    player.method_7353((class_2561)class_2561.method_43470((String)("You are missing " + (requiredStack.method_7947() - playerHasCount) + "x " + missingItemName)), true);
                    return;
                }
                for (class_1799 requiredStack : requiredStacks) {
                    predicate = ModServerNetworking.getPredicateForItem(requiredStack);
                    player.method_31548().method_29280(predicate, requiredStack.method_7947(), (class_1263)player.method_31548());
                }
                class_1799 outputStack = ModServerNetworking.createPotionItemStack(payload.itemId(), payload.potionType(), payload.level(), payload.name());
                player.method_31548().method_7398(outputStack);
            });
        });
        ServerPlayNetworking.registerGlobalReceiver(SyncTabPayload.ID, (payload, context) -> {
            class_3222 player = context.player();
            int receivedTabIndex = payload.tabIndex();
            player.method_5682().execute(() -> {
                class_1703 patt0$temp = player.field_7512;
                if (patt0$temp instanceof BrewingScreenHandler) {
                    BrewingScreenHandler screenHandler = (BrewingScreenHandler)patt0$temp;
                    screenHandler.setCurrentTab(receivedTabIndex);
                }
            });
        });
    }

    private static Predicate<class_1799> getPredicateForItem(class_1799 requiredStack) {
        if (requiredStack.method_31574(class_1802.field_8574)) {
            return stack -> {
                if (!stack.method_31574(class_1802.field_8574)) {
                    return false;
                }
                class_1844 contents = (class_1844)stack.method_58694(class_9334.field_49651);
                if (contents == null) {
                    return false;
                }
                return contents.method_57401(class_1847.field_8991);
            };
        }
        return stack -> class_1799.method_31577((class_1799)requiredStack, (class_1799)stack);
    }

    private static class_1799 createPotionItemStack(String itemId, String potionTypeId, int level, String name) {
        class_1792 item = (class_1792)class_7923.field_41178.method_63535(class_2960.method_60654((String)itemId));
        class_1799 stack = new class_1799((class_1935)item, 1);
        if (itemId.equals(class_1802.field_8574.toString()) && potionTypeId.equals("minecraft:empty")) {
            return class_1844.method_57400((class_1792)class_1802.field_8574, (class_6880)class_1847.field_8991);
        }
        Optional potionEntry = class_7923.field_41179.method_10223(class_2960.method_60654((String)potionTypeId));
        if (potionEntry.isPresent()) {
            class_1842 basePotion = (class_1842)((class_6880.class_6883)potionEntry.get()).comp_349();
            ArrayList<class_1293> customEffects = new ArrayList<class_1293>();
            for (class_1293 baseEffect : basePotion.method_8049()) {
                class_1293 newEffect = new class_1293(baseEffect.method_5579(), baseEffect.method_5584(), level - 1, baseEffect.method_5591(), baseEffect.method_5581(), baseEffect.method_5592());
                customEffects.add(newEffect);
            }
            class_1844 potionContents = new class_1844(Optional.empty(), Optional.empty(), customEffects, Optional.empty());
            Object displayName = name;
            if (level > 1) {
                displayName = (String)displayName + " " + ModServerNetworking.toRomanNumeral(level);
            }
            class_5250 customName = class_2561.method_43470((String)displayName).method_10862(class_2583.field_24360.method_10978(Boolean.valueOf(false)));
            stack.method_57379(class_9334.field_49631, (Object)customName);
            stack.method_57379(class_9334.field_49651, (Object)potionContents);
        }
        return stack;
    }

    private static String toRomanNumeral(int num) {
        if (num < 1 || num > 10) {
            return String.valueOf(num);
        }
        String[] romanNumerals = new String[]{"I", "II", "III", "IV", "V", "VI", "VII", "VIII", "IX", "X"};
        return romanNumerals[num - 1];
    }
}

