/*
 * Decompiled with CFR 0.152.
 */
package net.stardomga.stardomsmagic.util;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecipeUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"stardomsmagic");
    private static final Gson GSON = new Gson();
    private static List<PotionRecipe> loadedRecipes;

    public static void loadRecipes(class_3300 resourceManager) {
        LOGGER.info("[Stardom's Magic] Loading brewing recipes...");
        loadedRecipes = RecipeUtils.loadAndExpandRecipes(resourceManager);
        LOGGER.info("[Stardom's Magic] Loaded {} brewing recipes.", (Object)loadedRecipes.size());
    }

    public static Optional<PotionRecipe> getRecipeFor(String itemId, String potionType, int level) {
        if (loadedRecipes == null) {
            LOGGER.warn("[Stardom's Magic] Recipes not loaded yet. Call loadRecipes() first.");
            return Optional.empty();
        }
        return loadedRecipes.stream().filter(recipe -> recipe.output.item_id.equals(itemId) && recipe.output.potion_type.equals(potionType) && recipe.output.levels == level).findFirst();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static List<PotionRecipe> loadAndExpandRecipes(class_3300 resourceManager) {
        ArrayList<PotionRecipe> recipes = new ArrayList<PotionRecipe>();
        class_2960 recipeId = class_2960.method_60655((String)"stardomsmagic", (String)"recipes/brewing_recipes.json");
        Optional resource = resourceManager.method_14486(recipeId);
        if (resource.isEmpty()) {
            LOGGER.error("[Stardom's Magic] Could not find brewing_recipes.json at {}", (Object)recipeId);
            return recipes;
        }
        try (InputStreamReader reader = new InputStreamReader(((class_3298)resource.get()).method_14482());){
            JsonElement jsonElement = (JsonElement)GSON.fromJson((Reader)reader, JsonElement.class);
            if (!jsonElement.isJsonArray()) {
                LOGGER.error("[Stardom's Magic] Invalid JSON format in {}: Expected an array", (Object)recipeId);
                ArrayList<PotionRecipe> arrayList = recipes;
                return arrayList;
            }
            JsonArray jsonArray = jsonElement.getAsJsonArray();
            for (JsonElement element : jsonArray) {
                int maxLevels;
                JsonObject outputObj;
                JsonObject recipeObj;
                if (!element.isJsonObject() || !(recipeObj = element.getAsJsonObject()).has("output") || !(outputObj = recipeObj.getAsJsonObject("output")).has("levels") || (maxLevels = outputObj.get("levels").getAsInt()) < 1) continue;
                String baseName = ((PotionRecipe)RecipeUtils.GSON.fromJson((JsonElement)recipeObj, PotionRecipe.class)).output.name;
                for (int level = 1; level <= maxLevels; ++level) {
                    PotionRecipe levelRecipe = (PotionRecipe)GSON.fromJson((JsonElement)recipeObj, PotionRecipe.class);
                    levelRecipe.output.levels = level;
                    levelRecipe.output.name = baseName;
                    if (levelRecipe.ingredients == null) {
                        levelRecipe.ingredients = new ArrayList<Ingredient>();
                    }
                    Ingredient waterBottle = new Ingredient();
                    waterBottle.item_id = "minecraft:potion";
                    waterBottle.count = 1;
                    levelRecipe.ingredients.add(waterBottle);
                    int redstoneNeeded = level - 1;
                    if (redstoneNeeded > 0) {
                        Ingredient redstone = new Ingredient();
                        redstone.item_id = "minecraft:redstone";
                        redstone.count = redstoneNeeded;
                        levelRecipe.ingredients.add(redstone);
                    }
                    recipes.add(levelRecipe);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("[Stardom's Magic] Failed to load recipe file {}: {}", new Object[]{recipeId, e.getMessage(), e});
        }
        return recipes;
    }

    public static class PotionRecipe {
        public List<Ingredient> ingredients;
        public Output output;
    }

    public static class Output {
        public String item_id;
        public String potion_type;
        public int levels;
        public String name;
    }

    public static class Ingredient {
        public String item_id;
        public int count;
    }
}

