/*
 * Decompiled with CFR 0.152.
 */
package net.stardomga.stardomsmagic.networking;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1263;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1812;
import net.minecraft.class_1842;
import net.minecraft.class_1844;
import net.minecraft.class_1847;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_8710;
import net.minecraft.class_9334;
import net.stardomga.stardomsmagic.client.screen.BrewingScreenHandler;
import net.stardomga.stardomsmagic.networking.BrewPotionPayload;
import net.stardomga.stardomsmagic.networking.BrewedPotionPayload;
import net.stardomga.stardomsmagic.networking.BrewingResultPayload;
import net.stardomga.stardomsmagic.networking.ClearOutputRequestPayload;
import net.stardomga.stardomsmagic.networking.SyncTabPayload;
import net.stardomga.stardomsmagic.util.RecipeUtils;

public class ModServerNetworking {
    private static final int MAX_DURATION = 9600;
    private static final int MAX_AMPLIFIER = 2;

    public static void register() {
        ServerPlayNetworking.registerGlobalReceiver(SyncTabPayload.ID, (payload, context) -> {
            class_3222 player = context.player();
            int receivedTabIndex = payload.tabIndex();
            player.method_5682().execute(() -> {
                System.out.println("Server received tab sync request: " + String.valueOf(payload));
                class_1703 patt0$temp = player.field_7512;
                if (patt0$temp instanceof BrewingScreenHandler) {
                    BrewingScreenHandler screenHandler = (BrewingScreenHandler)patt0$temp;
                    screenHandler.setCurrentTab(receivedTabIndex);
                    System.out.println("Server-side: Updated BrewingScreenHandler currentTab to: " + receivedTabIndex);
                } else {
                    System.out.println("Server-side: Player not in a BrewingScreenHandler when receiving SyncTabPayload.");
                }
            });
        });
        ServerPlayNetworking.registerGlobalReceiver(BrewPotionPayload.ID, (payload, context) -> {
            class_3222 player = context.player();
            player.method_5682().execute(() -> {
                System.out.println("Server received brewing request: " + String.valueOf(payload));
                class_1703 patt0$temp = player.field_7512;
                if (!(patt0$temp instanceof BrewingScreenHandler)) {
                    System.out.println("Server-side: Player not in a brewing screen handler!");
                    ServerPlayNetworking.send((class_3222)player, (class_8710)new BrewingResultPayload(false, 0, 2));
                    return;
                }
                BrewingScreenHandler screenHandler = (BrewingScreenHandler)patt0$temp;
                String requestedPotionType = payload.potionType();
                int requestedLevel = payload.level();
                if (screenHandler.currentTab == 0) {
                    RecipeUtils.PotionRecipe recipe = RecipeUtils.getRecipe(requestedPotionType, requestedLevel);
                    if (recipe != null) {
                        boolean hasAllIngredients = true;
                        class_1661 playerInventory = player.method_31548();
                        for (RecipeUtils.Ingredient ingredient : recipe.ingredients) {
                            Object requiredStack;
                            if ("minecraft:potion".equals(ingredient.item_id)) {
                                requiredStack = new class_1799((class_1935)class_1802.field_8574);
                                class_1844 waterBottleContents = new class_1844(Optional.of(class_1847.field_8991), Optional.empty(), new ArrayList(), Optional.empty());
                                requiredStack.method_57379(class_9334.field_49651, (Object)waterBottleContents);
                            } else {
                                Optional<class_1792> optionalItem = class_7923.field_41178.method_10223(class_2960.method_60654((String)ingredient.item_id)).map(class_6880::comp_349);
                                if (optionalItem.isEmpty()) {
                                    System.out.println("Server-side: Ingredient item not found: " + ingredient.item_id);
                                    hasAllIngredients = false;
                                    break;
                                }
                                requiredStack = new class_1799((class_1935)optionalItem.get());
                            }
                            boolean found = false;
                            for (int i = 0; i < playerInventory.method_5439(); ++i) {
                                class_1799 stackInSlot = playerInventory.method_5438(i);
                                if (stackInSlot.method_7960() || stackInSlot.method_7909() != requiredStack.method_7909()) continue;
                                if (requiredStack.method_7909() == class_1802.field_8574) {
                                    class_1844 stackInSlotContents = (class_1844)stackInSlot.method_58694(class_9334.field_49651);
                                    class_1844 requiredContents = (class_1844)requiredStack.method_58694(class_9334.field_49651);
                                    System.out.println("--- Water Bottle Check Debug ---");
                                    System.out.println("  Slot " + i + " Item: " + stackInSlot.method_7909().method_63680().getString());
                                    System.out.println("  Slot " + i + " PotionContentsComponent: " + String.valueOf(stackInSlotContents));
                                    System.out.println("  Slot " + i + " Potion: " + String.valueOf(stackInSlotContents != null ? stackInSlotContents.comp_2378() : "null"));
                                    System.out.println("  Required PotionContentsComponent: " + String.valueOf(requiredContents));
                                    System.out.println("  Required Potion: " + String.valueOf(requiredContents != null ? requiredContents.comp_2378() : "null"));
                                    System.out.println("--------------------------------");
                                    if (stackInSlotContents == null || requiredContents == null || !stackInSlotContents.comp_2378().equals(requiredContents.comp_2378()) || stackInSlot.method_7947() < ingredient.count) continue;
                                    found = true;
                                    break;
                                }
                                if (stackInSlot.method_7947() < ingredient.count) continue;
                                found = true;
                                break;
                            }
                            if (found) continue;
                            hasAllIngredients = false;
                            System.out.println("Server-side: Player missing ingredient: " + ingredient.item_id + " (needed " + ingredient.count + ")");
                            break;
                        }
                        if (hasAllIngredients) {
                            class_1799 outputSlotStack = screenHandler.getInventory().method_5438(1);
                            if (outputSlotStack.method_7960()) {
                                Optional potionRegistryEntry;
                                ArrayList<RecipeUtils.Ingredient> ingredientsToConsume = new ArrayList<RecipeUtils.Ingredient>();
                                for (RecipeUtils.Ingredient recipeIngredient : recipe.ingredients) {
                                    RecipeUtils.Ingredient tempIngredient = new RecipeUtils.Ingredient();
                                    tempIngredient.item_id = recipeIngredient.item_id;
                                    tempIngredient.count = recipeIngredient.count;
                                    ingredientsToConsume.add(tempIngredient);
                                }
                                for (RecipeUtils.Ingredient ingredientToConsume : ingredientsToConsume) {
                                    class_1799 itemToDecrement;
                                    if ("minecraft:potion".equals(ingredientToConsume.item_id)) {
                                        itemToDecrement = new class_1799((class_1935)class_1802.field_8574);
                                        class_1844 waterBottleContents = new class_1844(Optional.of(class_1847.field_8991), Optional.empty(), new ArrayList(), Optional.empty());
                                        itemToDecrement.method_57379(class_9334.field_49651, (Object)waterBottleContents);
                                    } else {
                                        Optional<class_1792> optionalItem = class_7923.field_41178.method_10223(class_2960.method_60654((String)ingredientToConsume.item_id)).map(class_6880::comp_349);
                                        if (optionalItem.isEmpty()) {
                                            System.out.println("Server-side: Internal error - Ingredient item not found during consumption: " + ingredientToConsume.item_id);
                                            ServerPlayNetworking.send((class_3222)player, (class_8710)new BrewingResultPayload(false, 0, 2));
                                            return;
                                        }
                                        itemToDecrement = new class_1799((class_1935)optionalItem.get());
                                    }
                                    int remainingToConsume = ingredientToConsume.count;
                                    for (int i = 0; i < playerInventory.method_5439() && remainingToConsume > 0; ++i) {
                                        class_1799 stackInSlot = playerInventory.method_5438(i);
                                        if (stackInSlot.method_7960() || stackInSlot.method_7909() != itemToDecrement.method_7909()) continue;
                                        if (itemToDecrement.method_7909() == class_1802.field_8574) {
                                            class_1844 stackInSlotContents = (class_1844)stackInSlot.method_58694(class_9334.field_49651);
                                            class_1844 requiredContents = (class_1844)itemToDecrement.method_58694(class_9334.field_49651);
                                            if (stackInSlotContents == null || requiredContents == null || !stackInSlotContents.comp_2378().equals(requiredContents.comp_2378())) continue;
                                            int removed = Math.min(remainingToConsume, stackInSlot.method_7947());
                                            stackInSlot.method_7934(removed);
                                            remainingToConsume -= removed;
                                            continue;
                                        }
                                        int removed = Math.min(remainingToConsume, stackInSlot.method_7947());
                                        stackInSlot.method_7934(removed);
                                        remainingToConsume -= removed;
                                    }
                                    if (remainingToConsume <= 0) continue;
                                    System.out.println("Server-side: Failed to consume all required ingredients during brewing. Remaining: " + ingredientToConsume.item_id + " x " + remainingToConsume);
                                    ServerPlayNetworking.send((class_3222)player, (class_8710)new BrewingResultPayload(false, 0, 2));
                                    return;
                                }
                                class_1792 potionBaseItem = (class_1792)((class_6880.class_6883)class_7923.field_41178.method_10223(class_2960.method_60654((String)recipe.output.item_id)).get()).comp_349();
                                class_1799 brewedPotionStack = new class_1799((class_1935)potionBaseItem);
                                if ((potionBaseItem == class_1802.field_8574 || potionBaseItem == class_1802.field_8436 || potionBaseItem == class_1802.field_8150) && (potionRegistryEntry = class_7923.field_41179.method_10223(class_2960.method_60654((String)recipe.output.potion_type))).isPresent()) {
                                    class_1842 basePotion = (class_1842)((class_6880.class_6883)potionRegistryEntry.get()).comp_349();
                                    ArrayList<class_1293> customEffects = new ArrayList<class_1293>();
                                    for (class_1293 baseEffect : basePotion.method_8049()) {
                                        class_1293 newEffect = new class_1293(baseEffect.method_5579(), baseEffect.method_5584(), recipe.output.levels - 1, baseEffect.method_5591(), baseEffect.method_5581(), baseEffect.method_5592());
                                        customEffects.add(newEffect);
                                    }
                                    class_1844 potionContents = new class_1844(Optional.empty(), Optional.empty(), customEffects, Optional.empty());
                                    brewedPotionStack.method_57379(class_9334.field_49651, (Object)potionContents);
                                }
                                if (recipe.output.name != null && !recipe.output.name.isEmpty()) {
                                    class_5250 customName = class_2561.method_43470((String)recipe.output.name).method_10862(class_2583.field_24360.method_10978(Boolean.valueOf(false)));
                                    brewedPotionStack.method_57379(class_9334.field_49631, (Object)customName);
                                }
                                if (brewedPotionStack.method_7909().method_8389() != class_1802.field_8162) {
                                    player.method_7270(brewedPotionStack);
                                }
                                System.out.println("Server-side: Successfully brewed " + brewedPotionStack.method_7909().method_63680().getString());
                                screenHandler.method_34252();
                                screenHandler.method_37420();
                                ServerPlayNetworking.send((class_3222)player, (class_8710)new BrewingResultPayload(true, 0, screenHandler.currentTab));
                            } else {
                                System.out.println("Server-side: Output slot not empty.");
                                ServerPlayNetworking.send((class_3222)player, (class_8710)new BrewingResultPayload(false, 0, 2));
                            }
                        } else {
                            System.out.println("Server-side: Player does not have all required ingredients.");
                            ServerPlayNetworking.send((class_3222)player, (class_8710)new BrewingResultPayload(false, 0, 2));
                        }
                    } else {
                        System.out.println("Server-side: Recipe not found for " + requestedPotionType + " level " + requestedLevel);
                        ServerPlayNetworking.send((class_3222)player, (class_8710)new BrewingResultPayload(false, 0, 2));
                    }
                } else {
                    class_1263 brewingInventory = screenHandler.getInventory();
                    class_1799 inputPotionStack = brewingInventory.method_5438(0);
                    class_1799 ingredientStack = brewingInventory.method_5438(2);
                    class_1799 outputStack = brewingInventory.method_5438(1);
                    boolean isInputPotionValid = !inputPotionStack.method_7960() && inputPotionStack.method_7909() instanceof class_1812;
                    boolean isIngredientValid = false;
                    if (screenHandler.currentTab == 1) {
                        isIngredientValid = !ingredientStack.method_7960() && (ingredientStack.method_7909() == class_1802.field_8601 || ingredientStack.method_7909() == class_1802.field_8725);
                    } else if (screenHandler.currentTab == 2) {
                        isIngredientValid = !ingredientStack.method_7960() && (ingredientStack.method_7909() == class_1802.field_8054 || ingredientStack.method_7909() == class_1802.field_8183 || ingredientStack.method_7909() == class_1802.field_8613);
                    }
                    boolean isOutputSlotEmpty = outputStack.method_7960();
                    System.out.println("Server-side validation check (Tab 1 or 2):");
                    System.out.println(" - Current Tab: " + screenHandler.currentTab);
                    System.out.println(" - Input Potion Stack (Slot 0): " + inputPotionStack.method_7909().method_63680().getString() + " (Empty: " + inputPotionStack.method_7960() + ", Is Potion: " + (inputPotionStack.method_7909() instanceof class_1812) + ")");
                    System.out.println(" - Ingredient Stack (Slot 2): " + ingredientStack.method_7909().method_63680().getString() + " (Empty: " + ingredientStack.method_7960() + ", Is Valid Ingredient for current tab: " + isIngredientValid + ")");
                    System.out.println(" - Output Slot (Slot 1): " + outputStack.method_7909().method_63680().getString() + " (Empty: " + outputStack.method_7960() + ")");
                    if (!(isInputPotionValid && isIngredientValid && isOutputSlotEmpty)) {
                        System.out.println("Server-side inventory validation failed. Conditions:");
                        System.out.println("   - Input present & potion type valid: " + isInputPotionValid);
                        System.out.println("   - Ingredient present & type valid (based on tab): " + isIngredientValid);
                        System.out.println("   - Output slot is empty: " + isOutputSlotEmpty);
                        ServerPlayNetworking.send((class_3222)player, (class_8710)new BrewingResultPayload(false, 0, 2));
                        return;
                    }
                    class_1844 inputPotionContents = (class_1844)inputPotionStack.method_58694(class_9334.field_49651);
                    if (inputPotionContents == null || !inputPotionContents.method_57405()) {
                        System.out.println("Server-side: Input potion has no contents or effects!");
                        ServerPlayNetworking.send((class_3222)player, (class_8710)new BrewingResultPayload(false, 0, 2));
                        return;
                    }
                    List inputEffects = StreamSupport.stream(inputPotionContents.method_57397().spliterator(), false).collect(Collectors.toList());
                    if (inputEffects.isEmpty()) {
                        System.out.println("Server-side: Potion contents (effects) were empty after population from inputPotionContents.");
                        ServerPlayNetworking.send((class_3222)player, (class_8710)new BrewingResultPayload(false, 0, 2));
                        return;
                    }
                    class_1799 brewedPotionStack = inputPotionStack.method_7972();
                    boolean brewingSuccessful = false;
                    ArrayList<Object> newEffects = new ArrayList<Object>();
                    if (screenHandler.currentTab == 1) {
                        if (ingredientStack.method_7909() == class_1802.field_8601) {
                            for (class_1293 effect : inputEffects) {
                                int newDuration = Math.min(effect.method_5584() * 2, 9600);
                                newEffects.add(new class_1293(effect.method_5579(), newDuration, effect.method_5578(), effect.method_5591(), effect.method_5581(), effect.method_5592()));
                            }
                            brewingSuccessful = !newEffects.isEmpty();
                            System.out.println("Server-side: Applied Glowstone (duration extension).");
                        } else if (ingredientStack.method_7909() == class_1802.field_8725) {
                            for (class_1293 effect : inputEffects) {
                                int newAmplifier = Math.min(effect.method_5578() + 1, 2);
                                newEffects.add(new class_1293(effect.method_5579(), effect.method_5584(), newAmplifier, effect.method_5591(), effect.method_5581(), effect.method_5592()));
                            }
                            brewingSuccessful = !newEffects.isEmpty();
                            System.out.println("Server-side: Applied Redstone (amplifier increase).");
                        }
                    } else if (screenHandler.currentTab == 2) {
                        if (ingredientStack.method_7909() == class_1802.field_8613) {
                            if (inputPotionStack.method_7909() == class_1802.field_8574 || inputPotionStack.method_7909() == class_1802.field_8436) {
                                brewedPotionStack = new class_1799((class_1935)class_1802.field_8150, 1);
                                newEffects.addAll(inputEffects);
                                brewingSuccessful = true;
                                System.out.println("Server-side: Converted to Lingering Potion with Dragon's Breath.");
                            }
                        } else if (ingredientStack.method_7909() == class_1802.field_8183) {
                            if (inputPotionStack.method_7909() == class_1802.field_8436 || inputPotionStack.method_7909() == class_1802.field_8150) {
                                brewedPotionStack = new class_1799((class_1935)class_1802.field_8574, 1);
                                newEffects.addAll(inputEffects);
                                brewingSuccessful = true;
                                System.out.println("Server-side: Converted to Potion with Blaze Powder.");
                            }
                        } else if (ingredientStack.method_7909() == class_1802.field_8054 && (inputPotionStack.method_7909() == class_1802.field_8150 || inputPotionStack.method_7909() == class_1802.field_8574)) {
                            brewedPotionStack = new class_1799((class_1935)class_1802.field_8436, 1);
                            newEffects.addAll(inputEffects);
                            brewingSuccessful = true;
                            System.out.println("Server-side: Converted to Splash Potion with Gunpowder.");
                        }
                    } else {
                        System.out.println("Server-side: Invalid ingredient or tab for brewing.");
                    }
                    if (brewingSuccessful) {
                        Optional originalPotionType = inputPotionContents.comp_2378();
                        Optional originalCustomColor = inputPotionContents.comp_2379();
                        class_1844 modifiedContents = new class_1844(Optional.ofNullable(class_1847.field_8991), originalCustomColor, newEffects, Optional.empty());
                        brewedPotionStack.method_57379(class_9334.field_49651, (Object)modifiedContents);
                        String nameFromEffect = ModServerNetworking.getPotionEffectName(inputPotionContents, inputPotionStack);
                        String newPotionName = "Potion of " + nameFromEffect;
                        if (brewedPotionStack.method_7909() == class_1802.field_8436) {
                            newPotionName = "Splash Potion of " + nameFromEffect;
                        } else if (brewedPotionStack.method_7909() == class_1802.field_8150) {
                            newPotionName = "Lingering Potion of " + nameFromEffect;
                        }
                        class_5250 customName = class_2561.method_43470((String)newPotionName).method_10862(class_2583.field_24360.method_10978(Boolean.valueOf(false)));
                        brewedPotionStack.method_57379(class_9334.field_49631, (Object)customName);
                        brewingInventory.method_5447(1, brewedPotionStack);
                        System.out.println("Server-side: Potion brewed and placed in output slot: " + String.valueOf(brewedPotionStack));
                        System.out.println("Server-side: Input effects: " + String.valueOf(inputEffects));
                        System.out.println("Server-side: New effects: " + String.valueOf(newEffects));
                        brewingInventory.method_5431();
                        screenHandler.method_7623();
                        screenHandler.method_37420();
                        screenHandler.method_34252();
                        System.out.println("DEBUG: Sending BrewedPotionPayload. brewedPotionStack is empty: " + brewedPotionStack.method_7960() + ", stack: " + String.valueOf(brewedPotionStack));
                        ServerPlayNetworking.send((class_3222)player, (class_8710)new BrewedPotionPayload(brewedPotionStack, 0, 2));
                    } else {
                        System.out.println("Server-side: Brewing failed (no recognized ingredient modification or invalid effects for current tab).");
                        ServerPlayNetworking.send((class_3222)player, (class_8710)new BrewingResultPayload(false, 0, 2));
                    }
                }
            });
        });
        ServerPlayNetworking.registerGlobalReceiver(ClearOutputRequestPayload.ID, (payload, context) -> {
            class_3222 player = context.player();
            class_1703 patt0$temp = player.field_7512;
            if (patt0$temp instanceof BrewingScreenHandler) {
                BrewingScreenHandler handler = (BrewingScreenHandler)patt0$temp;
                ModServerNetworking.checkAndClearOutput(handler);
            }
        });
    }

    private static void checkAndClearOutput(BrewingScreenHandler handler) {
        if (handler.currentTab >= 1 && handler.currentTab <= 2) {
            class_1799 inputStack = handler.method_7611(0).method_7677();
            class_1799 ingredientStack = handler.method_7611(2).method_7677();
            if (inputStack.method_7960() || ingredientStack.method_7960()) {
                handler.method_7611(1).method_53512(class_1799.field_8037);
                handler.method_34252();
                handler.method_37420();
            }
        }
    }

    public static String getPotionEffectName(class_1844 potionContents, class_1799 inputPotionStack) {
        class_1842 potion;
        Iterator iterator;
        if (potionContents.comp_2378().isPresent() && (iterator = (potion = (class_1842)((class_6880)potionContents.comp_2378().get()).comp_349()).method_8049().iterator()).hasNext()) {
            class_1293 effectInstance = (class_1293)iterator.next();
            class_1291 effect = (class_1291)effectInstance.method_5579().comp_349();
            String translationKey = effect.method_5567();
            return class_2561.method_43471((String)translationKey).getString();
        }
        if (!inputPotionStack.method_7964().getString().isEmpty()) {
            String customName = inputPotionStack.method_7964().getString();
            return customName.replace("Potion of ", "").replace("Splash", "").replace("Lingering", "");
        }
        return "No effect";
    }

    private static String toRomanNumeral(int num) {
        if (num < 1 || num > 10) {
            return String.valueOf(num);
        }
        String[] romanNumerals = new String[]{"I", "II", "III", "IV", "V", "VI", "VII", "VIII", "IX", "X"};
        return romanNumerals[num - 1];
    }
}

