/*
 * Decompiled with CFR 0.152.
 */
package net.stardomga.stardomsmagic.util;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecipeUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"stardomsmagic");
    private static final Gson GSON = new Gson();
    private static List<PotionRecipe> loadedRecipes;

    public static void loadRecipes(class_3300 resourceManager) {
        LOGGER.info("[Stardom's Magic] Loading brewing recipes...");
        loadedRecipes = RecipeUtils.loadAndExpandRecipes(resourceManager);
        LOGGER.info("[Stardom's Magic] Loaded {} brewing recipes.", (Object)loadedRecipes.size());
    }

    public static PotionRecipe getRecipe(String potionType, int level) {
        if (loadedRecipes == null) {
            LOGGER.warn("[Stardom's Magic] Recipes not loaded yet. Call loadRecipes() first.");
            return null;
        }
        for (PotionRecipe recipe : loadedRecipes) {
            if (!recipe.output.potion_type.equals(potionType) || recipe.output.levels != level) continue;
            return recipe;
        }
        return null;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static List<PotionRecipe> loadAndExpandRecipes(class_3300 resourceManager) {
        ArrayList<PotionRecipe> recipes = new ArrayList<PotionRecipe>();
        String[] possiblePaths = new String[]{"data/stardomsmagic/recipes/brewing_recipes.json", "recipes/brewing_recipes.json", "assets/stardomsmagic/recipes/brewing_recipes.json"};
        Optional resource = Optional.empty();
        class_2960 foundId = null;
        LOGGER.info("[Stardom's Magic] Available namespaces: {}", (Object)resourceManager.method_14487());
        for (String path : possiblePaths) {
            class_2960 id = class_2960.method_60655((String)"stardomsmagic", (String)path);
            LOGGER.info("[Stardom's Magic] Looking for recipe file at: {}", (Object)id);
            try {
                Optional res = resourceManager.method_14486(id);
                if (res.isPresent()) {
                    resource = res;
                    foundId = id;
                    LOGGER.info("[Stardom's Magic] Found recipe file at: {}", (Object)id);
                    break;
                }
                LOGGER.warn("[Stardom's Magic] Recipe file not found at: {}", (Object)id);
            }
            catch (Exception e) {
                LOGGER.warn("[Stardom's Magic] Error accessing recipe file at {}: {}", (Object)id, (Object)e.getMessage());
            }
        }
        if (resource.isEmpty()) {
            LOGGER.error("[Stardom's Magic] Could not find brewing_recipes.json in any tried location.");
            return recipes;
        }
        try (InputStreamReader reader = new InputStreamReader(((class_3298)resource.get()).method_14482());){
            JsonElement jsonElement = (JsonElement)GSON.fromJson((Reader)reader, JsonElement.class);
            if (!jsonElement.isJsonArray()) {
                LOGGER.error("[Stardom's Magic] Invalid JSON format in {}: Expected an array", (Object)foundId);
                ArrayList<PotionRecipe> arrayList = recipes;
                return arrayList;
            }
            JsonArray jsonArray = jsonElement.getAsJsonArray();
            for (JsonElement element : jsonArray) {
                int maxLevels;
                JsonObject outputObj;
                JsonObject recipeObj;
                if (!element.isJsonObject() || !(recipeObj = element.getAsJsonObject()).has("output") || !(outputObj = recipeObj.getAsJsonObject("output")).has("levels") || (maxLevels = outputObj.get("levels").getAsInt()) < 1) continue;
                String baseName = ((PotionRecipe)RecipeUtils.GSON.fromJson((JsonElement)recipeObj, PotionRecipe.class)).output.name;
                for (int level = 1; level <= maxLevels; ++level) {
                    PotionRecipe levelRecipe = (PotionRecipe)GSON.fromJson((JsonElement)recipeObj, PotionRecipe.class);
                    levelRecipe.output.levels = level;
                    levelRecipe.output.name = baseName;
                    if (levelRecipe.ingredients == null) {
                        levelRecipe.ingredients = new ArrayList<Ingredient>();
                    }
                    Ingredient waterBottle = new Ingredient();
                    waterBottle.item_id = "minecraft:potion";
                    waterBottle.count = 1;
                    levelRecipe.ingredients.add(waterBottle);
                    int redstoneNeeded = level - 1;
                    if (redstoneNeeded > 0) {
                        for (int i = 0; i < redstoneNeeded; ++i) {
                            Ingredient redstone = new Ingredient();
                            redstone.item_id = "minecraft:redstone";
                            redstone.count = 1;
                            levelRecipe.ingredients.add(redstone);
                        }
                    }
                    recipes.add(levelRecipe);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("[Stardom's Magic] Failed to load recipe file {}: {}", new Object[]{foundId, e.getMessage(), e});
        }
        return recipes;
    }

    private static String convertToRoman(int number) {
        if (number < 1 || number > 5) {
            LOGGER.warn("Attempted to convert number {} to Roman numeral outside of supported range (1-5). Returning string representation.", (Object)number);
            return String.valueOf(number);
        }
        String[] romanNumerals = new String[]{"I", "II", "III", "IV", "V"};
        return romanNumerals[number - 1];
    }

    public static class PotionRecipe {
        public List<Ingredient> ingredients;
        public Output output;
    }

    public static class Output {
        public String item_id;
        public String potion_type;
        public int levels;
        public String name;
    }

    public static class Ingredient {
        public String item_id;
        public int count;
    }
}

