/*
 * Decompiled with CFR 0.152.
 */
package net.stardomga.stardomsmagic;

import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.loot.v3.LootTableEvents;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.object.builder.v1.entity.FabricDefaultAttributeRegistry;
import net.minecraft.class_1657;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_39;
import net.minecraft.class_44;
import net.minecraft.class_5132;
import net.minecraft.class_55;
import net.minecraft.class_5658;
import net.minecraft.class_77;
import net.minecraft.class_79;
import net.minecraft.server.MinecraftServer;
import net.stardomga.stardomsmagic.blocks.ModBlocks;
import net.stardomga.stardomsmagic.blocks.entity.ModBlockEntities;
import net.stardomga.stardomsmagic.client.screen.ModScreenHandlers;
import net.stardomga.stardomsmagic.component.ModDataComponents;
import net.stardomga.stardomsmagic.component.ModEntityComponents;
import net.stardomga.stardomsmagic.entity.ModEntities;
import net.stardomga.stardomsmagic.entity.WizardEntity;
import net.stardomga.stardomsmagic.entity.villager.ModTrades;
import net.stardomga.stardomsmagic.entity.villager.ModVillagers;
import net.stardomga.stardomsmagic.items.ModItemGroups;
import net.stardomga.stardomsmagic.items.ModItems;
import net.stardomga.stardomsmagic.items.SpellbookItem;
import net.stardomga.stardomsmagic.networking.LeftClickPayload;
import net.stardomga.stardomsmagic.networking.ModServerNetworking;
import net.stardomga.stardomsmagic.util.RecipeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StardomsMagic
implements ModInitializer {
    public static final String MOD_ID = "stardomsmagic";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"stardomsmagic");
    public static MinecraftServer SERVER;
    public static final class_2960 LEFT_CLICK_PACKET_ID;

    public void onInitialize() {
        PayloadTypeRegistry.playC2S().register(LeftClickPayload.ID, LeftClickPayload.CODEC);
        ServerLifecycleEvents.SERVER_STARTING.register(server -> {
            SERVER = server;
        });
        FabricDefaultAttributeRegistry.register(ModEntities.WIZARD, (class_5132.class_5133)WizardEntity.createWizardAttributes());
        ModDataComponents.register();
        ModBlockEntities.register();
        ModBlocks.registerModBlocks();
        ModItems.registerModItems();
        ModItems.appendTooltips();
        ModItemGroups.registerItemGroups();
        ModScreenHandlers.registerScreenHandlers();
        ServerLifecycleEvents.SERVER_STARTING.register(server -> ModServerNetworking.register());
        ServerLifecycleEvents.SERVER_STARTED.register(server -> RecipeUtils.loadRecipes(server.method_34864()));
        ServerPlayNetworking.registerGlobalReceiver(LeftClickPayload.ID, (payload, context) -> {
            MinecraftServer server = context.server();
            class_3222 player = context.player();
            server.execute(() -> {
                if (player.method_6047().method_7909() instanceof SpellbookItem) {
                    SpellbookItem spellbook = (SpellbookItem)player.method_6047().method_7909();
                    spellbook.displayHeldItem((class_1657)player);
                }
            });
        });
        ModEntityComponents.registerEntityComponents();
        StardomsMagic.modifyLootTables();
        ModVillagers.registerVillagers();
        ModTrades.registerTrades();
        LOGGER.info("Stardom's Magic initialized!");
    }

    public static void modifyLootTables() {
        System.out.println("Registering loot table modifiers...");
        LootTableEvents.MODIFY.register((key, tableBuilder, source, lookup) -> {
            class_55.class_56 poolBuilder;
            if (source.isBuiltin() && class_39.field_615.equals(key)) {
                System.out.println("Registering nether bridge loot table...");
                poolBuilder = class_55.method_347().method_352((class_5658)class_44.method_32448((float)1.0f)).method_351((class_79.class_80)class_77.method_411((class_1935)ModItems.FLAME_SPELL_RUNE).method_437(5).method_436(1));
                tableBuilder.method_336(poolBuilder);
            }
            if (source.isBuiltin() && class_39.field_274.equals(key)) {
                System.out.println("Registering end city loot table...");
                poolBuilder = class_55.method_347().method_352((class_5658)class_44.method_32448((float)1.0f)).method_351((class_79.class_80)class_77.method_411((class_1935)ModItems.ENDER_SPELL_RUNE).method_437(5).method_436(1));
                tableBuilder.method_336(poolBuilder);
            }
            if (source.isBuiltin() && class_39.field_24046.equals(key)) {
                System.out.println("Registering bastion loot table...");
                poolBuilder = class_55.method_347().method_352((class_5658)class_44.method_32448((float)1.0f)).method_351((class_79.class_80)class_77.method_411((class_1935)ModItems.EXPLOSION_SPELL_RUNE).method_437(5).method_436(1));
                tableBuilder.method_336(poolBuilder);
            }
            if (source.isBuiltin() && class_39.field_885.equals(key)) {
                System.out.println("Registering desert temple loot table...");
                poolBuilder = class_55.method_347().method_352((class_5658)class_44.method_32448((float)1.0f)).method_351((class_79.class_80)class_77.method_411((class_1935)ModItems.THUNDER_SPELL_RUNE).method_437(5).method_436(1));
                tableBuilder.method_336(poolBuilder);
            }
            if (source.isBuiltin() && class_39.field_662.equals(key)) {
                System.out.println("Registering igloo loot table...");
                poolBuilder = class_55.method_347().method_352((class_5658)class_44.method_32448((float)1.0f)).method_351((class_79.class_80)class_77.method_411((class_1935)ModItems.FROST_SPELL_RUNE).method_437(5).method_436(1));
                tableBuilder.method_336(poolBuilder);
            }
            if (source.isBuiltin() && class_39.field_49845.equals(key)) {
                System.out.println("Registering trial chambers loot table...");
                poolBuilder = class_55.method_347().method_352((class_5658)class_44.method_32448((float)1.0f)).method_351((class_79.class_80)class_77.method_411((class_1935)ModItems.WIND_SPELL_RUNE).method_437(5).method_436(1));
                tableBuilder.method_336(poolBuilder);
            }
        });
    }

    static {
        LEFT_CLICK_PACKET_ID = class_2960.method_60655((String)MOD_ID, (String)"left_click");
    }
}

