/*
 * Decompiled with CFR 0.152.
 */
package net.stardomga.stardomsmagic.client.screen;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_10799;
import net.minecraft.class_1293;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1842;
import net.minecraft.class_1844;
import net.minecraft.class_1935;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_465;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_6880;
import net.minecraft.class_7919;
import net.minecraft.class_7923;
import net.minecraft.class_8710;
import net.minecraft.class_9334;
import net.stardomga.stardomsmagic.client.screen.BrewingScreenHandler;
import net.stardomga.stardomsmagic.client.widgets.ItemButtonWidget;
import net.stardomga.stardomsmagic.networking.BrewPotionPayload;
import net.stardomga.stardomsmagic.networking.SyncTabPayload;
import net.stardomga.stardomsmagic.util.RecipeUtils;

public class BrewingScreen
extends class_465<BrewingScreenHandler> {
    private static final class_2960 TEXTURE_TAB_0 = class_2960.method_60655((String)"stardomsmagic", (String)"textures/gui/container/brewing_stand.png");
    private static final class_2960 TEXTURE_TAB_1 = class_2960.method_60655((String)"stardomsmagic", (String)"textures/gui/container/brewing_stand_extend.png");
    private static final class_2960 TEXTURE_TAB_2_FRAME_0 = class_2960.method_60655((String)"stardomsmagic", (String)"textures/gui/container/brewing_stand_conversions_1.png");
    private static final class_2960 TEXTURE_TAB_2_FRAME_1 = class_2960.method_60655((String)"stardomsmagic", (String)"textures/gui/container/brewing_stand_conversions_2.png");
    private static final class_2960 TEXTURE_TAB_2_FRAME_2 = class_2960.method_60655((String)"stardomsmagic", (String)"textures/gui/container/brewing_stand_conversions_3.png");
    private static final List<class_2960> TEXTURES_TAB_2_ANIMATION = List.of(TEXTURE_TAB_2_FRAME_0, TEXTURE_TAB_2_FRAME_1, TEXTURE_TAB_2_FRAME_2);
    private static final class_2960 RECIPE_JSON_ID = class_2960.method_60655((String)"stardomsmagic", (String)"recipes/brewing_recipes.json");
    public static final class_2960 BREW_POTION_PACKET_ID = class_2960.method_60655((String)"stardomsmagic", (String)"brew_potion_packet");
    private static final class_2960 SLOT_TEXTURE = class_2960.method_60655((String)"minecraft", (String)"textures/gui/container/inventory.png");
    private final List<RecipeButton> scrollableButtons = new ArrayList<RecipeButton>();
    private int scrollOffset = 0;
    private final int scrollAreaHeight = 75;
    private int contentHeight = 0;
    private int maxScrollOffset = 0;
    private final int buttonHeight = 20;
    private final int buttonSpacing = 2;
    private final int scrollAreaOffsetY = 12;
    private final int bottomPadding = 10;
    private final List<TabButton> tabButtons = new ArrayList<TabButton>();
    private static final int TAB_BUTTON_WIDTH = 22;
    private static final int TAB_BUTTON_HEIGHT = 17;
    private static final int TAB_BUTTON_SPACING = 12;
    private int selectedTab;
    private final class_1661 playerInventory;
    private int currentAnimationFrame;
    private long lastFrameTime;
    private static final long FRAME_DELAY_MS = 500L;
    private class_342 searchBox;
    private List<RecipeButton> filteredButtons;
    private final class_2338 blockPos;

    private String toRomanNumeral(int num) {
        if (num < 1 || num > 10) {
            return String.valueOf(num);
        }
        String[] romanNumerals = new String[]{"I", "II", "III", "IV", "V", "VI", "VII", "VIII", "IX", "X"};
        return romanNumerals[num - 1];
    }

    public BrewingScreen(BrewingScreenHandler handler, class_1661 inventory, class_2561 title, class_2338 blockPos, int selectedTab) {
        super((class_1703)handler, inventory, title);
        this.playerInventory = class_310.method_1551().field_1724.method_31548();
        this.currentAnimationFrame = 0;
        this.lastFrameTime = 0L;
        this.filteredButtons = new ArrayList<RecipeButton>();
        this.field_2792 = 210;
        this.field_2779 = 193;
        this.field_25270 = this.field_2779 - 94;
        this.selectedTab = selectedTab;
        this.blockPos = blockPos;
        handler.setCurrentTab(selectedTab);
    }

    public BrewingScreen(BrewingScreenHandler handler, class_1661 inventory, class_2561 title, class_2338 blockPos) {
        this(handler, inventory, title, blockPos, 0);
    }

    protected void method_25426() {
        super.method_25426();
        this.field_25267 = (this.field_2792 - this.field_22793.method_27525((class_5348)this.field_22785)) / 2;
        this.field_25269 = 8;
        this.method_37067();
        this.scrollableButtons.clear();
        this.tabButtons.clear();
        List<PotionRecipe> recipes = this.loadAndExpandRecipes();
        int buttonWidth = 154;
        for (PotionRecipe recipe : recipes) {
            RecipeButton button = new RecipeButton(this.field_2776 + 8, 0, buttonWidth, 20, recipe, btn -> {
                BrewPotionPayload payload = new BrewPotionPayload(recipe.output.potion_type, recipe.output.levels);
                ClientPlayNetworking.send((class_8710)payload);
            });
            this.scrollableButtons.add(button);
        }
        this.searchBox = new class_342(this.field_22793, this.field_2776 + 62, this.field_2800 + 96, 106, 11, (class_2561)class_2561.method_43471((String)"itemGroup.search"));
        this.searchBox = new class_342(this.field_22793, this.field_2776 + 62, this.field_2800 + 96, 106, 11, (class_2561)class_2561.method_43471((String)"itemGroup.search"));
        this.searchBox.method_1880(50);
        this.searchBox.method_1858(true);
        this.searchBox.method_1862(true);
        this.searchBox.method_1868(-1);
        this.searchBox.method_47404((class_2561)class_2561.method_43470((String)"Search..."));
        this.method_25429((class_364)this.searchBox);
        this.searchBox.method_1863(this::applySearchFilter);
        this.applySearchFilter("");
        this.contentHeight = !this.scrollableButtons.isEmpty() ? this.scrollableButtons.size() * 22 - 2 + 10 : 0;
        this.maxScrollOffset = Math.max(0, this.contentHeight - 75);
        this.scrollOffset = class_3532.method_15340((int)this.scrollOffset, (int)0, (int)this.maxScrollOffset);
        this.updateButtonPositions();
        int tabButtonStartX = this.field_2776 + this.field_2792 - 31;
        int tabButtonStartY = this.field_2800 + 17;
        class_1799 potionStack = new class_1799((class_1935)class_1802.field_8574);
        potionStack.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)"Potions").method_10862(class_2583.field_24360.method_10978(Boolean.valueOf(false))));
        this.method_37063((class_364)new ItemButtonWidget(tabButtonStartX, tabButtonStartY, 22, 17, potionStack, 0, () -> this.switchToTab(0), () -> this.selectedTab, class_7919.method_47407((class_2561)class_2561.method_43470((String)"Potions"))));
        class_1799 upgradeStack = new class_1799((class_1935)class_1802.field_8601);
        upgradeStack.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)"Upgrades").method_10862(class_2583.field_24360.method_10978(Boolean.valueOf(false))));
        this.method_37063((class_364)new ItemButtonWidget(tabButtonStartX, tabButtonStartY + 17 + 12, 22, 17, upgradeStack, 1, () -> this.switchToTab(1), () -> this.selectedTab, class_7919.method_47407((class_2561)class_2561.method_43470((String)"Upgrades"))));
        class_1799 conversionStack = new class_1799((class_1935)class_1802.field_8613);
        conversionStack.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)"Conversions").method_10862(class_2583.field_24360.method_10978(Boolean.valueOf(false))));
        this.method_37063((class_364)new ItemButtonWidget(tabButtonStartX, tabButtonStartY + 58, 22, 17, conversionStack, 2, () -> this.switchToTab(2), () -> this.selectedTab, class_7919.method_47407((class_2561)class_2561.method_43470((String)"Conversions"))));
    }

    private void switchToTab(int newTab) {
        if (this.selectedTab != newTab) {
            this.selectedTab = newTab;
            ((BrewingScreenHandler)this.field_2797).setCurrentTab(newTab);
            ClientPlayNetworking.send((class_8710)new SyncTabPayload(newTab));
            this.method_25423(class_310.method_1551(), this.field_22789, this.field_22790);
            if (newTab == 2) {
                this.currentAnimationFrame = 0;
                this.lastFrameTime = System.currentTimeMillis();
            }
        }
    }

    private void updateButtonPositions() {
        int baseY = this.field_2800 + 10 + 12;
        for (int i = 0; i < this.filteredButtons.size(); ++i) {
            RecipeButton button = this.filteredButtons.get(i);
            int originalY = baseY + i * 22;
            button.method_46419(originalY - this.scrollOffset);
        }
    }

    private void applySearchFilter(String searchText) {
        System.out.println("Search text changed to: '" + searchText + "'");
        this.filteredButtons.clear();
        String lowerCaseSearchText = searchText.toLowerCase(Locale.ROOT);
        if (lowerCaseSearchText.isEmpty()) {
            this.filteredButtons.addAll(this.scrollableButtons);
        } else {
            for (RecipeButton button : this.scrollableButtons) {
                String outputName = button.recipe.output.name.toLowerCase(Locale.ROOT);
                String potionType = button.recipe.output.potion_type.toLowerCase(Locale.ROOT);
                if (!outputName.contains(lowerCaseSearchText) && !potionType.contains(lowerCaseSearchText)) continue;
                this.filteredButtons.add(button);
            }
        }
        this.contentHeight = !this.filteredButtons.isEmpty() ? this.filteredButtons.size() * 22 - 2 + 10 : 0;
        this.maxScrollOffset = Math.max(0, this.contentHeight - 75);
        this.scrollOffset = class_3532.method_15340((int)this.scrollOffset, (int)0, (int)this.maxScrollOffset);
        this.updateButtonPositions();
    }

    private List<PotionRecipe> loadAndExpandRecipes() {
        try {
            List<RecipeUtils.PotionRecipe> recipes = RecipeUtils.loadAndExpandRecipes(this.field_22787.method_1478());
            return recipes.stream().map(recipe -> {
                PotionRecipe localRecipe = new PotionRecipe();
                localRecipe.ingredients = recipe.ingredients;
                localRecipe.output = recipe.output;
                return localRecipe;
            }).collect(Collectors.toList());
        }
        catch (Exception e) {
            this.field_22787.field_1724.method_7353((class_2561)class_2561.method_43470((String)("Failed to load recipes: " + e.getMessage())), false);
            return new ArrayList<PotionRecipe>();
        }
    }

    protected void method_2389(class_332 context, float delta, int mouseX, int mouseY) {
        int x = (this.field_22789 - this.field_2792) / 2;
        int y = (this.field_22790 - this.field_2779) / 2;
        context.method_25290(class_10799.field_56883, switch (this.selectedTab) {
            case 0 -> TEXTURE_TAB_0;
            case 1 -> TEXTURE_TAB_1;
            case 2 -> {
                long currentTime = System.currentTimeMillis();
                if (currentTime - this.lastFrameTime > 500L) {
                    this.currentAnimationFrame = (this.currentAnimationFrame + 1) % TEXTURES_TAB_2_ANIMATION.size();
                    this.lastFrameTime = currentTime;
                }
                yield TEXTURES_TAB_2_ANIMATION.get(this.currentAnimationFrame);
            }
            default -> TEXTURE_TAB_0;
        }, x, y, 0.0f, 0.0f, this.field_2792, this.field_2779, 256, 256);
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        this.method_25420(context, mouseX, mouseY, delta);
        this.method_2389(context, delta, mouseX, mouseY);
        super.method_25394(context, mouseX, mouseY, delta);
        int x = (this.field_22789 - this.field_2792) / 2;
        int y = (this.field_22790 - this.field_2779) / 2;
        int scrollAreaX = this.field_2776 + 6;
        int scrollAreaY = this.field_2800 + 5 + 12;
        int scrollAreaWidth = 160;
        int adjustedScrollAreaHeight = 75;
        if (this.selectedTab == 0) {
            context.method_25294(scrollAreaX, scrollAreaY, scrollAreaX + scrollAreaWidth, scrollAreaY + adjustedScrollAreaHeight, Integer.MIN_VALUE);
            context.method_44379(scrollAreaX, scrollAreaY, scrollAreaX + scrollAreaWidth, scrollAreaY + adjustedScrollAreaHeight);
            for (RecipeButton button : this.filteredButtons) {
                if (button.method_46427() + button.method_25364() <= scrollAreaY || button.method_46427() >= scrollAreaY + adjustedScrollAreaHeight) continue;
                button.method_25394(context, mouseX, mouseY, delta);
            }
            context.method_44380();
            if (this.maxScrollOffset > 0) {
                int scrollbarTrackHeight = adjustedScrollAreaHeight;
                int scrollbarHandleHeight = (int)((float)adjustedScrollAreaHeight / (float)(this.contentHeight + 10) * (float)scrollbarTrackHeight);
                scrollbarHandleHeight = class_3532.method_15340((int)scrollbarHandleHeight, (int)8, (int)scrollbarTrackHeight);
                int scrollbarHandleY = scrollAreaY + (int)((float)this.scrollOffset / (float)this.maxScrollOffset * (float)(scrollbarTrackHeight - scrollbarHandleHeight));
                int scrollbarX = scrollAreaX + scrollAreaWidth + 2;
                context.method_25294(scrollbarX, scrollbarHandleY, scrollbarX + 4, scrollbarHandleY + scrollbarHandleHeight, -1);
            }
            if (this.searchBox != null) {
                this.searchBox.method_25394(context, mouseX, mouseY, delta);
            }
        } else {
            this.renderTabContent(context, mouseX, mouseY, delta);
        }
        if (this.selectedTab == 0) {
            for (RecipeButton button : this.filteredButtons) {
                int ingredientStartX;
                if (!button.method_25405(mouseX, mouseY)) continue;
                int itemX = button.method_46426() + 2;
                int itemY = button.method_46427() + 2;
                if (mouseX >= itemX && mouseX < itemX + 16 && mouseY >= itemY && mouseY < itemY + 16) {
                    class_1799 potionStack = button.createPotionItemStack(button.recipe.output.item_id, button.recipe.output.potion_type, button.recipe.output.levels, button.recipe.output.name);
                    context.method_51446(this.field_22793, potionStack, mouseX, mouseY);
                    return;
                }
                int currentIngredientX = ingredientStartX = button.method_46426() + 60;
                int ingredientY = button.method_46427() + 2;
                for (RecipeUtils.Ingredient ingredient : button.recipe.ingredients) {
                    if (mouseX >= currentIngredientX && mouseX < currentIngredientX + 16 && mouseY >= ingredientY && mouseY < ingredientY + 16) {
                        if (ingredient.item_id.equals(class_2960.method_60655((String)"minecraft", (String)"potion").toString())) {
                            class_1799 waterBottleStack = this.createWaterBottleItemStack();
                            context.method_51446(this.field_22793, waterBottleStack, mouseX, mouseY);
                        } else {
                            Optional<class_1792> optionalItem = class_7923.field_41178.method_10223(class_2960.method_60654((String)ingredient.item_id)).map(class_6880::comp_349);
                            if (optionalItem.isPresent()) {
                                class_1799 ingredientStack = new class_1799((class_1935)optionalItem.get(), ingredient.count);
                                context.method_51446(this.field_22793, ingredientStack, mouseX, mouseY);
                            }
                        }
                        return;
                    }
                    currentIngredientX += 18;
                }
            }
        }
        for (TabButton tabButton : this.tabButtons) {
            if (!tabButton.method_25405(mouseX, mouseY)) continue;
            context.method_51438(this.field_22793, tabButton.getTooltip(), mouseX, mouseY);
            return;
        }
        super.method_2380(context, mouseX, mouseY);
    }

    private void renderTabContent(class_332 context, int mouseX, int mouseY, float delta) {
        int contentAreaX = this.field_2776 + 8;
        int contentAreaY = this.field_2800 + 10 + 12;
        int contentAreaWidth = 160;
        int contentAreaHeight = 75;
        String text = switch (this.selectedTab) {
            case 1 -> "Upgrade Tab Content";
            case 2 -> "Conversion Tab Content";
            default -> "Potion Tab";
        };
        context.method_51439(this.field_22793, (class_2561)class_2561.method_43470((String)text), contentAreaX + 5, contentAreaY + 5, 0xFFFFFF, true);
    }

    protected void method_2388(class_332 context, int mouseX, int mouseY) {
        super.method_2388(context, mouseX, mouseY);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.searchBox.method_25370() && !this.searchBox.method_25405(mouseX, mouseY)) {
            this.searchBox.method_25365(false);
        }
        for (TabButton tabButton : this.tabButtons) {
            if (!tabButton.method_25402(mouseX, mouseY, button)) continue;
            System.out.println("Tab button click processed for tab: " + tabButton.tabIndex);
            return true;
        }
        if (this.selectedTab == 0) {
            int scrollAreaX = this.field_2776 + 6;
            int scrollAreaY = this.field_2800 + 5 + 12;
            int scrollAreaWidth = this.field_2792 - 16;
            int adjustedScrollAreaHeight = 75;
            if (mouseX >= (double)scrollAreaX && mouseX <= (double)(scrollAreaX + scrollAreaWidth) && mouseY >= (double)scrollAreaY && mouseY <= (double)(scrollAreaY + adjustedScrollAreaHeight)) {
                for (class_4185 class_41852 : this.filteredButtons) {
                    int buttonScreenY = class_41852.method_46427();
                    if (buttonScreenY + class_41852.method_25364() <= scrollAreaY || buttonScreenY >= scrollAreaY + adjustedScrollAreaHeight || !(mouseX >= (double)class_41852.method_46426()) || !(mouseX < (double)(class_41852.method_46426() + class_41852.method_25368())) || !(mouseY >= (double)buttonScreenY) || !(mouseY < (double)(buttonScreenY + class_41852.method_25364())) || !class_41852.method_25402(mouseX, mouseY, button)) continue;
                    return true;
                }
            }
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25401(double mouseX, double mouseY, double amountX, double amountY) {
        if (this.selectedTab == 0) {
            int scrollAreaX = this.field_2776 + 6;
            int scrollAreaY = this.field_2800 + 5 + 12;
            int scrollAreaWidth = this.field_2792 - 16;
            int adjustedScrollAreaHeight = 75;
            if (this.selectedTab == 0 && this.searchBox != null) {
                scrollAreaY += this.searchBox.method_25364() + 2;
                if ((adjustedScrollAreaHeight -= this.searchBox.method_25364() + 2) < 0) {
                    adjustedScrollAreaHeight = 0;
                }
            }
            if (mouseX >= (double)scrollAreaX && mouseX <= (double)(scrollAreaX + scrollAreaWidth) && mouseY >= (double)scrollAreaY && mouseY <= (double)(scrollAreaY + adjustedScrollAreaHeight)) {
                this.scrollOffset -= (int)(amountY * 10.0);
                this.scrollOffset = class_3532.method_15340((int)this.scrollOffset, (int)0, (int)this.maxScrollOffset);
                this.updateButtonPositions();
                return true;
            }
        }
        return super.method_25401(mouseX, mouseY, amountX, amountY);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.searchBox.method_25370()) {
            if (keyCode == 256) {
                this.searchBox.method_25365(false);
                return true;
            }
            return this.searchBox.method_25404(keyCode, scanCode, modifiers);
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_25400(char chr, int modifiers) {
        if (this.searchBox.method_25370()) {
            return this.searchBox.method_25400(chr, modifiers);
        }
        return super.method_25400(chr, modifiers);
    }

    private class_1799 createWaterBottleItemStack() {
        class_1799 waterBottleStack = new class_1799((class_1935)class_1802.field_8574, 1);
        waterBottleStack.method_57379(class_9334.field_49651, (Object)new class_1844(Optional.empty(), Optional.empty(), new ArrayList(), Optional.empty()));
        class_5250 waterBottleName = class_2561.method_43470((String)"Water Bottle").method_10862(class_2583.field_24360.method_10978(Boolean.valueOf(false)));
        waterBottleStack.method_57379(class_9334.field_49631, (Object)waterBottleName);
        return waterBottleStack;
    }

    public static class PotionRecipe
    extends RecipeUtils.PotionRecipe {
    }

    class RecipeButton
    extends class_4185 {
        private final PotionRecipe recipe;

        public RecipeButton(int x, int y, int width, int height, PotionRecipe recipe, class_4185.class_4241 onPress) {
            super(x, y, width, height, (class_2561)class_2561.method_43473(), onPress, field_40754);
            this.recipe = recipe;
        }

        public void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
            int ingredientStartX;
            super.method_48579(context, mouseX, mouseY, delta);
            int itemX = this.method_46426() + 2;
            int itemY = this.method_46427() + 2;
            class_1799 potionStack = this.createPotionItemStack(this.recipe.output.item_id, this.recipe.output.potion_type, this.recipe.output.levels, this.recipe.output.name);
            context.method_51427(potionStack, itemX, itemY);
            if (potionStack.method_7947() > 1) {
                class_327 class_3272 = BrewingScreen.this.field_22793;
                String string = String.valueOf(potionStack.method_7947());
                int n = itemX + 16 - BrewingScreen.this.field_22793.method_1727(String.valueOf(potionStack.method_7947()));
                Objects.requireNonNull(BrewingScreen.this.field_22793);
                context.method_51433(class_3272, string, n, itemY + 16 - 9, 0xFFFFFF, true);
            }
            String levelText = "Lvl " + BrewingScreen.this.toRomanNumeral(this.recipe.output.levels);
            class_327 class_3273 = BrewingScreen.this.field_22793;
            class_5250 class_52502 = class_2561.method_43470((String)levelText);
            Objects.requireNonNull(BrewingScreen.this.field_22793);
            context.method_51439(class_3273, (class_2561)class_52502, itemX + 18, itemY + 10 - 9 / 2, 0xFFFFFF, true);
            int currentIngredientX = ingredientStartX = this.method_46426() + 60;
            int ingredientY = this.method_46427() + 2;
            for (RecipeUtils.Ingredient ingredient : this.recipe.ingredients) {
                Optional<class_1792> optionalItem = class_7923.field_41178.method_10223(class_2960.method_60654((String)ingredient.item_id)).map(class_6880::comp_349);
                if (!optionalItem.isPresent()) continue;
                class_1799 ingredientStack = ingredient.item_id.equals(class_2960.method_60655((String)"minecraft", (String)"potion").toString()) ? BrewingScreen.this.createWaterBottleItemStack() : new class_1799((class_1935)optionalItem.get(), ingredient.count);
                context.method_51427(ingredientStack, currentIngredientX, ingredientY);
                if (ingredientStack.method_7947() > 1) {
                    String countText = String.valueOf(ingredientStack.method_7947());
                    class_327 class_3274 = BrewingScreen.this.field_22793;
                    int n = currentIngredientX + 16 - BrewingScreen.this.field_22793.method_1727(countText);
                    Objects.requireNonNull(BrewingScreen.this.field_22793);
                    context.method_51433(class_3274, countText, n, ingredientY + 16 - 9, 0xFFFFFF, true);
                }
                currentIngredientX += 18;
            }
        }

        private class_1799 createPotionItemStack(String itemId, String potionTypeId, int level, String name) {
            class_1792 item = (class_1792)class_7923.field_41178.method_63535(class_2960.method_60654((String)itemId));
            class_1799 stack = new class_1799((class_1935)item, 1);
            if (itemId.equals(class_1802.field_8574.toString()) && potionTypeId.equals(class_2960.method_60655((String)"minecraft", (String)"empty").toString())) {
                return BrewingScreen.this.createWaterBottleItemStack();
            }
            Optional potionEntry = class_7923.field_41179.method_10223(class_2960.method_60654((String)potionTypeId));
            if (potionEntry.isPresent()) {
                class_1842 basePotion = (class_1842)((class_6880.class_6883)potionEntry.get()).comp_349();
                ArrayList<class_1293> customEffects = new ArrayList<class_1293>();
                for (class_1293 baseEffect : basePotion.method_8049()) {
                    class_1293 newEffect = new class_1293(baseEffect.method_5579(), baseEffect.method_5584(), level - 1, baseEffect.method_5591(), baseEffect.method_5581(), baseEffect.method_5592());
                    customEffects.add(newEffect);
                }
                class_1844 potionContents = new class_1844(Optional.empty(), Optional.empty(), customEffects, Optional.empty());
                Object displayName = name;
                if (level > 1) {
                    displayName = (String)displayName + " ";
                }
                class_5250 customName = class_2561.method_43470((String)("Potion of " + (String)displayName)).method_10862(class_2583.field_24360.method_10978(Boolean.valueOf(false)));
                stack.method_57379(class_9334.field_49631, (Object)customName);
                stack.method_57379(class_9334.field_49651, (Object)potionContents);
            }
            return stack;
        }

        public boolean method_25405(double mouseX, double mouseY) {
            int scrollAreaX = BrewingScreen.this.field_2776 + 6;
            int scrollAreaY = BrewingScreen.this.field_2800 + 5 + BrewingScreen.this.scrollAreaOffsetY;
            int scrollAreaWidth = BrewingScreen.this.field_2792 - 16;
            int adjustedScrollAreaHeight = BrewingScreen.this.scrollAreaHeight;
            if (BrewingScreen.this.selectedTab == 0 && BrewingScreen.this.searchBox != null) {
                scrollAreaY += BrewingScreen.this.searchBox.method_25364() + BrewingScreen.this.buttonSpacing;
                if ((adjustedScrollAreaHeight -= BrewingScreen.this.searchBox.method_25364() + BrewingScreen.this.buttonSpacing) < 0) {
                    adjustedScrollAreaHeight = 0;
                }
            }
            return super.method_25405(mouseX, mouseY) && mouseX >= (double)scrollAreaX && mouseX < (double)(scrollAreaX + scrollAreaWidth) && mouseY >= (double)scrollAreaY && mouseY < (double)(scrollAreaY + adjustedScrollAreaHeight + BrewingScreen.this.bottomPadding) && this.method_46427() + this.method_25364() > scrollAreaY && this.method_46427() < scrollAreaY + adjustedScrollAreaHeight + BrewingScreen.this.bottomPadding;
        }
    }

    class TabButton
    extends class_4185 {
        private final class_1799 iconStack;
        private final class_2561 tooltipText;
        private final int yIconOffset;
        public final int tabIndex;

        public TabButton(int x, int y, int width, int height, class_1799 icon, int yIconOffset, int tabIndex, class_4185.class_4241 onPress, class_2561 customName) {
            super(x, y, width, height, (class_2561)class_2561.method_43473(), onPress, field_40754);
            this.iconStack = icon;
            this.tooltipText = customName;
            this.yIconOffset = yIconOffset;
            this.tabIndex = tabIndex;
            this.field_22763 = true;
            this.field_22764 = true;
        }

        public TabButton(int x, int y, int width, int height, class_1799 icon, int yIconOffset, int tabIndex, class_4185.class_4241 onPress) {
            this(x, y, width, height, icon, yIconOffset, tabIndex, onPress, icon.method_7964());
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            if (this.field_22763 && this.field_22764 && this.method_25405(mouseX, mouseY)) {
                System.out.println("TabButton clicked: Tab " + this.tabIndex);
                this.field_22767.onPress((class_4185)this);
                return true;
            }
            return false;
        }

        public void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
            context.method_49601(this.method_46426(), this.method_46427(), this.method_25368(), this.method_25364(), -65536);
            super.method_48579(context, mouseX, mouseY, delta);
            if (BrewingScreen.this.selectedTab == this.tabIndex) {
                context.method_49601(this.method_46426(), this.method_46427(), this.method_25368(), this.method_25364(), -22016);
            }
            int iconX = this.method_46426() + (this.field_22758 - 16) / 2;
            int iconY = this.method_46427() + (this.field_22759 - 16) / 2 + this.yIconOffset;
            context.method_51427(this.iconStack, iconX, iconY);
        }

        public class_2561 getTooltip() {
            return this.tooltipText;
        }
    }
}

