/*
 * Decompiled with CFR 0.152.
 */
package net.stardomga.stardomsmagic.mixin;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1718;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1889;
import net.minecraft.class_1890;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3914;
import net.minecraft.class_3915;
import net.minecraft.class_5455;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_746;
import net.minecraft.class_7924;
import net.minecraft.class_9304;
import net.minecraft.class_9636;
import net.stardomga.stardomsmagic.client.screen.ScreenAccessor;
import net.stardomga.stardomsmagic.items.ModItems;
import net.stardomga.stardomsmagic.mixin.EnchantmentScreenHandlerAccessor;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1718.class})
public abstract class EnchantmentScreenHandlerMixin
implements EnchantmentScreenHandlerAccessor {
    @Shadow
    public int[] field_7808;
    @Shadow
    public int[] field_7812;
    @Shadow
    public int[] field_7810;
    @Shadow
    protected class_1263 field_7809;
    @Shadow
    protected class_3914 field_7813;
    @Shadow
    class_5819 field_7811;
    @Shadow
    class_3915 field_7814;
    @Unique
    private static final int OFFSET_X = -17;
    private static final class_2960 EMPTY_LAPIS_LAZULI_SLOT_TEXTURE = class_2960.method_60656((String)"container/slot/lapis_lazuli");
    private static final class_2960 EMPTY_RUNE_SLOT_TEXTURE = class_2960.method_60655((String)"stardomsmagic", (String)"container/slot/rune_enchant");
    @Unique
    private class_1657 cachedPlayer;
    @Unique
    private class_6880<class_1887>[] buttonEnchantmentEntries = new class_6880[3];
    @Unique
    private int lastTab = -1;

    @Shadow
    protected abstract List<class_1889> method_7637(class_5455 var1, class_1799 var2, int var3, int var4);

    @Shadow
    public abstract boolean method_7604(class_1657 var1, int var2);

    @ModifyArg(method={"<init>(ILnet/minecraft/entity/player/PlayerInventory;Lnet/minecraft/screen/ScreenHandlerContext;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/screen/EnchantmentScreenHandler;addSlot(Lnet/minecraft/screen/slot/Slot;)Lnet/minecraft/screen/slot/Slot;", ordinal=0), index=0)
    private class_1735 modifyItemSlot(class_1735 original) {
        return new class_1735(this, original.field_7871, 0, original.field_7873 + -17, original.field_7872){

            public int method_7675() {
                return 1;
            }

            public boolean method_7680(class_1799 stack) {
                int currentTab;
                class_310 client = class_310.method_1551();
                if (client != null && client.field_1755 instanceof ScreenAccessor && (currentTab = ((ScreenAccessor)client.field_1755).getCurrentTab()) != 0) {
                    return stack.method_7942();
                }
                return true;
            }
        };
    }

    @ModifyArg(method={"<init>(ILnet/minecraft/entity/player/PlayerInventory;Lnet/minecraft/screen/ScreenHandlerContext;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/screen/EnchantmentScreenHandler;addSlot(Lnet/minecraft/screen/slot/Slot;)Lnet/minecraft/screen/slot/Slot;", ordinal=1), index=0)
    private class_1735 modifyLapisSlot(class_1735 original) {
        return new class_1735(original.field_7871, original.method_34266(), original.field_7873 + -17, original.field_7872){

            public int method_7675() {
                return 64;
            }

            public boolean method_7680(class_1799 stack) {
                class_310 client = class_310.method_1551();
                if (client != null && client.field_1755 instanceof ScreenAccessor) {
                    int currentTab = ((ScreenAccessor)client.field_1755).getCurrentTab();
                    System.out.println("[DEBUG] Lapis slot canInsert - Current tab: " + currentTab);
                    if (currentTab == 0) {
                        return stack.method_31574(class_1802.field_8759);
                    }
                    return stack.method_31574(ModItems.RUNE_ENCHANT);
                }
                return stack.method_31574(class_1802.field_8759) || stack.method_31574(ModItems.RUNE_ENCHANT);
            }

            public class_2960 method_7679() {
                class_310 client = class_310.method_1551();
                if (client != null && client.field_1755 instanceof ScreenAccessor) {
                    int currentTab = ((ScreenAccessor)client.field_1755).getCurrentTab();
                    if (EnchantmentScreenHandlerMixin.this.lastTab != currentTab) {
                        EnchantmentScreenHandlerMixin.this.lastTab = currentTab;
                        EnchantmentScreenHandlerMixin.this.switchedTabs();
                    }
                    if (currentTab == 0) {
                        return EMPTY_LAPIS_LAZULI_SLOT_TEXTURE;
                    }
                    return EMPTY_RUNE_SLOT_TEXTURE;
                }
                return EMPTY_LAPIS_LAZULI_SLOT_TEXTURE;
            }
        };
    }

    @ModifyArg(method={"<init>(ILnet/minecraft/entity/player/PlayerInventory;Lnet/minecraft/screen/ScreenHandlerContext;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/screen/EnchantmentScreenHandler;addPlayerSlots(Lnet/minecraft/inventory/Inventory;II)V"), index=1)
    private int modifyPlayerSlotX(int originalX) {
        return originalX + -17;
    }

    @Inject(method={"<init>(ILnet/minecraft/entity/player/PlayerInventory;Lnet/minecraft/screen/ScreenHandlerContext;)V"}, at={@At(value="TAIL")})
    private void capturePlayer(int syncId, class_1661 playerInventory, class_3914 context, CallbackInfo ci) {
        this.cachedPlayer = playerInventory.field_7546;
    }

    public void switchedTabs() {
        if (this.cachedPlayer != null) {
            this.cachedPlayer.method_7270(this.field_7809.method_5438(0));
            this.cachedPlayer.method_7270(this.field_7809.method_5438(1));
            this.field_7809.method_5448();
        }
    }

    @Inject(method={"onContentChanged"}, at={@At(value="HEAD")}, cancellable=true)
    private void onContentChanged(class_1263 inventory, CallbackInfo ci) {
        if (this.cachedPlayer == null) {
            System.out.println("[DEBUG] onContentChanged - No cached player, skipping");
            return;
        }
        boolean isClient = this.cachedPlayer.method_37908().field_9236;
        int currentTab = 0;
        if (isClient) {
            class_310 client = class_310.method_1551();
            if (client != null && client.field_1755 instanceof ScreenAccessor) {
                currentTab = ((ScreenAccessor)client.field_1755).getCurrentTab();
                System.out.println("[DEBUG] onContentChanged - Client side, Current tab: " + currentTab);
            } else {
                System.out.println("[DEBUG] onContentChanged - Client screen not accessible, assuming tab 0");
            }
        } else {
            currentTab = inventory.method_5438(1).method_31574(ModItems.RUNE_ENCHANT) ? 1 : 0;
            System.out.println("[DEBUG] onContentChanged - Server side, Inferred tab: " + currentTab);
        }
        Arrays.fill(this.buttonEnchantmentEntries, null);
        if (currentTab != 1) {
            return;
        }
        ci.cancel();
        if (inventory.method_5438(0).method_7960() || inventory.method_5438(1).method_7960()) {
            try {
                Field powerField = class_1718.class.getDeclaredField("enchantmentPower");
                Field idField = class_1718.class.getDeclaredField("enchantmentId");
                Field levelField = class_1718.class.getDeclaredField("enchantmentLevel");
                powerField.setAccessible(true);
                idField.setAccessible(true);
                levelField.setAccessible(true);
                powerField.set(this, new int[3]);
                idField.set(this, new int[]{-1, -1, -1});
                levelField.set(this, new int[]{-1, -1, -1});
                ((class_1718)this).method_7623();
                System.out.println("[DEBUG] Cleared enchantments due to empty slots");
            }
            catch (Exception e) {
                System.err.println("[ERROR] Failed to clear enchantments: " + e.getMessage());
                e.printStackTrace();
            }
            return;
        }
        if (inventory.method_5438(1).method_31574(ModItems.RUNE_ENCHANT) && inventory.method_5438(0).method_7942()) {
            class_1799 stack = inventory.method_5438(0);
            System.out.println("[DEBUG] Item stack enchantments: " + String.valueOf(stack.method_58657().method_57539()));
            class_5455 registryManager = this.cachedPlayer.method_56673();
            class_2378 enchantmentRegistry = registryManager.method_30530(class_7924.field_41265);
            ArrayList<Map.Entry> entries = new ArrayList<Map.Entry>(stack.method_58657().method_57539());
            System.out.println("[DEBUG] Enchantment entries size: " + entries.size());
            entries.removeIf(entry -> {
                if (((class_6880)entry.getKey()).comp_349() == null) {
                    return true;
                }
                return (Integer)entry.getValue() >= ((class_1887)((class_6880)entry.getKey()).comp_349()).method_8183();
            });
            if (entries.isEmpty()) {
                System.out.println("[DEBUG] No valid enchantments found on item for upgrade");
                try {
                    Field powerField = class_1718.class.getDeclaredField("enchantmentPower");
                    Field idField = class_1718.class.getDeclaredField("enchantmentId");
                    Field levelField = class_1718.class.getDeclaredField("enchantmentLevel");
                    powerField.setAccessible(true);
                    idField.setAccessible(true);
                    levelField.setAccessible(true);
                    powerField.set(this, new int[3]);
                    idField.set(this, new int[]{-1, -1, -1});
                    levelField.set(this, new int[]{-1, -1, -1});
                    Arrays.fill(this.buttonEnchantmentEntries, null);
                    ((class_1718)this).method_7623();
                }
                catch (Exception e) {
                    System.err.println("[ERROR] Failed to clear enchantments: " + e.getMessage());
                    e.printStackTrace();
                }
                return;
            }
            int count = Math.min(3, entries.size());
            int[] newPower = new int[3];
            int[] newEnchantmentId = new int[3];
            int[] newEnchantmentLevel = new int[3];
            Arrays.fill(newPower, 0);
            Arrays.fill(newEnchantmentId, -1);
            Arrays.fill(newEnchantmentLevel, -1);
            Arrays.fill(this.buttonEnchantmentEntries, null);
            for (int i = 0; i < count; ++i) {
                Map.Entry entry2 = (Map.Entry)entries.get(i);
                class_1887 enchantment = (class_1887)((class_6880)entry2.getKey()).comp_349();
                int rawId = enchantmentRegistry.method_10206((Object)enchantment);
                if (rawId == -1) continue;
                newPower[i] = ((Integer)entry2.getValue() + 1) * 10 / 2 - 5;
                newEnchantmentId[i] = rawId;
                newEnchantmentLevel[i] = (Integer)entry2.getValue() + 1;
                this.buttonEnchantmentEntries[i] = (class_6880)entry2.getKey();
                System.out.println("[DEBUG] Button " + i + " shows " + String.valueOf(enchantment) + " at target level " + ((Integer)entry2.getValue() + 1));
            }
            try {
                Field powerField = class_1718.class.getDeclaredField("enchantmentPower");
                Field idField = class_1718.class.getDeclaredField("enchantmentId");
                Field levelField = class_1718.class.getDeclaredField("enchantmentLevel");
                powerField.setAccessible(true);
                idField.setAccessible(true);
                levelField.setAccessible(true);
                powerField.set(this, newPower);
                idField.set(this, newEnchantmentId);
                levelField.set(this, newEnchantmentLevel);
                System.out.println("[DEBUG] Updated enchantment fields - Power: " + Arrays.toString(newPower) + ", IDs: " + Arrays.toString(newEnchantmentId) + ", Levels: " + Arrays.toString(newEnchantmentLevel));
                ((class_1718)this).method_7623();
            }
            catch (Exception e) {
                System.err.println("[ERROR] Failed to update enchantment fields: " + e.getMessage());
                e.printStackTrace();
            }
        }
    }

    @Inject(method={"generateEnchantments"}, at={@At(value="HEAD")}, cancellable=true)
    private void generateEnchantmentsOverride(class_5455 registryManager, class_1799 stack, int slot, int level, CallbackInfoReturnable<List<class_1889>> cir) {
        if (this.cachedPlayer == null) {
            return;
        }
        boolean isClient = this.cachedPlayer.method_37908().field_9236;
        int currentTab = 0;
        if (isClient) {
            class_746 client = class_310.method_1551().field_1724;
            if (client != null && client.field_7512 instanceof ScreenAccessor) {
                currentTab = ((ScreenAccessor)client.field_7512).getCurrentTab();
            }
        } else {
            int n = currentTab = this.field_7809.method_5438(1).method_31574(ModItems.RUNE_ENCHANT) ? 1 : 0;
        }
        if (currentTab == 1 && stack.method_7942()) {
            ArrayList<class_1889> existingEnchants = new ArrayList<class_1889>();
            class_9304 component = stack.method_58657();
            for (class_6880 entry : component.method_57534()) {
                existingEnchants.add(new class_1889(entry, component.method_57536(entry)));
            }
            cir.setReturnValue(existingEnchants);
        } else {
            this.field_7811.method_43052((long)(this.field_7814.method_17407() + slot));
            Optional optional = registryManager.method_30530(class_7924.field_41265).method_46733(class_9636.field_51547);
            if (optional.isEmpty()) {
                cir.setReturnValue(List.of());
            } else {
                List list = class_1890.method_8230((class_5819)this.field_7811, (class_1799)stack, (int)level, (Stream)((class_6885.class_6888)optional.get()).method_40239());
                if (stack.method_31574(class_1802.field_8529) && list.size() > 1) {
                    list.remove(this.field_7811.method_43048(list.size()));
                }
                cir.setReturnValue((Object)list);
            }
        }
    }

    @Inject(method={"onButtonClick"}, at={@At(value="HEAD")}, cancellable=true)
    private void onButtonClick(@NotNull class_1657 player, int id, CallbackInfoReturnable<Boolean> cir) {
        System.out.println("[DEBUG] Handling click for button " + id);
        if (this.cachedPlayer == null || this.cachedPlayer != player) {
            System.out.println("[DEBUG] Invalid player or cached player mismatch");
            cir.setReturnValue((Object)false);
            return;
        }
        class_1718 handler = (class_1718)this;
        class_1799 runeStack = handler.method_7611(1).method_7677();
        boolean isRuneTab = runeStack.method_31574(ModItems.RUNE_ENCHANT);
        if (!isRuneTab) {
            return;
        }
        class_6880<class_1887> selectedEnchantmentEntry = this.buttonEnchantmentEntries[id];
        int targetLevel = handler.field_7810[id];
        if (selectedEnchantmentEntry == null || targetLevel < 1) {
            System.out.println("[DEBUG] No enchantment entry or invalid target level (" + targetLevel + ") for button " + id);
            cir.setReturnValue((Object)false);
            return;
        }
        class_1799 itemStack = handler.method_7611(0).method_7677();
        if (!itemStack.method_7942()) {
            System.out.println("[DEBUG] Item has no enchantments to upgrade");
            cir.setReturnValue((Object)false);
            return;
        }
        class_9304 itemEnchantments = itemStack.method_58657();
        int existingLevel = itemEnchantments.method_57536(selectedEnchantmentEntry);
        class_5455 registryManager = this.cachedPlayer.method_56673();
        class_2378 enchantmentRegistry = registryManager.method_30530(class_7924.field_41265);
        if (existingLevel == 0 || existingLevel != targetLevel - 1) {
            System.out.println("[DEBUG] Existing level (" + existingLevel + ") does not match expected previous level (" + (targetLevel - 1) + ") for enchantment " + enchantmentRegistry.method_10221((Object)((class_1887)selectedEnchantmentEntry.comp_349())).toString());
            cir.setReturnValue((Object)false);
            return;
        }
        int runeCost = targetLevel - 1;
        if (runeStack.method_7947() < runeCost) {
            cir.setReturnValue((Object)false);
            return;
        }
        if (!player.method_37908().field_9236) {
            runeStack.method_7934(runeCost);
            itemStack.method_7978(selectedEnchantmentEntry, targetLevel);
            handler.method_7611(0).method_53512(itemStack);
            handler.method_7611(1).method_53512(runeStack);
            handler.method_7623();
            System.out.println("[DEBUG] Successfully upgraded " + enchantmentRegistry.method_10221((Object)((class_1887)selectedEnchantmentEntry.comp_349())).toString() + " to level " + targetLevel);
        }
        cir.setReturnValue((Object)true);
    }
}

