/*
 * Decompiled with CFR 0.152.
 */
package me.poggercity.ezCobwebs;

import java.util.List;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class EzCobwebs
extends JavaPlugin {
    public void onEnable() {
        this.saveDefaultConfig();
        this.registerCobwebRecipe();
    }

    private void registerCobwebRecipe() {
        FileConfiguration config = this.getConfig();
        List shape = config.getStringList("shape");
        if (shape.size() != 3) {
            this.getLogger().warning("Invalid recipe shape. Must contain exactly 3 strings.");
            return;
        }
        ItemStack result = new ItemStack(Material.COBWEB);
        NamespacedKey key = new NamespacedKey((Plugin)this, "custom_cobweb");
        ShapedRecipe recipe = new ShapedRecipe(key, result);
        recipe.shape(shape.toArray(new String[0]));
        if (config.isConfigurationSection("ingredients")) {
            Set keys = config.getConfigurationSection("ingredients").getKeys(false);
            for (String keyChar : keys) {
                String matName = config.getString("ingredients." + keyChar);
                Material mat = Material.matchMaterial((String)matName);
                if (mat == null) {
                    this.getLogger().warning("Invalid material: " + matName);
                    continue;
                }
                if (keyChar.length() != 1) {
                    this.getLogger().warning("Invalid key: " + keyChar + ". Keys must be a single character.");
                    continue;
                }
                recipe.setIngredient(keyChar.charAt(0), mat);
            }
        }
        Bukkit.addRecipe((Recipe)recipe);
        this.getLogger().info("Custom cobweb recipe registered!");
    }

    public void onDisable() {
    }
}

