/*
 * Decompiled with CFR 0.152.
 */
package com.elytraenchants;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.command.TabExecutor;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.enchantment.EnchantItemEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.inventory.PrepareAnvilEvent;
import org.bukkit.inventory.AnvilInventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class ElytraEnchantsPlugin
extends JavaPlugin
implements Listener,
TabExecutor {
    private final Set<Enchantment> allowedEnchantments = new HashSet<Enchantment>();
    private YamlConfiguration messages;

    public void onEnable() {
        this.saveDefaultConfig();
        this.loadAllowedEnchantments();
        this.loadMessages();
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getCommand("elytraenchant").setExecutor((CommandExecutor)this);
        this.getCommand("elytraenchant").setTabCompleter((TabCompleter)this);
        this.getLogger().info("ElytraEnchantsPlugin enabled!");
    }

    private void loadAllowedEnchantments() {
        this.allowedEnchantments.clear();
        FileConfiguration config = this.getConfig();
        if (config.isConfigurationSection("enchantments")) {
            for (String key : config.getConfigurationSection("enchantments").getKeys(false)) {
                Enchantment ench;
                if (!config.getBoolean("enchantments." + key, true) || (ench = Enchantment.getByName((String)key)) == null) continue;
                this.allowedEnchantments.add(ench);
            }
        }
    }

    private void loadMessages() {
        File messagesFile = new File(this.getDataFolder(), "messages.yml");
        if (!messagesFile.exists()) {
            this.saveResource("messages.yml", false);
        }
        this.messages = YamlConfiguration.loadConfiguration((File)messagesFile);
    }

    private String msg(String key) {
        String raw = this.messages.getString(key, "");
        return ChatColor.translateAlternateColorCodes((char)'&', (String)raw);
    }

    public void reloadConfig() {
        super.reloadConfig();
        this.loadAllowedEnchantments();
    }

    public void onDisable() {
        this.getLogger().info("ElytraEnchantsPlugin disabled!");
    }

    @EventHandler
    public void onEnchantItem(EnchantItemEvent event) {
        ItemStack item = event.getItem();
        if (item.getType() != Material.ELYTRA) {
            return;
        }
        Map enchantments = event.getEnchantsToAdd();
        for (Enchantment ench : this.allowedEnchantments) {
            if (!enchantments.containsKey(ench)) continue;
            item.addUnsafeEnchantment(ench, ((Integer)enchantments.get(ench)).intValue());
        }
    }

    @EventHandler
    public void onPrepareAnvil(PrepareAnvilEvent event) {
        AnvilInventory inv = event.getInventory();
        ItemStack first = inv.getItem(0);
        ItemStack second = inv.getItem(1);
        String rename = event.getInventory().getRenameText();
        if (first == null) {
            return;
        }
        if (first.getType() == Material.ELYTRA && second != null && second.getType() == Material.ELYTRA) {
            ItemStack result = first.clone();
            boolean changed = false;
            HashMap<Enchantment, Integer> all = new HashMap<Enchantment, Integer>();
            all.putAll(first.getEnchantments());
            for (Map.Entry entry : second.getEnchantments().entrySet()) {
                all.merge((Enchantment)entry.getKey(), (Integer)entry.getValue(), Math::max);
            }
            for (Map.Entry entry : all.entrySet()) {
                result.addUnsafeEnchantment((Enchantment)entry.getKey(), ((Integer)entry.getValue()).intValue());
                changed = true;
            }
            if (rename != null && !rename.isEmpty()) {
                ItemMeta meta = result.getItemMeta();
                meta.setDisplayName(rename);
                result.setItemMeta(meta);
            }
            if (changed) {
                event.setResult(result);
                inv.setRepairCost(10);
            }
            return;
        }
        if (first.getType() == Material.ELYTRA && second != null && second.getType() == Material.ENCHANTED_BOOK && second.hasItemMeta()) {
            ItemStack result = first.clone();
            boolean changed = false;
            EnchantmentStorageMeta bookMeta = (EnchantmentStorageMeta)second.getItemMeta();
            for (Map.Entry entry : bookMeta.getStoredEnchants().entrySet()) {
                Enchantment ench = (Enchantment)entry.getKey();
                int level = (Integer)entry.getValue();
                if (!this.allowedEnchantments.contains(ench)) continue;
                result.addUnsafeEnchantment(ench, level);
                changed = true;
            }
            if (rename != null && !rename.isEmpty()) {
                ItemMeta meta = result.getItemMeta();
                meta.setDisplayName(rename);
                result.setItemMeta(meta);
            }
            if (changed) {
                event.setResult(result);
                inv.setRepairCost(5);
            }
        } else if (first.getType() == Material.ELYTRA && second != null && this.isChestplate(second.getType())) {
            ItemStack result = first.clone();
            boolean changed = false;
            for (Map.Entry entry : second.getEnchantments().entrySet()) {
                Enchantment ench = (Enchantment)entry.getKey();
                int level = (Integer)entry.getValue();
                if (!this.allowedEnchantments.contains(ench)) continue;
                result.addUnsafeEnchantment(ench, level);
                changed = true;
            }
            if (rename != null && !rename.isEmpty()) {
                ItemMeta meta = result.getItemMeta();
                meta.setDisplayName(rename);
                result.setItemMeta(meta);
            }
            if (changed) {
                event.setResult(result);
                inv.setRepairCost(10);
            }
        } else if (!(first.getType() != Material.ELYTRA || second != null && second.getType() != Material.AIR || rename == null || rename.isEmpty() || first.getItemMeta().hasDisplayName())) {
            ItemStack result = first.clone();
            ItemMeta meta = result.getItemMeta();
            meta.setDisplayName(rename);
            result.setItemMeta(meta);
            event.setResult(result);
            inv.setRepairCost(1);
        }
    }

    private boolean isChestplate(Material mat) {
        return mat == Material.DIAMOND_CHESTPLATE || mat == Material.NETHERITE_CHESTPLATE || mat == Material.IRON_CHESTPLATE || mat == Material.GOLDEN_CHESTPLATE || mat == Material.LEATHER_CHESTPLATE || mat == Material.CHAINMAIL_CHESTPLATE;
    }

    @EventHandler
    public void onEntityDamage(EntityDamageEvent event) {
        int projProt;
        int blastProt;
        int fireProt;
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        ItemStack chest = player.getInventory().getChestplate();
        if (chest == null || chest.getType() != Material.ELYTRA) {
            return;
        }
        double reduction = 0.0;
        int prot = chest.getEnchantmentLevel(Enchantment.PROTECTION_ENVIRONMENTAL);
        if (prot > 0) {
            reduction += 0.04 * (double)prot;
        }
        if ((fireProt = chest.getEnchantmentLevel(Enchantment.PROTECTION_FIRE)) > 0 && (event.getCause() == EntityDamageEvent.DamageCause.FIRE || event.getCause() == EntityDamageEvent.DamageCause.FIRE_TICK || event.getCause() == EntityDamageEvent.DamageCause.LAVA)) {
            reduction += 0.08 * (double)fireProt;
        }
        if ((blastProt = chest.getEnchantmentLevel(Enchantment.PROTECTION_EXPLOSIONS)) > 0 && (event.getCause() == EntityDamageEvent.DamageCause.BLOCK_EXPLOSION || event.getCause() == EntityDamageEvent.DamageCause.ENTITY_EXPLOSION)) {
            reduction += 0.08 * (double)blastProt;
        }
        if ((projProt = chest.getEnchantmentLevel(Enchantment.PROTECTION_PROJECTILE)) > 0 && event.getCause() == EntityDamageEvent.DamageCause.PROJECTILE) {
            reduction += 0.08 * (double)projProt;
        }
        if (reduction > 0.8) {
            reduction = 0.8;
        }
        double newDamage = event.getDamage() * (1.0 - reduction);
        event.setDamage(newDamage);
    }

    @EventHandler
    public void onEntityDamageByEntity(EntityDamageByEntityEvent event) {
        Entity entity;
        Entity entity2 = event.getEntity();
        if (!(entity2 instanceof Player)) {
            return;
        }
        Player player = (Player)entity2;
        ItemStack chest = player.getInventory().getChestplate();
        if (chest == null || chest.getType() != Material.ELYTRA) {
            return;
        }
        int thorns = chest.getEnchantmentLevel(Enchantment.THORNS);
        if (thorns > 0 && (entity = event.getDamager()) instanceof LivingEntity) {
            LivingEntity attacker = (LivingEntity)entity;
            double chance = 0.15 + 0.15 * (double)thorns;
            if (Math.random() < chance) {
                attacker.damage(1.0, (Entity)player);
            }
        }
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        int level;
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.msg("not-a-player"));
            return true;
        }
        Player player = (Player)sender;
        if (!sender.hasPermission("elytraenchant.use")) {
            sender.sendMessage(this.msg("no-permission"));
            return true;
        }
        if (args.length < 2) {
            sender.sendMessage(this.msg("usage"));
            return true;
        }
        ItemStack chest = player.getInventory().getChestplate();
        if (chest == null || chest.getType() != Material.ELYTRA) {
            sender.sendMessage(this.msg("not-wearing-elytra"));
            return true;
        }
        String enchName = args[0].toUpperCase();
        Enchantment ench = Enchantment.getByName((String)enchName);
        if (ench == null || !this.allowedEnchantments.contains(ench)) {
            sender.sendMessage(this.msg("enchant-not-allowed"));
            return true;
        }
        String permNode = "elytraenchant.enchant." + enchName.toLowerCase();
        if (!sender.hasPermission(permNode) && !sender.hasPermission("elytraenchant.enchant.*")) {
            sender.sendMessage(this.msg("no-permission-enchant"));
            return true;
        }
        try {
            level = Integer.parseInt(args[1]);
        }
        catch (NumberFormatException e) {
            sender.sendMessage(this.msg("invalid-level"));
            return true;
        }
        chest.addUnsafeEnchantment(ench, level);
        sender.sendMessage(this.msg("success").replace("%enchant%", ench.getKey().getKey()).replace("%level%", String.valueOf(level)));
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (command.getName().equalsIgnoreCase("elytraenchant")) {
            if (args.length == 1) {
                return this.allowedEnchantments.stream().map(e -> e.getName().toLowerCase()).filter(e -> e.startsWith(args[0].toLowerCase())).collect(Collectors.toList());
            }
            if (args.length == 2) {
                return List.of("1", "2", "3", "4", "5").stream().filter(l -> l.startsWith(args[1])).collect(Collectors.toList());
            }
        }
        return List.of();
    }
}

