/*
 * Decompiled with CFR 0.152.
 */
package net.hexagonelle.applesaplings;

import com.mojang.logging.LogUtils;
import net.hexagonelle.applesaplings.Config;
import net.hexagonelle.applesaplings.blocks.ModBlocks;
import net.hexagonelle.applesaplings.blocks.entity.ModBlockEntities;
import net.hexagonelle.applesaplings.entities.ModEntities;
import net.hexagonelle.applesaplings.entities.client.ModBoatRenderer;
import net.hexagonelle.applesaplings.items.ModCreativeTabs;
import net.hexagonelle.applesaplings.items.ModItems;
import net.hexagonelle.applesaplings.plugins.applecrates.blocks.entity.CrateCompat;
import net.hexagonelle.applesaplings.util.ModWoodTypes;
import net.hexagonelle.applesaplings.worldgen.tree.decorators.ModTreeDecorators;
import net.hexagonelle.applesaplings.worldgen.tree.foliage.ModFoliagePlacers;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import org.slf4j.Logger;

@Mod(value="applesaplings")
public class AppleSaplings {
    public static final String MODID = "applesaplings";
    private static final Logger LOGGER = LogUtils.getLogger();

    public AppleSaplings() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::commonSetup);
        MinecraftForge.EVENT_BUS.register((Object)this);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC);
        ModCreativeTabs.register(modEventBus);
        ModItems.register(modEventBus);
        ModBlocks.register(modEventBus);
        ModBlockEntities.register(modEventBus);
        ModEntities.register(modEventBus);
        ModFoliagePlacers.register(modEventBus);
        ModTreeDecorators.register(modEventBus);
        if (ModList.get().isLoaded("applecrates")) {
            MinecraftForge.EVENT_BUS.register(CrateCompat.class);
            CrateCompat.init();
        }
        modEventBus.addListener(this::addCreative);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        LOGGER.info("HELLO FROM COMMON SETUP");
        if (Config.logDirtBlock) {
            LOGGER.info("DIRT BLOCK >> {}", (Object)ForgeRegistries.BLOCKS.getKey((Object)Blocks.f_50493_));
        }
        LOGGER.info("{}{}", (Object)Config.magicNumberIntroduction, (Object)Config.magicNumber);
        Config.items.forEach(item -> LOGGER.info("ITEM >> {}", (Object)item.toString()));
    }

    private void addCreative(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.f_256788_) {
            event.m_246326_((ItemLike)ModBlocks.APPLE_SAPLING.get());
        }
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        LOGGER.info("HELLO from server starting");
    }

    @Mod.EventBusSubscriber(modid="applesaplings", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            LOGGER.info("HELLO FROM CLIENT SETUP");
            LOGGER.info("MINECRAFT NAME >> {}", (Object)Minecraft.m_91087_().m_91094_().m_92546_());
            Sheets.addWoodType((WoodType)ModWoodTypes.APPLEWOOD);
            EntityRenderers.m_174036_((EntityType)((EntityType)ModEntities.MOD_BOAT.get()), context -> new ModBoatRenderer(context, false));
            EntityRenderers.m_174036_((EntityType)((EntityType)ModEntities.MOD_CHEST_BOAT.get()), context -> new ModBoatRenderer(context, true));
        }
    }
}

