/*
 * Decompiled with CFR 0.152.
 */
package net.hexagonelle.applesaplings.blocks.custom;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.ForgeHooks;
import org.jetbrains.annotations.NotNull;

public class FloweringLeavesBlock
extends LeavesBlock {
    public static final int MAX_AGE = 3;
    public static Item FRUIT_ITEM = Items.f_42410_;
    public static final IntegerProperty AGE = BlockStateProperties.f_61407_;
    private static final float growthSpeed = 3.0f;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;

    public FloweringLeavesBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_54418_, (Comparable)Integer.valueOf(1))).m_61124_((Property)f_54419_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)AGE, (Comparable)Integer.valueOf(0))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public int getAge(BlockState blockState) {
        return (Integer)blockState.m_61143_((Property)this.getAgeProperty());
    }

    public int getMaxAge() {
        return 3;
    }

    protected boolean growing(BlockState currentBlockState) {
        return this.getAge(currentBlockState) < this.getMaxAge();
    }

    public boolean m_6724_(@NotNull BlockState currentBlockState) {
        return this.m_221385_(currentBlockState) || this.growing(currentBlockState);
    }

    public boolean isFlammable(BlockState blockstate, BlockGetter level, BlockPos blockPos, Direction direction) {
        return true;
    }

    public int getFlammability(BlockState blockstate, BlockGetter level, BlockPos blockPos, Direction direction) {
        return 60;
    }

    public int getFireSpreadSpeed(BlockState blockstate, BlockGetter level, BlockPos blockPos, Direction direction) {
        return 30;
    }

    public IntegerProperty getAgeProperty() {
        return AGE;
    }

    public BlockState getStateForAge(int givenAge) {
        return (BlockState)this.m_49966_().m_61124_((Property)AGE, (Comparable)Integer.valueOf(givenAge));
    }

    public void m_213898_(@NotNull BlockState currentBlockState, @NotNull ServerLevel serverLevel, @NotNull BlockPos blockPosition, @NotNull RandomSource random) {
        if (this.m_221385_(currentBlockState)) {
            FloweringLeavesBlock.m_49950_((BlockState)currentBlockState, (Level)serverLevel, (BlockPos)blockPosition);
            serverLevel.m_7471_(blockPosition, false);
        } else if (this.growing(currentBlockState) && ForgeHooks.onCropsGrowPre((Level)serverLevel, (BlockPos)blockPosition, (BlockState)currentBlockState, (random.m_188503_(9) == 0 ? 1 : 0) != 0)) {
            serverLevel.m_7731_(blockPosition, this.getStateForAge(this.getAge(currentBlockState) + 1), 2);
            ForgeHooks.onCropsGrowPost((Level)serverLevel, (BlockPos)blockPosition, (BlockState)currentBlockState);
        }
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState currentBlockState, @NotNull Level serverLevel, @NotNull BlockPos blockPos, @NotNull Player player, @NotNull InteractionHand handIn, @NotNull BlockHitResult hit) {
        if (this.getAge(currentBlockState) == this.getMaxAge()) {
            Direction hitDirection = hit.m_82434_();
            BlockPos spawnApplePos = blockPos.m_121945_(hitDirection);
            System.out.println("BlockPosition:" + blockPos.m_123341_() + "," + blockPos.m_123342_() + "," + blockPos.m_123343_());
            System.out.println("HitDirection:" + hitDirection);
            System.out.println("SpawnApplePosition:" + spawnApplePos.m_123341_() + "," + spawnApplePos.m_123342_() + "," + spawnApplePos.m_123343_());
            ItemEntity droppedFruit = new ItemEntity(serverLevel, (double)spawnApplePos.m_123341_() + 0.5, (double)spawnApplePos.m_123342_() + 0.5, (double)spawnApplePos.m_123343_() + 0.5, new ItemStack((ItemLike)FRUIT_ITEM, 1));
            droppedFruit.m_20000_((ItemLike)FRUIT_ITEM, 0);
            serverLevel.m_7731_(blockPos, this.getStateForAge(0), 1);
            return InteractionResult.SUCCESS;
        }
        return super.m_6227_(currentBlockState, serverLevel, blockPos, player, handIn, hit);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_54418_, f_54419_, WATERLOGGED, AGE});
    }
}

