/*
 * Decompiled with CFR 0.152.
 */
package net.hexagonelle.applesaplings.datagen.models;

import net.hexagonelle.applesaplings.blocks.ModBlocks;
import net.hexagonelle.applesaplings.items.ModItems;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.RegistryObject;

public class ModItemModelProvider
extends ItemModelProvider {
    public ModItemModelProvider(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "applesaplings", existingFileHelper);
    }

    private String itemName(RegistryObject<Item> itemRegistryObject) {
        return itemRegistryObject.getId().m_135815_();
    }

    private String blockName(RegistryObject<Block> blockRegistryObject) {
        return blockRegistryObject.getId().m_135815_();
    }

    private ResourceLocation itemResource(RegistryObject<Item> itemRegistryObject) {
        return this.modLoc("item/" + this.itemName(itemRegistryObject));
    }

    private ResourceLocation blockResource(RegistryObject<Block> blockRegistryObject) {
        return this.modLoc("block/" + this.blockName(blockRegistryObject));
    }

    private ResourceLocation blockItemResource(RegistryObject<Block> blockRegistryObject) {
        return this.modLoc("item/" + this.blockName(blockRegistryObject));
    }

    private ItemModelBuilder flatItemModel(String name, ResourceLocation texture) {
        return (ItemModelBuilder)this.singleTexture(name, new ResourceLocation("item/generated"), "layer0", texture);
    }

    private ItemModelBuilder mcItemModel(String name, String mcModelName, ResourceLocation texture) {
        return (ItemModelBuilder)this.singleTexture(name, this.mcLoc(mcModelName), "texture", texture);
    }

    private ItemModelBuilder simpleItem(RegistryObject<Item> itemRegistryObject) {
        return this.flatItemModel(this.itemName(itemRegistryObject), this.itemResource(itemRegistryObject));
    }

    private ItemModelBuilder blockItemWithItemTexture(RegistryObject<Block> blockRegistryObject) {
        return this.flatItemModel(this.blockName(blockRegistryObject), this.blockItemResource(blockRegistryObject));
    }

    public void blockItemWithBlockTexture(RegistryObject<Block> blockRegistryObject) {
        this.withExistingParent(this.blockName(blockRegistryObject), this.blockResource(blockRegistryObject));
    }

    public void blockItemWithFlatBlockTexture(RegistryObject<Block> blockRegistryObject) {
        this.flatItemModel(this.blockName(blockRegistryObject), this.blockResource(blockRegistryObject));
    }

    public void trapdoorItem(RegistryObject<Block> blockRegistryObject) {
        this.withExistingParent(this.blockName(blockRegistryObject), this.modLoc("block/" + this.blockName(blockRegistryObject) + "_bottom"));
    }

    public void fenceItem(RegistryObject<Block> blockRegistryObject, RegistryObject<Block> baseBlockRegistryObject) {
        this.mcItemModel(this.blockName(blockRegistryObject), "block/fence_inventory", this.blockResource(baseBlockRegistryObject));
    }

    public void buttonItem(RegistryObject<Block> blockRegistryObject, RegistryObject<Block> baseBlockRegistryObject) {
        this.mcItemModel(this.blockName(blockRegistryObject), "block/button_inventory", this.blockResource(baseBlockRegistryObject));
    }

    protected void registerModels() {
        this.blockItemWithFlatBlockTexture(ModBlocks.APPLE_SAPLING);
        this.simpleItem(ModItems.APPLEWOOD_SIGN);
        this.simpleItem(ModItems.APPLEWOOD_HANGING_SIGN);
        this.blockItemWithBlockTexture(ModBlocks.APPLEWOOD_STAIRS);
        this.blockItemWithBlockTexture(ModBlocks.APPLEWOOD_SLAB);
        this.buttonItem(ModBlocks.APPLEWOOD_BUTTON, ModBlocks.APPLEWOOD_PLANKS);
        this.blockItemWithBlockTexture(ModBlocks.APPLEWOOD_PRESSURE_PLATE);
        this.fenceItem(ModBlocks.APPLEWOOD_FENCE, ModBlocks.APPLEWOOD_PLANKS);
        this.blockItemWithBlockTexture(ModBlocks.APPLEWOOD_FENCE_GATE);
        this.blockItemWithItemTexture(ModBlocks.APPLEWOOD_DOOR);
        this.trapdoorItem(ModBlocks.APPLEWOOD_TRAPDOOR);
        this.simpleItem(ModItems.APPLEWOOD_BOAT);
        this.simpleItem(ModItems.APPLEWOOD_CHEST_BOAT);
    }
}

