/*
 * Decompiled with CFR 0.152.
 */
package net.hexagonelle.applesaplings.worldgen;

import java.util.List;
import net.hexagonelle.applesaplings.blocks.ModBlocks;
import net.hexagonelle.applesaplings.worldgen.tree.decorators.FloweringLeavesDecorator;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.featuresize.FeatureSize;
import net.minecraft.world.level.levelgen.feature.featuresize.TwoLayersFeatureSize;
import net.minecraft.world.level.levelgen.feature.foliageplacers.BlobFoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.trunkplacers.StraightTrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraftforge.registries.RegistryObject;

public class ModConfiguredFeatures {
    private static final TreeConfiguration appleTreeBuilder = ModConfiguredFeatures.floweringTreeBuilder(ModBlocks.APPLEWOOD_LOG, ModBlocks.APPLE_LEAVES, ModBlocks.FLOWERING_APPLE_LEAVES, Float.valueOf(0.1f), 3);
    public static final ResourceKey<ConfiguredFeature<?, ?>> APPLE_TREE = ModConfiguredFeatures.registerKey("apple_tree");

    public static ResourceKey<ConfiguredFeature<?, ?>> registerKey(String name) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)new ResourceLocation("applesaplings", name));
    }

    public static <FC extends FeatureConfiguration, F extends Feature<FC>> void register(BootstapContext<ConfiguredFeature<?, ?>> context, ResourceKey<ConfiguredFeature<?, ?>> key, F feature, FC configuration) {
        context.m_255272_(key, (Object)new ConfiguredFeature(feature, configuration));
    }

    private static IntProvider constIntProvider(int integer) {
        return ConstantInt.m_146483_((int)integer);
    }

    private static List<TreeDecorator> createFloweringDecorator(Float spawnChance, int spawnAttempts, RegistryObject<Block> block) {
        return List.of(new FloweringLeavesDecorator(spawnChance.floatValue(), spawnAttempts, (BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)block.get()))));
    }

    private static TreeConfiguration floweringTreeBuilder(RegistryObject<Block> treeTrunk, RegistryObject<Block> leavesBlock, RegistryObject<Block> floweringLeavesBlock, Float floweringChance, int floweringRolls) {
        return new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)treeTrunk.get())), (TrunkPlacer)new StraightTrunkPlacer(5, 2, 1), (BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)leavesBlock.get())), (FoliagePlacer)new BlobFoliagePlacer(ModConfiguredFeatures.constIntProvider(3), ModConfiguredFeatures.constIntProvider(0), 3), (FeatureSize)new TwoLayersFeatureSize(1, 0, 2)).m_68249_(ModConfiguredFeatures.createFloweringDecorator(floweringChance, floweringRolls, floweringLeavesBlock)).m_68251_();
    }

    public static void bootstrap(BootstapContext<ConfiguredFeature<?, ?>> context) {
        ModConfiguredFeatures.register(context, APPLE_TREE, Feature.f_65760_, appleTreeBuilder);
    }
}

