/*
 * Decompiled with CFR 0.152.
 */
package net.hexagonelle.applesaplings.worldgen.tree.decorators;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.hexagonelle.applesaplings.worldgen.tree.decorators.ModTreeDecorators;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;
import org.jetbrains.annotations.NotNull;

public class FloweringLeavesDecorator
extends TreeDecorator {
    public static final Codec<FloweringLeavesDecorator> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("probability").forGetter(instance -> Float.valueOf(instance.probability)), (App)Codec.intRange((int)1, (int)16).fieldOf("rolls").forGetter(instance -> instance.rolls), (App)BlockStateProvider.f_68747_.fieldOf("floweringLeaves").forGetter(instance -> instance.floweringLeavesProvider)).apply((Applicative)builder, FloweringLeavesDecorator::new));
    protected final float probability;
    protected final int rolls;
    protected final BlockStateProvider floweringLeavesProvider;

    public FloweringLeavesDecorator(float spawnChance, int spawnAttempts, BlockStateProvider blockProvider) {
        this.probability = spawnChance;
        this.rolls = spawnAttempts;
        this.floweringLeavesProvider = blockProvider;
    }

    private boolean isAirInDirection(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull TreeDecorator.Context context, BlockPos blockPos, Direction direction) {
        return context.m_226059_(blockPos.m_121945_(direction));
    }

    private boolean isAirAdjacent(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull TreeDecorator.Context context, BlockPos blockPos) {
        return this.isAirInDirection(context, blockPos, Direction.NORTH) || this.isAirInDirection(context, blockPos, Direction.EAST) || this.isAirInDirection(context, blockPos, Direction.SOUTH) || this.isAirInDirection(context, blockPos, Direction.WEST) || this.isAirInDirection(context, blockPos, Direction.UP) || this.isAirInDirection(context, blockPos, Direction.DOWN);
    }

    @NotNull
    protected TreeDecoratorType<?> m_6663_() {
        return (TreeDecoratorType)ModTreeDecorators.FLOWERING_LEAVES.get();
    }

    public void m_214187_(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull TreeDecorator.Context context) {
        RandomSource randomSource = context.m_226067_();
        ObjectArrayList leavesList = context.m_226069_();
        List<BlockPos> spawnOptions = leavesList.stream().filter(positionOption -> this.isAirAdjacent(context, (BlockPos)positionOption)).toList();
        if (!spawnOptions.isEmpty()) {
            spawnOptions.forEach(option -> {
                for (int k = 0; k < this.rolls; ++k) {
                    if (!(randomSource.m_188501_() < this.probability)) continue;
                    BlockPos blockPos = new BlockPos(option.m_123341_(), option.m_123342_(), option.m_123343_());
                    context.m_226061_(blockPos, this.floweringLeavesProvider.m_213972_(randomSource, blockPos));
                }
            });
        }
    }
}

