/*
 * Decompiled with CFR 0.152.
 */
package net.hexagonelle.applesaplings.blocks;

import net.hexagonelle.applesaplings.blocks.custom.CustomWood;
import net.hexagonelle.applesaplings.blocks.custom.FloweringLeavesBlock;
import net.hexagonelle.applesaplings.blocks.custom.ModCeilingHangingSignBlock;
import net.hexagonelle.applesaplings.blocks.custom.ModStandingSignBlock;
import net.hexagonelle.applesaplings.blocks.custom.ModWallHangingSignBlock;
import net.hexagonelle.applesaplings.blocks.custom.ModWallSignBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.grower.AbstractTreeGrower;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraftforge.registries.RegistryObject;

public class BlockCreator {
    public static SaplingBlock createSapling(AbstractTreeGrower treeGrower) {
        return new SaplingBlock(treeGrower, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50746_));
    }

    public static FloweringLeavesBlock createFloweringLeaves() {
        return new FloweringLeavesBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50050_));
    }

    public static Block createWoodOrLogBlock(Block copyFrom, RegistryObject<Block> strippedBlock) {
        return new CustomWood(BlockBehaviour.Properties.m_60926_((BlockBehaviour)copyFrom).m_60978_(2.0f)).setStrippedVersion((Block)strippedBlock.get());
    }

    public static Block createWoodOrLogBlock(Block copyFrom) {
        return new CustomWood(BlockBehaviour.Properties.m_60926_((BlockBehaviour)copyFrom).m_60978_(2.0f)).setIsStripped(true);
    }

    public static Block createPlanks() {
        return new CustomWood(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_));
    }

    public static Block createLeaves() {
        return new LeavesBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50050_)){

            public boolean isFlammable(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                return true;
            }

            public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                return 60;
            }

            public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                return 30;
            }
        };
    }

    public static Block createSign(WoodType woodType) {
        return new ModStandingSignBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50095_), woodType);
    }

    public static Block createWallSign(WoodType woodType) {
        return new ModWallSignBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50158_), woodType);
    }

    public static Block createHangingSign(WoodType woodType) {
        return new ModCeilingHangingSignBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_244319_), woodType);
    }

    public static Block createWallHangingSign(WoodType woodType) {
        return new ModWallHangingSignBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_244093_), woodType);
    }

    public static Block createWoodStairBlock(RegistryObject<Block> baseBlock) {
        return new StairBlock(() -> ((Block)baseBlock.get()).m_49966_(), BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50086_));
    }

    public static Block createWoodSlabBlock() {
        return new SlabBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50398_));
    }

    public static Block createWoodButton() {
        return new ButtonBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50251_), BlockSetType.f_271198_, 10, true);
    }

    public static Block createWoodPressurePlate() {
        return new PressurePlateBlock(PressurePlateBlock.Sensitivity.EVERYTHING, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50167_), BlockSetType.f_271198_);
    }

    public static Block createWoodFenceBlock() {
        return new FenceBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50132_));
    }

    public static Block createWoodFenceGateBlock() {
        return new FenceGateBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50132_), SoundEvents.f_11873_, SoundEvents.f_11872_);
    }

    public static Block createWoodDoorBlock() {
        return new DoorBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50154_).m_60955_(), BlockSetType.f_271198_);
    }

    public static Block createWoodTrapDoorBlock() {
        return new TrapDoorBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50216_).m_60955_(), BlockSetType.f_271198_);
    }
}

