/*
 * Decompiled with CFR 0.152.
 */
package net.hexagonelle.applesaplings.blocks;

import java.util.function.Supplier;
import net.hexagonelle.applesaplings.blocks.BlockCreator;
import net.hexagonelle.applesaplings.items.ItemCreator;
import net.hexagonelle.applesaplings.items.ModItems;
import net.hexagonelle.applesaplings.util.ModWoodTypes;
import net.hexagonelle.applesaplings.worldgen.tree.AppleTreeGrower;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class ModBlocks {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"applesaplings");
    public static final RegistryObject<Block> APPLE_SAPLING = ModBlocks.registerBlockWithItem("apple_sapling", () -> BlockCreator.createSapling(new AppleTreeGrower()));
    public static final RegistryObject<Block> APPLE_LEAVES = ModBlocks.registerBlockWithItem("apple_leaves", BlockCreator::createLeaves);
    public static final RegistryObject<Block> FLOWERING_APPLE_LEAVES = ModBlocks.registerBlockWithItem("flowering_apple_leaves", BlockCreator::createFloweringLeaves);
    public static final RegistryObject<Block> STRIPPED_APPLEWOOD_LOG = ModBlocks.registerBlockWithItem("stripped_applewood_log", () -> BlockCreator.createWoodOrLogBlock(Blocks.f_49999_));
    public static final RegistryObject<Block> STRIPPED_APPLEWOOD_WOOD = ModBlocks.registerBlockWithItem("stripped_applewood_wood", () -> BlockCreator.createWoodOrLogBlock(Blocks.f_50011_));
    public static final RegistryObject<Block> APPLEWOOD_LOG = ModBlocks.registerBlockWithItem("applewood_log", () -> BlockCreator.createWoodOrLogBlock(Blocks.f_49999_, STRIPPED_APPLEWOOD_LOG));
    public static final RegistryObject<Block> APPLEWOOD_WOOD = ModBlocks.registerBlockWithItem("applewood_wood", () -> BlockCreator.createWoodOrLogBlock(Blocks.f_50011_, STRIPPED_APPLEWOOD_WOOD));
    public static final RegistryObject<Block> APPLEWOOD_PLANKS = ModBlocks.registerBlockWithItem("applewood_planks", BlockCreator::createPlanks);
    public static final RegistryObject<Block> APPLEWOOD_SIGN = ModBlocks.registerBlock("applewood_sign", () -> BlockCreator.createSign(ModWoodTypes.APPLEWOOD));
    public static final RegistryObject<Block> APPLEWOOD_WALL_SIGN = ModBlocks.registerBlock("applewood_wall_sign", () -> BlockCreator.createWallSign(ModWoodTypes.APPLEWOOD));
    public static final RegistryObject<Block> APPLEWOOD_HANGING_SIGN = ModBlocks.registerBlock("applewood_hanging_sign", () -> BlockCreator.createHangingSign(ModWoodTypes.APPLEWOOD));
    public static final RegistryObject<Block> APPLEWOOD_WALL_HANGING_SIGN = ModBlocks.registerBlock("applewood_wall_hanging_sign", () -> BlockCreator.createWallHangingSign(ModWoodTypes.APPLEWOOD));
    public static final RegistryObject<Block> APPLEWOOD_STAIRS = ModBlocks.registerBlockWithItem("applewood_stairs", () -> BlockCreator.createWoodStairBlock(APPLEWOOD_PLANKS));
    public static final RegistryObject<Block> APPLEWOOD_SLAB = ModBlocks.registerBlockWithItem("applewood_slab", BlockCreator::createWoodSlabBlock);
    public static final RegistryObject<Block> APPLEWOOD_BUTTON = ModBlocks.registerBlockWithItem("applewood_button", BlockCreator::createWoodButton);
    public static final RegistryObject<Block> APPLEWOOD_PRESSURE_PLATE = ModBlocks.registerBlockWithItem("applewood_pressure_plate", BlockCreator::createWoodPressurePlate);
    public static final RegistryObject<Block> APPLEWOOD_FENCE = ModBlocks.registerBlockWithItem("applewood_fence", BlockCreator::createWoodFenceBlock);
    public static final RegistryObject<Block> APPLEWOOD_FENCE_GATE = ModBlocks.registerBlockWithItem("applewood_fence_gate", BlockCreator::createWoodFenceGateBlock);
    public static final RegistryObject<Block> APPLEWOOD_DOOR = ModBlocks.registerBlockWithItem("applewood_door", BlockCreator::createWoodDoorBlock);
    public static final RegistryObject<Block> APPLEWOOD_TRAPDOOR = ModBlocks.registerBlockWithItem("applewood_trapdoor", BlockCreator::createWoodTrapDoorBlock);

    public static void register(IEventBus eventBus) {
        BLOCKS.register(eventBus);
    }

    private static <T extends Block> RegistryObject<T> registerBlock(String blockID, Supplier<T> block) {
        return BLOCKS.register(blockID, block);
    }

    private static <T extends Block> RegistryObject<T> registerBlockWithItem(String blockID, Supplier<T> block) {
        RegistryObject blockRegistryObject = ModBlocks.registerBlock(blockID, block);
        ModItems.ITEMS.register(blockID, () -> ItemCreator.createBlockItem(blockRegistryObject));
        return blockRegistryObject;
    }
}

