/*
 * Decompiled with CFR 0.152.
 */
package net.hexagonelle.applesaplings.datagen.models;

import java.util.function.Function;
import net.hexagonelle.applesaplings.blocks.ModBlocks;
import net.hexagonelle.applesaplings.blocks.custom.FloweringLeavesBlock;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.RegistryObject;

public class ModBlockStateProvider
extends BlockStateProvider {
    public ModBlockStateProvider(PackOutput output, ExistingFileHelper exFileHelper) {
        super(output, "applesaplings", exFileHelper);
    }

    public static String name(RegistryObject<Block> blockRegistryObject) {
        return blockRegistryObject.getId().m_135815_();
    }

    public static String blockPathName(RegistryObject<Block> blockRegistryObject) {
        return "block/" + ModBlockStateProvider.name(blockRegistryObject);
    }

    public static String blockPathNameWithState(RegistryObject<Block> blockRegistryObject, String state) {
        return ModBlockStateProvider.blockPathName(blockRegistryObject) + state;
    }

    private ResourceLocation blockResource(RegistryObject<Block> blockRegistryObject) {
        return this.modLoc(ModBlockStateProvider.blockPathName(blockRegistryObject));
    }

    private ResourceLocation blockResourceWithState(RegistryObject<Block> blockRegistryObject, String state) {
        return this.modLoc(ModBlockStateProvider.blockPathNameWithState(blockRegistryObject, state));
    }

    private void blockItem(RegistryObject<Block> blockRegistryObject) {
        this.simpleBlockItem((Block)blockRegistryObject.get(), (ModelFile)new ModelFile.UncheckedModelFile(this.blockResource(blockRegistryObject)));
    }

    private void blockItem(RegistryObject<Block> blockRegistryObject, String blockState) {
        this.simpleBlockItem((Block)blockRegistryObject.get(), (ModelFile)new ModelFile.UncheckedModelFile(this.blockResourceWithState(blockRegistryObject, blockState)));
    }

    private ModelFile singleTextureModel(String name, String parent, ResourceLocation texture, String renderAs) {
        return ((BlockModelBuilder)this.models().singleTexture(name, this.mcLoc(parent), "all", texture)).renderType(renderAs);
    }

    private void blockWithItem(RegistryObject<Block> blockRegistryObject, String parent, String renderAs) {
        this.simpleBlockWithItem((Block)blockRegistryObject.get(), this.singleTextureModel(ModBlockStateProvider.name(blockRegistryObject), parent, this.blockTexture((Block)blockRegistryObject.get()), renderAs));
    }

    private void customPlanks(RegistryObject<Block> blockRegistryObject) {
        this.blockWithItem(blockRegistryObject, "block/oak_planks", "solid");
    }

    private void customLeaves(RegistryObject<Block> blockRegistryObject) {
        this.blockWithItem(blockRegistryObject, "block/leaves", "cutout");
    }

    private ConfiguredModel[] floweringLeavesStates(BlockState blockState, RegistryObject<Block> blockRegistryObject) {
        FloweringLeavesBlock floweringLeaves = (FloweringLeavesBlock)((Object)blockRegistryObject.get());
        String blockstateValue = String.valueOf(floweringLeaves.getAge(blockState));
        ConfiguredModel[] models = new ConfiguredModel[]{new ConfiguredModel(this.singleTextureModel(ModBlockStateProvider.blockPathNameWithState(blockRegistryObject, blockstateValue), "block/leaves", this.blockResourceWithState(blockRegistryObject, blockstateValue), "cutout"))};
        return models;
    }

    private void floweringLeavesBlock(RegistryObject<Block> blockRegistryObject) {
        Function<BlockState, ConfiguredModel[]> function = state -> this.floweringLeavesStates((BlockState)state, blockRegistryObject);
        this.getVariantBuilder((Block)blockRegistryObject.get()).forAllStates(function);
        this.blockItem(blockRegistryObject, "0");
    }

    private void customSapling(RegistryObject<Block> blockRegistryObject) {
        this.simpleBlock((Block)blockRegistryObject.get(), (ModelFile)((BlockModelBuilder)this.models().cross(ModBlockStateProvider.name(blockRegistryObject), this.blockTexture((Block)blockRegistryObject.get()))).renderType("cutout"));
    }

    private void customLog(RegistryObject<Block> blockRegistryObject) {
        this.logBlock((RotatedPillarBlock)blockRegistryObject.get());
        this.blockItem(blockRegistryObject);
    }

    private void customWood(RegistryObject<Block> blockRegistryObject, RegistryObject<Block> blockRegistryParentTexture) {
        this.axisBlock((RotatedPillarBlock)blockRegistryObject.get(), this.blockTexture((Block)blockRegistryParentTexture.get()), this.blockTexture((Block)blockRegistryParentTexture.get()));
        this.blockItem(blockRegistryObject);
    }

    public void customSign(RegistryObject<Block> standingSign, RegistryObject<Block> wallSign, RegistryObject<Block> planks) {
        this.signBlock((StandingSignBlock)standingSign.get(), (WallSignBlock)wallSign.get(), this.blockTexture((Block)planks.get()));
    }

    public void customHangingSign(RegistryObject<Block> ceilingHangingSign, RegistryObject<Block> wallHangingSign, RegistryObject<Block> planks) {
        ModelBuilder signModel = this.models().sign(ModBlockStateProvider.name(ceilingHangingSign), this.blockTexture((Block)planks.get()));
        this.simpleBlock((Block)ceilingHangingSign.get(), (ModelFile)signModel);
        this.simpleBlock((Block)wallHangingSign.get(), (ModelFile)signModel);
    }

    public void customStairs(RegistryObject<Block> blockRegistryObject, RegistryObject<Block> baseBlockRegistryObject) {
        this.stairsBlock((StairBlock)blockRegistryObject.get(), this.blockTexture((Block)baseBlockRegistryObject.get()));
    }

    public void customSlab(RegistryObject<Block> blockRegistryObject, RegistryObject<Block> baseBlockRegistryObject) {
        this.slabBlock((SlabBlock)blockRegistryObject.get(), this.blockTexture((Block)baseBlockRegistryObject.get()), this.blockTexture((Block)baseBlockRegistryObject.get()));
    }

    public void customButton(RegistryObject<Block> blockRegistryObject, RegistryObject<Block> baseBlockRegistryObject) {
        this.buttonBlock((ButtonBlock)blockRegistryObject.get(), this.blockTexture((Block)baseBlockRegistryObject.get()));
    }

    public void customPressurePlate(RegistryObject<Block> blockRegistryObject, RegistryObject<Block> baseBlockRegistryObject) {
        this.pressurePlateBlock((PressurePlateBlock)blockRegistryObject.get(), this.blockTexture((Block)baseBlockRegistryObject.get()));
    }

    public void customFence(RegistryObject<Block> blockRegistryObject, RegistryObject<Block> baseBlockRegistryObject) {
        this.fenceBlock((FenceBlock)blockRegistryObject.get(), this.blockTexture((Block)baseBlockRegistryObject.get()));
    }

    public void customFenceGate(RegistryObject<Block> blockRegistryObject, RegistryObject<Block> baseBlockRegistryObject) {
        this.fenceGateBlock((FenceGateBlock)blockRegistryObject.get(), this.blockTexture((Block)baseBlockRegistryObject.get()));
    }

    public void customDoor(RegistryObject<Block> blockRegistryObject) {
        this.doorBlockWithRenderType((DoorBlock)blockRegistryObject.get(), this.blockResourceWithState(blockRegistryObject, "_bottom"), this.blockResourceWithState(blockRegistryObject, "_top"), "cutout");
    }

    public void customTrapdoor(RegistryObject<Block> blockRegistryObject) {
        this.trapdoorBlockWithRenderType((TrapDoorBlock)blockRegistryObject.get(), this.blockResource(blockRegistryObject), true, "cutout");
    }

    protected void registerStatesAndModels() {
        this.customSapling(ModBlocks.APPLE_SAPLING);
        this.customLeaves(ModBlocks.APPLE_LEAVES);
        this.floweringLeavesBlock(ModBlocks.FLOWERING_APPLE_LEAVES);
        this.customLog(ModBlocks.APPLEWOOD_LOG);
        this.customWood(ModBlocks.APPLEWOOD_WOOD, ModBlocks.APPLEWOOD_LOG);
        this.customLog(ModBlocks.STRIPPED_APPLEWOOD_LOG);
        this.customWood(ModBlocks.STRIPPED_APPLEWOOD_WOOD, ModBlocks.STRIPPED_APPLEWOOD_LOG);
        this.customPlanks(ModBlocks.APPLEWOOD_PLANKS);
        this.customSign(ModBlocks.APPLEWOOD_SIGN, ModBlocks.APPLEWOOD_WALL_SIGN, ModBlocks.APPLEWOOD_PLANKS);
        this.customHangingSign(ModBlocks.APPLEWOOD_HANGING_SIGN, ModBlocks.APPLEWOOD_WALL_HANGING_SIGN, ModBlocks.APPLEWOOD_PLANKS);
        this.customStairs(ModBlocks.APPLEWOOD_STAIRS, ModBlocks.APPLEWOOD_PLANKS);
        this.customSlab(ModBlocks.APPLEWOOD_SLAB, ModBlocks.APPLEWOOD_PLANKS);
        this.customButton(ModBlocks.APPLEWOOD_BUTTON, ModBlocks.APPLEWOOD_PLANKS);
        this.customPressurePlate(ModBlocks.APPLEWOOD_PRESSURE_PLATE, ModBlocks.APPLEWOOD_PLANKS);
        this.customFence(ModBlocks.APPLEWOOD_FENCE, ModBlocks.APPLEWOOD_PLANKS);
        this.customFenceGate(ModBlocks.APPLEWOOD_FENCE_GATE, ModBlocks.APPLEWOOD_PLANKS);
        this.customDoor(ModBlocks.APPLEWOOD_DOOR);
        this.customTrapdoor(ModBlocks.APPLEWOOD_TRAPDOOR);
    }
}

